/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JSplitPane;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlRadioButton;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSplitPanel
extends ControlContainer {
    protected JSplitPane splitpanel;
    private boolean hasOne = false;
    private static ArrayList<String> infoList = null;

    public ControlSplitPanel(Object object) {
        super(object);
    }

    @Override
    protected Component createVisual(Object object) {
        if (object instanceof JSplitPane) {
            this.splitpanel = (JSplitPane)object;
        } else {
            this.splitpanel = new JSplitPane();
            this.splitpanel.setOneTouchExpandable(true);
            this.splitpanel.setDividerLocation(-1);
        }
        return this.splitpanel;
    }

    @Override
    public void reset() {
        this.splitpanel.setDividerLocation(-1);
    }

    @Override
    public void add(ControlElement controlElement) {
        if (this.hasOne) {
            this.splitpanel.setBottomComponent(controlElement.getComponent());
            this.splitpanel.setDividerLocation(-1);
        } else {
            this.splitpanel.setTopComponent(controlElement.getComponent());
            this.splitpanel.setDividerLocation(-1);
            this.hasOne = true;
        }
        if (controlElement instanceof ControlRadioButton) {
            this.radioButtons.add(controlElement);
            ((ControlRadioButton)controlElement).setParent(this);
        }
    }

    @Override
    public ArrayList<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("orientation");
            infoList.add("expandable");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("orientation")) {
            return "Orientation|int";
        }
        if (string.equals("expandable")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Orientation") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("vertical")) {
                return new IntegerValue(0);
            }
            if (string2.equals("horizontal")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.splitpanel.getOrientation() == value.getInteger()) break;
                this.splitpanel.setOrientation(value.getInteger());
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.splitpanel.setOrientation(1);
                break;
            }
            case 1: {
                this.splitpanel.setOneTouchExpandable(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }
}

