/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.opensourcephysics.ejs.control.value.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserSuryono {
    private int var_count;
    private String[] var_name;
    private double[] var_value;
    private double[] number;
    private String function = "";
    private String postfix_code = "";
    private boolean valid = false;
    private int error;
    private boolean ISBOOLEAN = false;
    private boolean INRELATION = false;
    private int position;
    private int start;
    private int num;
    private char character;
    private int numberindex;
    private double[] refvalue = null;
    private static final String[] constname = new String[]{"Math.E", "Math.PI"};
    private static final double[] constvalue = new double[]{Math.E, Math.PI};
    private static final String[] funcnameNoParam = new String[]{"Math.random"};
    private static final String[] funcname = new String[]{"Math.abs", "Math.acos", "Math.asin", "Math.atan", "Math.ceil", "Math.cos", "Math.exp", "Math.floor", "Math.log", "Math.rint", "Math.round", "Math.sin", "Math.sqrt", "Math.tan", "Math.toDegrees", "Math.toRadians"};
    private static final String[] extfunc = new String[]{"Math.atan2", "Math.IEEEremainder", "Math.max", "Math.min", "Math.pow"};
    private static final int MAX_NUM = 200;
    private static final int NO_CONST = constname.length;
    private static final int NO_FUNCSNOPARAM = funcnameNoParam.length;
    private static final int NO_FUNCS = funcname.length;
    private static final int NO_EXT_FUNCS = extfunc.length;
    private static final int STACK_SIZE = 50;
    private double[] stack = new double[50];
    private Hashtable<String, String> references = null;
    private Vector<String> refnames = null;
    public static final int NO_ERROR = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int NO_FUNC_DEFINITION = 14;
    public static final int REF_NAME_EXPECTED = 15;
    private static final int FUNC_OFFSET = 1000;
    private static final int EXT_FUNC_OFFSET = 1000 + NO_FUNCS;
    private static final int FUNCNOPARAM_OFFSET = EXT_FUNC_OFFSET + NO_EXT_FUNCS;
    private static final int VAR_OFFSET = 2000;
    private static final int REF_OFFSET = 3000;
    private static final char CONST_OFFSET = '\u00fd';
    private static final char NUMERIC = '\u012c';
    private static final char JUMP_CODE = '\u0001';
    private static final char LESS_THAN = '\u0002';
    private static final char GREATER_THAN = '\u0003';
    private static final char LESS_EQUAL = '\u0004';
    private static final char GREATER_EQUAL = '\u0005';
    private static final char NOT_EQUAL = '\u0006';
    private static final char EQUAL = '\u0007';
    private static final char IF_CODE = '\b';
    private static final char ENDIF = '\t';
    private static final char AND_CODE = '\n';
    private static final char OR_CODE = '\u000b';
    private static final char NOT_CODE = '\f';

    /*
     * Unable to fully structure code
     */
    public static boolean isKeyword(String var0) {
        try {
            Double.parseDouble(var0);
            return true;
        }
        catch (Exception v0) {
            var1_1 = 0;
            ** while (var1_1 < ParserSuryono.NO_CONST)
        }
lbl-1000:
        // 1 sources

        {
            if (var0.equals(ParserSuryono.constname[var1_1])) {
                return true;
            }
            ++var1_1;
            continue;
        }
lbl12:
        // 1 sources

        var1_1 = 0;
        while (var1_1 < ParserSuryono.NO_FUNCS) {
            if (var0.equals(ParserSuryono.funcname[var1_1])) {
                return true;
            }
            ++var1_1;
        }
        var1_1 = 0;
        while (var1_1 < ParserSuryono.NO_EXT_FUNCS) {
            if (var0.equals(ParserSuryono.extfunc[var1_1])) {
                return true;
            }
            ++var1_1;
        }
        var1_1 = 0;
        while (var1_1 < ParserSuryono.NO_FUNCSNOPARAM) {
            if (var0.equals(ParserSuryono.funcnameNoParam[var1_1])) {
                return true;
            }
            ++var1_1;
        }
        return false;
    }

    public static String[] getVariableList(String string) {
        Vector<String> vector = ParserSuryono.getVariableList(string, new Vector<String>());
        if (vector.size() < 1) {
            return new String[0];
        }
        return vector.toArray(new String[1]);
    }

    public static Vector<String> getVariableList(String string, Vector<String> vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() \t+-*/,<>=&|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (ParserSuryono.isKeyword(string2) || vector.contains(string2)) continue;
            vector.add(string2);
        }
        return vector;
    }

    public ParserSuryono(int n) {
        this.var_count = n;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.var_name = new String[n];
        this.var_value = new double[n];
        this.number = new double[200];
    }

    public void defineVariable(int n, String string) {
        this.var_name[n] = string;
    }

    public void setVariable(int n, double d) {
        this.var_value[n] = d;
    }

    public void define(String string) {
        this.function = string;
        this.valid = false;
    }

    public void parse() {
        int n;
        String string = new String(this.function);
        String string2 = new String(this.function);
        if (this.valid) {
            return;
        }
        this.num = 0;
        this.error = 0;
        this.references.clear();
        this.refnames.removeAllElements();
        while ((n = string.lastIndexOf(";")) != -1) {
            this.function = String.valueOf(string.substring(n + 1)) + ')';
            string = string.substring(0, n++);
            String string3 = null;
            int n2 = this.function.indexOf(":");
            if (n2 == -1) {
                this.error = 14;
                this.position = 0;
                while (this.position < this.function.length()) {
                    if (this.function.charAt(this.position) != ' ') break;
                    ++this.position;
                }
                ++this.position;
            } else {
                string3 = this.function.substring(0, n2);
                this.function = this.function.substring(n2 + 1);
                if ((string3 = string3.trim()).equals("")) {
                    this.error = 15;
                    this.position = 1;
                } else {
                    n += ++n2;
                    this.parseSubFunction();
                }
            }
            if (this.error != 0) {
                this.position += n;
                break;
            }
            this.references.put(string3, this.postfix_code);
            this.refnames.addElement(string3);
        }
        if (this.error == 0) {
            this.function = String.valueOf(string) + ')';
            this.parseSubFunction();
        }
        this.function = string2;
        this.valid = this.error == 0;
    }

    public double evaluate() {
        double d;
        int n = this.refnames.size();
        if (!this.valid) {
            this.error = 3;
            return 0.0;
        }
        this.error = 0;
        this.numberindex = 0;
        if (n != 0) {
            String string = this.postfix_code;
            this.refvalue = new double[n];
            int n2 = 0;
            while (n2 < this.refnames.size()) {
                String string2 = this.refnames.elementAt(n2);
                this.postfix_code = this.references.get(string2);
                d = this.evaluateSubFunction();
                if (this.error != 0) {
                    this.postfix_code = string;
                    this.refvalue = null;
                    return d;
                }
                this.refvalue[n2] = d;
                ++n2;
            }
            this.postfix_code = string;
        }
        d = this.evaluateSubFunction();
        this.refvalue = null;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorString() {
        return ParserSuryono.toErrorString(this.error);
    }

    public int getErrorPosition() {
        return this.position;
    }

    public static String toErrorString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "no error";
                break;
            }
            case 1: {
                string = "syntax error";
                break;
            }
            case 2: {
                string = "parenthesis expected";
                break;
            }
            case 3: {
                string = "uncompiled function";
                break;
            }
            case 4: {
                string = "expression expected";
                break;
            }
            case 5: {
                string = "unknown identifier";
                break;
            }
            case 6: {
                string = "operator expected";
                break;
            }
            case 7: {
                string = "parentheses not match";
                break;
            }
            case 8: {
                string = "internal code damaged";
                break;
            }
            case 9: {
                string = "execution stack overflow";
                break;
            }
            case 10: {
                string = "too many constants";
                break;
            }
            case 11: {
                string = "comma expected";
                break;
            }
            case 12: {
                string = "invalid operand type";
                break;
            }
            case 13: {
                string = "invalid operator";
                break;
            }
            case 14: {
                string = "bad reference definition (: expected)";
                break;
            }
            case 15: {
                string = "reference name expected";
            }
        }
        return string;
    }

    private void skipSpaces() throws ParserException {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParserException(7);
        }
    }

    private void getNextCharacter() throws ParserException {
        ++this.position;
        try {
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParserException(7);
        }
    }

    private void addCode(char c) {
        this.postfix_code = String.valueOf(this.postfix_code) + c;
    }

    private void scanNumber() throws ParserException {
        double d;
        String string = "";
        if (this.num == 200) {
            throw new ParserException(10);
        }
        if (this.character != '.') {
            do {
                string = String.valueOf(string) + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        } else {
            string = String.valueOf(string) + '0';
        }
        if (this.character == '.') {
            do {
                string = String.valueOf(string) + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        }
        if (this.character == 'e' || this.character == 'E') {
            string = String.valueOf(string) + 'e';
            this.getNextCharacter();
            if (this.character == '+' || this.character == '-') {
                string = String.valueOf(string) + this.character;
                this.getNextCharacter();
            }
            while (this.character >= '0' && this.character <= '9') {
                string = String.valueOf(string) + this.character;
                this.getNextCharacter();
            }
        }
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.start;
            throw new ParserException(1);
        }
        this.number[this.num++] = d;
        this.addCode('\u012c');
    }

    private void scanNonNumeric() throws ParserException {
        String string = "";
        if (this.character == '*' || this.character == '/' || this.character == ')' || this.character == ',' || this.character == '<' || this.character == '>' || this.character == '=' || this.character == '&' || this.character == '|') {
            throw new ParserException(1);
        }
        do {
            string = String.valueOf(string) + this.character;
            this.getNextCharacter();
        } while (this.character != ' ' && this.character != '+' && this.character != '-' && this.character != '*' && this.character != '/' && this.character != '(' && this.character != ')' && this.character != ',' && this.character != '<' && this.character != '>' && this.character != '=' && this.character != '&' && this.character != '|');
        int n = 0;
        while (n < NO_CONST) {
            if (string.equals(constname[n])) {
                this.addCode((char)(n + 253));
                return;
            }
            ++n;
        }
        n = 0;
        while (n < NO_FUNCS) {
            if (string.equals(funcname[n])) {
                this.skipSpaces();
                if (this.character != '(') {
                    throw new ParserException(2);
                }
                this.scanAndParse();
                if (this.character != ')') {
                    throw new ParserException(2);
                }
                this.getNextCharacter();
                this.addCode((char)(n + 1000));
                return;
            }
            ++n;
        }
        n = 0;
        while (n < NO_EXT_FUNCS) {
            if (string.equals(extfunc[n])) {
                this.skipSpaces();
                if (this.character != '(') {
                    throw new ParserException(2);
                }
                this.scanAndParse();
                if (this.character != ',') {
                    throw new ParserException(11);
                }
                String string2 = new String(this.postfix_code);
                this.postfix_code = "";
                this.scanAndParse();
                if (this.character != ')') {
                    throw new ParserException(2);
                }
                this.getNextCharacter();
                string2 = String.valueOf(string2) + this.postfix_code;
                this.postfix_code = new String(string2);
                this.addCode((char)(n + EXT_FUNC_OFFSET));
                return;
            }
            ++n;
        }
        n = 0;
        while (n < NO_FUNCSNOPARAM) {
            if (string.equals(funcnameNoParam[n])) {
                this.skipSpaces();
                if (this.character != '(') {
                    throw new ParserException(2);
                }
                this.skipSpaces();
                this.getNextCharacter();
                if (this.character != ')') {
                    throw new ParserException(2);
                }
                this.getNextCharacter();
                this.addCode((char)(n + FUNCNOPARAM_OFFSET));
                return;
            }
            ++n;
        }
        n = 0;
        while (n < this.var_count) {
            if (string.equals(this.var_name[n])) {
                this.addCode((char)(n + 2000));
                return;
            }
            ++n;
        }
        n = this.refnames.indexOf(string);
        if (n != -1) {
            this.addCode((char)(n + 3000));
            return;
        }
        this.position = this.start;
        throw new ParserException(5);
    }

    private boolean getIdentifier() throws ParserException {
        boolean bl = false;
        this.getNextCharacter();
        this.skipSpaces();
        if (this.character == '!') {
            this.getNextCharacter();
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            if (!this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            this.addCode('\f');
            this.getNextCharacter();
            return false;
        }
        this.ISBOOLEAN = false;
        while (this.character == '+' || this.character == '-') {
            if (this.character == '-') {
                bl = !bl;
            }
            this.getNextCharacter();
            this.skipSpaces();
        }
        this.start = this.position;
        if (this.character >= '0' && this.character <= '9' || this.character == '.') {
            this.scanNumber();
        } else if (this.character == '(') {
            this.scanAndParse();
            this.getNextCharacter();
        } else {
            this.scanNonNumeric();
        }
        this.skipSpaces();
        return bl;
    }

    private void arithmeticLevel2() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char c = this.character;
            boolean bl = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (bl) {
                this.addCode('_');
            }
            this.addCode(c);
        } while (this.character == '*' || this.character == '/');
    }

    private void arithmeticLevel1() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char c = this.character;
            boolean bl = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '*' || this.character == '/') {
                if (bl) {
                    this.addCode('_');
                }
                this.arithmeticLevel2();
            }
            this.addCode(c);
        } while (this.character == '+' || this.character == '-');
    }

    private void relationLevel() throws ParserException {
        int n = 0;
        if (this.INRELATION) {
            throw new ParserException(13);
        }
        this.INRELATION = true;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (this.character) {
            case '=': {
                n = 7;
                break;
            }
            case '<': {
                n = 2;
                this.getNextCharacter();
                if (this.character == '>') {
                    n = 6;
                    break;
                }
                if (this.character == '=') {
                    n = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                n = 3;
                this.getNextCharacter();
                if (this.character == '=') {
                    n = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scanAndParse();
        this.INRELATION = false;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        this.addCode((char)n);
        this.ISBOOLEAN = true;
    }

    private void booleanLevel() throws ParserException {
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        char c = this.character;
        this.scanAndParse();
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (c) {
            case '&': {
                this.addCode('\n');
                break;
            }
            case '|': {
                this.addCode('\u000b');
            }
        }
    }

    private void scanAndParse() throws ParserException {
        boolean bl = this.getIdentifier();
        if (bl) {
            this.addCode('_');
        }
        block7: while (true) {
            switch (this.character) {
                case '+': 
                case '-': {
                    this.arithmeticLevel1();
                    continue block7;
                }
                case '*': 
                case '/': {
                    this.arithmeticLevel2();
                    continue block7;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '<': 
                case '=': 
                case '>': {
                    this.relationLevel();
                    continue block7;
                }
                case '&': 
                case '|': {
                    this.booleanLevel();
                    continue block7;
                }
            }
            break;
        }
        throw new ParserException(6);
    }

    private void parseSubFunction() {
        block3: {
            this.position = 0;
            this.postfix_code = "";
            this.INRELATION = false;
            this.ISBOOLEAN = false;
            try {
                this.scanAndParse();
            }
            catch (ParserException parserException) {
                this.error = parserException.getErrorCode();
                if (this.error != 1 || this.postfix_code != "") break block3;
                this.error = 4;
            }
        }
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
    }

    private double builtInFunction(int n, double d) {
        switch (n) {
            case 0: {
                return Math.abs(d);
            }
            case 1: {
                return Math.acos(d);
            }
            case 2: {
                return Math.asin(d);
            }
            case 3: {
                return Math.atan(d);
            }
            case 4: {
                return Math.ceil(d);
            }
            case 5: {
                return Math.cos(d);
            }
            case 6: {
                return Math.exp(d);
            }
            case 7: {
                return Math.floor(d);
            }
            case 8: {
                return Math.log(d);
            }
            case 9: {
                return Math.rint(d);
            }
            case 10: {
                return Math.round(d);
            }
            case 11: {
                return Math.sin(d);
            }
            case 12: {
                return Math.sqrt(d);
            }
            case 13: {
                return Math.tan(d);
            }
            case 14: {
                return Math.toDegrees(d);
            }
            case 15: {
                return Math.toRadians(d);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInFunctionNoParam(int n) {
        switch (n) {
            case 0: {
                return Math.random();
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInExtFunction(int n, double d, double d2) {
        switch (n) {
            case 0: {
                return Math.atan2(d, d2);
            }
            case 1: {
                return Math.IEEEremainder(d, d2);
            }
            case 2: {
                return Math.max(d, d2);
            }
            case 3: {
                return Math.min(d, d2);
            }
            case 4: {
                return Math.pow(d, d2);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double evaluateSubFunction() {
        var1_1 = -1;
        var2_2 = 0;
        var5_3 = this.postfix_code.length();
        while (true) {
            try {
                if (var2_2 == var5_3) {
                    return this.stack[0];
                }
                var4_5 = this.postfix_code.charAt(var2_2++);
            }
            catch (StringIndexOutOfBoundsException v0) {
                return this.stack[0];
            }
            try {
                switch (var4_5) {
                    case '+': {
                        v1 = var1_1 - 1;
                        this.stack[v1] = this.stack[v1] + this.stack[var1_1];
                        --var1_1;
                        break;
                    }
                    case '-': {
                        v2 = var1_1 - 1;
                        this.stack[v2] = this.stack[v2] - this.stack[var1_1];
                        --var1_1;
                        break;
                    }
                    case '*': {
                        v3 = var1_1 - 1;
                        this.stack[v3] = this.stack[v3] * this.stack[var1_1];
                        --var1_1;
                        break;
                    }
                    case '/': {
                        if (this.stack[var1_1] != 0.0) {
                            v4 = var1_1 - 1;
                            this.stack[v4] = this.stack[v4] / this.stack[var1_1];
                        } else {
                            v5 = var1_1 - 1;
                            this.stack[v5] = this.stack[v5] / 1.0E-128;
                        }
                        --var1_1;
                        break;
                    }
                    case '_': {
                        this.stack[var1_1] = -this.stack[var1_1];
                        break;
                    }
                    case '\u0001': {
                        var3_4 = var2_2 + this.postfix_code.charAt(var2_2++);
                        while (var2_2 < var3_4) {
                            if (this.postfix_code.charAt(var2_2++) != '\u012c') continue;
                            ++this.numberindex;
                        }
                        break;
                    }
                    case '\u0002': {
                        v6 = this.stack[--var1_1] < this.stack[var1_1 + 1] ? 1.0 : 0.0;
                        this.stack[var1_1] = v6;
                        break;
                    }
                    case '\u0003': {
                        v7 = this.stack[--var1_1] > this.stack[var1_1 + 1] ? 1.0 : 0.0;
                        this.stack[var1_1] = v7;
                        break;
                    }
                    case '\u0004': {
                        v8 = this.stack[--var1_1] <= this.stack[var1_1 + 1] ? 1.0 : 0.0;
                        this.stack[var1_1] = v8;
                        break;
                    }
                    case '\u0005': {
                        v9 = this.stack[--var1_1] >= this.stack[var1_1 + 1] ? 1.0 : 0.0;
                        this.stack[var1_1] = v9;
                        break;
                    }
                    case '\u0007': {
                        v10 = this.stack[--var1_1] == this.stack[var1_1 + 1] ? 1.0 : 0.0;
                        this.stack[var1_1] = v10;
                        break;
                    }
                    case '\u0006': {
                        v11 = this.stack[--var1_1] != this.stack[var1_1 + 1] ? 1.0 : 0.0;
                        this.stack[var1_1] = v11;
                        break;
                    }
                    case '\b': {
                        if (this.stack[var1_1--] != 0.0) ** GOTO lbl76
                        var3_4 = var2_2 + this.postfix_code.charAt(var2_2++);
                        if (true) ** GOTO lbl130
lbl76:
                        // 1 sources

                        ++var2_2;
                        break;
                    }
                    case '\t': {
                        break;
                    }
                    case '\n': {
                        if (this.stack[--var1_1] != 0.0 && this.stack[var1_1 + 1] != 0.0) {
                            this.stack[var1_1] = 1.0;
                            break;
                        }
                        this.stack[var1_1] = 0.0;
                        break;
                    }
                    case '\u000b': {
                        if (this.stack[--var1_1] != 0.0 || this.stack[var1_1 + 1] != 0.0) {
                            this.stack[var1_1] = 1.0;
                            break;
                        }
                        this.stack[var1_1] = 0.0;
                        break;
                    }
                    case '\f': {
                        this.stack[var1_1] = this.stack[var1_1] == 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case '\u012c': {
                        this.stack[++var1_1] = this.number[this.numberindex++];
                        break;
                    }
                    default: {
                        if (var4_5 >= '\u0bb8') {
                            this.stack[++var1_1] = this.refvalue[var4_5 - 3000];
                            break;
                        }
                        if (var4_5 >= '\u07d0') {
                            this.stack[++var1_1] = this.var_value[var4_5 - 2000];
                            break;
                        }
                        if (var4_5 >= ParserSuryono.FUNCNOPARAM_OFFSET) {
                            this.stack[++var1_1] = this.builtInFunctionNoParam(var4_5 - ParserSuryono.FUNCNOPARAM_OFFSET);
                            break;
                        }
                        if (var4_5 >= ParserSuryono.EXT_FUNC_OFFSET) {
                            this.stack[var1_1 - 1] = this.builtInExtFunction(var4_5 - ParserSuryono.EXT_FUNC_OFFSET, this.stack[var1_1 - 1], this.stack[var1_1]);
                            --var1_1;
                            break;
                        }
                        if (var4_5 >= '\u03e8') {
                            this.stack[var1_1] = this.builtInFunction(var4_5 - 1000, this.stack[var1_1]);
                            break;
                        }
                        if (var4_5 < '\u00fd') {
                            this.error = 8;
                            return NaN;
                        }
                        this.stack[++var1_1] = ParserSuryono.constvalue[var4_5 - 253];
                        break;
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException v12) {
                this.error = 9;
                return NaN;
            }
            catch (NullPointerException v13) {
                this.error = 8;
                return NaN;
            }
            do {
                if (this.postfix_code.charAt(var2_2++) != '\u012c') continue;
                ++this.numberindex;
lbl130:
                // 3 sources

            } while (var2_2 < var3_4);
        }
    }
}

