/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;

public class DeinterlaceFilter
extends Filter {
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixels;
    private int w;
    private int h;
    private Graphics2D gIn;
    private boolean isOdd;
    private Inspector inspector;
    private JRadioButton odd;
    private JRadioButton even;

    public DeinterlaceFilter() {
        this.hasInspector = true;
    }

    public void setOdd(boolean bl) {
        boolean bl2 = this.isOdd;
        this.isOdd = bl;
        this.support.firePropertyChange("odd", bl2, bl);
    }

    public boolean isOdd() {
        return this.isOdd;
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToField();
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void refresh() {
        super.refresh();
        this.odd.setText(MediaRes.getString("Filter.Deinterlace.Button.Odd"));
        this.even.setText(MediaRes.getString("Filter.Deinterlace.Button.Even"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Deinterlace.Title"));
            this.inspector.pack();
        }
        boolean bl = this.isEnabled();
        this.odd.setEnabled(bl);
        this.even.setEnabled(bl);
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.output = new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void setOutputToField() {
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        if (this.h % 2 != 0) {
            --this.h;
        }
        int n = 0;
        while (n < this.h / 2 - 1) {
            int n2 = 0;
            while (n2 < this.w) {
                if (this.isOdd) {
                    this.pixels[this.w * 2 * n + n2] = this.pixels[this.w * (2 * n + 1) + n2];
                } else {
                    this.pixels[this.w * (2 * n + 1) + n2] = this.pixels[this.w * 2 * n + n2];
                }
                ++n2;
            }
            ++n;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends JDialog {
        ButtonGroup group;

        public Inspector() {
            super(DeinterlaceFilter.this.frame, !(DeinterlaceFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.Deinterlace.Title"));
            this.setResizable(false);
            this.createGUI();
            this.initialize();
            DeinterlaceFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            DeinterlaceFilter.this.odd = new JRadioButton();
            DeinterlaceFilter.this.even = new JRadioButton();
            this.group = new ButtonGroup();
            this.group.add(DeinterlaceFilter.this.odd);
            this.group.add(DeinterlaceFilter.this.even);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DeinterlaceFilter.this.setOdd(Inspector.this.group.isSelected(DeinterlaceFilter.this.odd.getModel()));
                }
            };
            DeinterlaceFilter.this.even.addActionListener(actionListener);
            DeinterlaceFilter.this.odd.addActionListener(actionListener);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(DeinterlaceFilter.this.odd);
            jPanel.add(DeinterlaceFilter.this.even);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(DeinterlaceFilter.this.ableButton);
            jPanel2.add(DeinterlaceFilter.this.closeButton);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            this.setContentPane(jPanel3);
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            if (DeinterlaceFilter.this.isOdd) {
                this.group.setSelected(DeinterlaceFilter.this.odd.getModel(), true);
            } else {
                this.group.setSelected(DeinterlaceFilter.this.even.getModel(), true);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DeinterlaceFilter deinterlaceFilter = (DeinterlaceFilter)object;
            if (deinterlaceFilter.isOdd()) {
                xMLControl.setValue("field", "odd");
            } else {
                xMLControl.setValue("field", "even");
            }
            if (deinterlaceFilter.frame != null && deinterlaceFilter.inspector != null && deinterlaceFilter.inspector.isVisible()) {
                int n = ((DeinterlaceFilter)deinterlaceFilter).inspector.getLocation().x - deinterlaceFilter.frame.getLocation().x;
                int n2 = ((DeinterlaceFilter)deinterlaceFilter).inspector.getLocation().y - deinterlaceFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new DeinterlaceFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DeinterlaceFilter deinterlaceFilter = (DeinterlaceFilter)object;
            if (xMLControl.getPropertyNames().contains("field")) {
                if (xMLControl.getString("field").equals("odd")) {
                    deinterlaceFilter.setOdd(true);
                } else {
                    deinterlaceFilter.setOdd(false);
                }
            }
            deinterlaceFilter.inspectorX = xMLControl.getInt("inspector_x");
            deinterlaceFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

