/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public class ImageVideoType
implements VideoType {
    protected static TreeSet<VideoFileFilter> imageFileFilters = new TreeSet();
    private VideoFileFilter singleTypeFilter;

    public ImageVideoType() {
    }

    public ImageVideoType(VideoFileFilter videoFileFilter) {
        this();
        if (videoFileFilter != null) {
            this.singleTypeFilter = videoFileFilter;
            imageFileFilters.add(videoFileFilter);
        }
    }

    public Video getVideo(File file) {
        try {
            ImageVideo imageVideo = new ImageVideo(file.getAbsolutePath(), true);
            imageVideo.setProperty("video_type", this);
            return imageVideo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Video getVideo(String string) {
        String string2 = String.valueOf(XML.stripExtension(string)) + ".xml";
        XMLControlElement xMLControlElement = new XMLControlElement(string2);
        if (!xMLControlElement.failedToRead() && xMLControlElement.getObjectClass() == ImageVideo.class) {
            return (Video)xMLControlElement.loadObject(null);
        }
        try {
            ImageVideo imageVideo = new ImageVideo(string, true);
            imageVideo.setProperty("video_type", this);
            return imageVideo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public VideoRecorder getRecorder() {
        return new ImageVideoRecorder(this);
    }

    public boolean canRecord() {
        return true;
    }

    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("ImageVideoType.Description");
    }

    public String getDefaultExtension() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDefaultExtension();
        }
        return null;
    }

    public VideoFileFilter[] getFileFilters() {
        return imageFileFilters.toArray(new VideoFileFilter[0]);
    }

    public VideoFileFilter getDefaultFileFilter() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter;
        }
        return null;
    }

    public boolean isType(Video video) {
        return video.getClass().equals(ImageVideo.class);
    }
}

