/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveFilter
extends Filter {
    protected static FontRenderContext frc = new FontRenderContext(null, false, false);
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixelsIn;
    private int[] pixelsOut;
    private int w;
    private int h;
    private Graphics2D gIn;
    private double[][] matrix = new double[3][3];
    private double[][] temp1 = new double[3][3];
    private double[][] temp2 = new double[3][3];
    private double[] xOut;
    private double[] yOut;
    private double[] xIn;
    private double[] yIn;
    private int interpolation = 2;
    private Quadrilateral quad;
    private QuadEditor inputEditor;
    private QuadEditor outputEditor;
    private Point2D[][] inCornerPoints = new Point2D[10][];
    private Point2D[][] outCornerPoints = new Point2D[10][];
    private TreeSet<Integer> inKeyFrames = new TreeSet();
    private TreeSet<Integer> outKeyFrames = new TreeSet();
    private boolean fixed = false;
    private int fixedKey = 0;
    private Inspector inspector;

    public PerspectiveFilter() {
        this.quad = new Quadrilateral();
        this.refresh();
        this.hasInspector = true;
    }

    @Override
    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToTransformed(this.input);
        return this.output;
    }

    @Override
    public boolean isEnabled() {
        boolean bl;
        boolean bl2 = !super.isEnabled();
        boolean bl3 = bl = this.inspector != null && this.inspector.isVisible() && this.inspector.tabbedPane.getSelectedComponent() == this.inputEditor;
        return !bl2 && !bl;
    }

    @Override
    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Perspective.Title"));
            this.inspector.tabbedPane.setTitleAt(0, MediaRes.getString("PerspectiveFilter.Tab.Input"));
            this.inspector.tabbedPane.setTitleAt(1, MediaRes.getString("PerspectiveFilter.Tab.Output"));
            this.inspector.helpButton.setText(MediaRes.getString("PerspectiveFilter.Button.Help"));
            this.inspector.colorButton.setText(MediaRes.getString("PerspectiveFilter.Button.Color"));
            this.ableButton.setText(super.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
            this.inputEditor.refreshGUI();
            this.outputEditor.refreshGUI();
        }
    }

    @Override
    public void setVideoPanel(VideoPanel videoPanel) {
        super.setVideoPanel(videoPanel);
        Video video = this.vidPanel.getVideo();
        video.addPropertyChangeListener("nextframe", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                PerspectiveFilter.this.refreshCorners(n);
            }
        });
        this.vidPanel.propertyChange(new PropertyChangeEvent(this, "perspective", null, this));
    }

    public void setFixed(boolean bl) {
        if (this.fixed != bl) {
            this.fixed = bl;
            if (this.fixed && this.vidPanel != null) {
                this.fixedKey = this.vidPanel.getFrameNumber();
                this.saveCorners(this.fixedKey, true);
                this.saveCorners(this.fixedKey, false);
            }
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setCornerLocation(int n, int n2, double d, double d2) {
        boolean bl = n2 < 4;
        Corner[] cornerArray = bl ? this.quad.inCorners : this.quad.outCorners;
        cornerArray[n2].setXY(d, d2);
    }

    public Color getColor() {
        return this.quad.color;
    }

    public int getCornerIndex(Corner corner) {
        int n = 0;
        while (n < 4) {
            if (corner == this.quad.inCorners[n]) {
                return n;
            }
            if (corner == this.quad.outCorners[n]) {
                return n + 4;
            }
            ++n;
        }
        return -1;
    }

    public Corner getCorner(int n) {
        Corner[] cornerArray = n < 4 ? this.quad.inCorners : this.quad.outCorners;
        return cornerArray[n % 4];
    }

    public void deleteKeyFrame(int n, Corner corner) {
        int n2 = this.getCornerIndex(corner);
        if (n2 == -1) {
            return;
        }
        TreeSet<Integer> treeSet = n2 < 4 ? this.inKeyFrames : this.outKeyFrames;
        int n3 = this.getKeyFrame(n, treeSet);
        if (n3 == 0) {
            return;
        }
        treeSet.remove(n3);
        Point2D[][] point2DArray = n2 < 4 ? this.inCornerPoints : this.outCornerPoints;
        point2DArray[n3] = null;
        this.refreshCorners(this.vidPanel.getFrameNumber());
    }

    public void setInputEnabled(boolean bl) {
        if (this.inspector == null) {
            return;
        }
        this.inspector.tabbedPane.setSelectedComponent(bl ? this.inputEditor : this.outputEditor);
    }

    public boolean isInputEnabled() {
        if (this.inspector == null) {
            return false;
        }
        return this.inspector.tabbedPane.getSelectedComponent() == this.inputEditor;
    }

    public boolean isActive() {
        if (this.inspector == null) {
            return false;
        }
        return this.inspector.tabbedPane.isEnabled();
    }

    public boolean hasInspector() {
        return this.inspector != null;
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.output = new BufferedImage(this.w, this.h, 1);
        this.pixelsIn = new int[this.w * this.h];
        this.pixelsOut = new int[this.w * this.h];
        this.xIn = new double[this.w * this.h];
        this.yIn = new double[this.w * this.h];
        this.xOut = new double[this.w * this.h];
        this.yOut = new double[this.w * this.h];
        int n = 0;
        while (n < this.w) {
            int n2 = 0;
            while (n2 < this.h) {
                this.xOut[n2 * this.w + n] = n;
                this.yOut[n2 * this.w + n] = n2;
                ++n2;
            }
            ++n;
        }
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
        if (this.inKeyFrames.isEmpty()) {
            this.quad.inCorners[0].setLocation(this.w / 4, this.h / 4);
            this.quad.inCorners[1].setLocation(3 * this.w / 4, this.h / 4);
            this.quad.inCorners[2].setLocation(3 * this.w / 4, 3 * this.h / 4);
            this.quad.inCorners[3].setLocation(this.w / 4, 3 * this.h / 4);
            this.quad.outCorners[0].setLocation(this.w / 4, this.h / 4);
            this.quad.outCorners[1].setLocation(3 * this.w / 4, this.h / 4);
            this.quad.outCorners[2].setLocation(3 * this.w / 4, 3 * this.h / 4);
            this.quad.outCorners[3].setLocation(this.w / 4, 3 * this.h / 4);
            this.saveCorners(0, true);
            this.saveCorners(0, false);
        }
    }

    private void setOutputToTransformed(BufferedImage bufferedImage) {
        bufferedImage.getRaster().getDataElements(0, 0, this.w, this.h, this.pixelsIn);
        this.getQuadToSquare(this.temp1, this.quad.outCorners[0].getX(), this.quad.outCorners[0].getY(), this.quad.outCorners[1].getX(), this.quad.outCorners[1].getY(), this.quad.outCorners[2].getX(), this.quad.outCorners[2].getY(), this.quad.outCorners[3].getX(), this.quad.outCorners[3].getY());
        this.getSquareToQuad(this.temp2, this.quad.inCorners[0].getX(), this.quad.inCorners[0].getY(), this.quad.inCorners[1].getX(), this.quad.inCorners[1].getY(), this.quad.inCorners[2].getX(), this.quad.inCorners[2].getY(), this.quad.inCorners[3].getX(), this.quad.inCorners[3].getY());
        this.concatenate(this.temp1, this.temp2);
        this.transform(this.xOut, this.yOut, this.xIn, this.yIn);
        int n = 0;
        while (n < this.pixelsOut.length) {
            this.pixelsOut[n] = this.getColor(this.xIn[n], this.yIn[n], this.w, this.h, this.pixelsIn);
            ++n;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixelsOut);
    }

    private void transform(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = this.matrix[2][0] * dArray[n2] + this.matrix[2][1] * dArray2[n2] + this.matrix[2][2];
            if (d == 0.0) {
                dArray3[n2] = dArray[n2];
                dArray4[n2] = dArray2[n2];
            } else {
                dArray3[n2] = (this.matrix[0][0] * dArray[n2] + this.matrix[0][1] * dArray2[n2] + this.matrix[0][2]) / d;
                dArray4[n2] = (this.matrix[1][0] * dArray[n2] + this.matrix[1][1] * dArray2[n2] + this.matrix[1][2]) / d;
            }
            ++n2;
        }
    }

    private int getColor(double d, double d2, int n, int n2, int[] nArray) {
        double d3;
        int n3 = (int)Math.floor(d);
        int n4 = (int)Math.floor(d2);
        if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
            return 0;
        }
        if (n3 + 1 == n || n4 + 1 == n2) {
            return nArray[n4 * n + n3];
        }
        double d4 = n3 == 0 ? d : d % (double)n3;
        double d5 = d3 = n4 == 0 ? d2 : d2 % (double)n4;
        if (this.interpolation == 2) {
            int[] nArray2 = new int[]{nArray[n4 * n + n3], nArray[n4 * n + n3 + 1], nArray[(n4 + 1) * n + n3], nArray[(n4 + 1) * n + n3 + 1]};
            int[] nArray3 = new int[4];
            int n5 = 0;
            while (n5 < 4) {
                nArray3[n5] = nArray2[n5] >> 16 & 0xFF;
                ++n5;
            }
            n5 = this.bilinearInterpolation(d4, d3, nArray3);
            int n6 = 0;
            while (n6 < 4) {
                nArray3[n6] = nArray2[n6] >> 8 & 0xFF;
                ++n6;
            }
            n6 = this.bilinearInterpolation(d4, d3, nArray3);
            int n7 = 0;
            while (n7 < 4) {
                nArray3[n7] = nArray2[n7] & 0xFF;
                ++n7;
            }
            n7 = this.bilinearInterpolation(d4, d3, nArray3);
            return n5 << 16 | n6 << 8 | n7;
        }
        return d4 < 0.5 ? (d3 < 0.5 ? nArray[n4 * n + n3] : nArray[(n4 + 1) * n + n3]) : (d3 < 0.5 ? nArray[n4 * n + n3 + 1] : nArray[(n4 + 1) * n + n3 + 1]);
    }

    private int bilinearInterpolation(double d, double d2, int[] nArray) {
        return (int)((1.0 - d2) * ((1.0 - d) * (double)nArray[0] + d * (double)nArray[2]) + d2 * ((1.0 - d) * (double)nArray[1] + d * (double)nArray[3]));
    }

    private void getSquareToQuad(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d - d3 + d5 - d7;
        double d10 = d2 - d4 + d6 - d8;
        dArray[2][2] = 1.0;
        if (d9 == 0.0 && d10 == 0.0) {
            dArray[0][0] = d3 - d;
            dArray[0][1] = d5 - d3;
            dArray[0][2] = d;
            dArray[1][0] = d4 - d2;
            dArray[1][1] = d6 - d4;
            dArray[1][2] = d2;
            dArray[2][0] = 0.0;
            dArray[2][1] = 0.0;
        } else {
            double d11 = d3 - d5;
            double d12 = d4 - d6;
            double d13 = d7 - d5;
            double d14 = d8 - d6;
            double d15 = 1.0 / (d11 * d14 - d13 * d12);
            dArray[2][0] = (d9 * d14 - d13 * d10) * d15;
            dArray[2][1] = (d11 * d10 - d9 * d12) * d15;
            dArray[0][0] = d3 - d + dArray[2][0] * d3;
            dArray[0][1] = d7 - d + dArray[2][1] * d7;
            dArray[0][2] = d;
            dArray[1][0] = d4 - d2 + dArray[2][0] * d4;
            dArray[1][1] = d8 - d2 + dArray[2][1] * d8;
            dArray[1][2] = d2;
        }
    }

    private void getQuadToSquare(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.getSquareToQuad(dArray, d, d2, d3, d4, d5, d6, d7, d8);
        double d9 = dArray[1][1] * dArray[2][2] - dArray[1][2] * dArray[2][1];
        double d10 = dArray[1][2] * dArray[2][0] - dArray[1][0] * dArray[2][2];
        double d11 = dArray[1][0] * dArray[2][1] - dArray[1][1] * dArray[2][0];
        double d12 = dArray[0][2] * dArray[2][1] - dArray[0][1] * dArray[2][2];
        double d13 = dArray[0][0] * dArray[2][2] - dArray[0][2] * dArray[2][0];
        double d14 = dArray[0][1] * dArray[2][0] - dArray[0][0] * dArray[2][1];
        double d15 = dArray[0][1] * dArray[1][2] - dArray[0][2] * dArray[1][1];
        double d16 = dArray[0][2] * dArray[1][0] - dArray[0][0] * dArray[1][2];
        double d17 = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
        dArray[0][0] = d9;
        dArray[0][1] = d12;
        dArray[0][2] = d15;
        dArray[1][0] = d10;
        dArray[1][1] = d13;
        dArray[1][2] = d16;
        dArray[2][0] = d11;
        dArray[2][1] = d14;
        dArray[2][2] = d17;
    }

    private void concatenate(double[][] dArray, double[][] dArray2) {
        this.matrix[0][0] = dArray[0][0] * dArray2[0][0] + dArray[1][0] * dArray2[0][1] + dArray[2][0] * dArray2[0][2];
        this.matrix[1][0] = dArray[0][0] * dArray2[1][0] + dArray[1][0] * dArray2[1][1] + dArray[2][0] * dArray2[1][2];
        this.matrix[2][0] = dArray[0][0] * dArray2[2][0] + dArray[1][0] * dArray2[2][1] + dArray[2][0] * dArray2[2][2];
        this.matrix[0][1] = dArray[0][1] * dArray2[0][0] + dArray[1][1] * dArray2[0][1] + dArray[2][1] * dArray2[0][2];
        this.matrix[1][1] = dArray[0][1] * dArray2[1][0] + dArray[1][1] * dArray2[1][1] + dArray[2][1] * dArray2[1][2];
        this.matrix[2][1] = dArray[0][1] * dArray2[2][0] + dArray[1][1] * dArray2[2][1] + dArray[2][1] * dArray2[2][2];
        this.matrix[0][2] = dArray[0][2] * dArray2[0][0] + dArray[1][2] * dArray2[0][1] + dArray[2][2] * dArray2[0][2];
        this.matrix[1][2] = dArray[0][2] * dArray2[1][0] + dArray[1][2] * dArray2[1][1] + dArray[2][2] * dArray2[1][2];
        this.matrix[2][2] = dArray[0][2] * dArray2[2][0] + dArray[1][2] * dArray2[2][1] + dArray[2][2] * dArray2[2][2];
    }

    private double[][] getCornerData(Point2D[] point2DArray) {
        double[][] dArray = new double[4][2];
        int n = 0;
        while (n < 4) {
            dArray[n][0] = point2DArray[n].getX();
            dArray[n][1] = point2DArray[n].getY();
            ++n;
        }
        return dArray;
    }

    private void refreshCorners(int n) {
        if (this.gIn == null && this.source != null && this.input != this.source) {
            return;
        }
        int n2 = this.getKeyFrame(n, this.inKeyFrames);
        int n3 = 0;
        while (n3 < 4) {
            this.quad.inCorners[n3].setLocation(this.inCornerPoints[n2][n3]);
            ++n3;
        }
        n2 = this.getKeyFrame(n, this.outKeyFrames);
        n3 = 0;
        while (n3 < 4) {
            this.quad.outCorners[n3].setLocation(this.outCornerPoints[n2][n3]);
            ++n3;
        }
    }

    private void saveCorners(int n, boolean bl) {
        int n2;
        if (this.fixed) {
            n = this.fixedKey;
        }
        this.ensureCornerCapacity(n);
        TreeSet<Integer> treeSet = bl ? this.inKeyFrames : this.outKeyFrames;
        Point2D[][] point2DArray = bl ? this.inCornerPoints : this.outCornerPoints;
        Corner[] cornerArray = bl ? this.quad.inCorners : this.quad.outCorners;
        treeSet.add(n);
        if (point2DArray[n] == null) {
            point2DArray[n] = new Point2D[4];
            n2 = 0;
            while (n2 < 4) {
                point2DArray[n][n2] = new Point2D.Double();
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < 4) {
            point2DArray[n][n2].setLocation(cornerArray[n2]);
            ++n2;
        }
    }

    private void loadCornerData(double[][][] dArray, boolean bl) {
        this.ensureCornerCapacity(dArray.length);
        TreeSet<Integer> treeSet = bl ? this.inKeyFrames : this.outKeyFrames;
        treeSet.clear();
        Point2D[][] point2DArray = bl ? this.inCornerPoints : this.outCornerPoints;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] != null) {
                int n2;
                treeSet.add(n);
                if (point2DArray[n] == null) {
                    point2DArray[n] = new Point2D[4];
                    n2 = 0;
                    while (n2 < 4) {
                        point2DArray[n][n2] = new Point2D.Double();
                        ++n2;
                    }
                }
                n2 = 0;
                while (n2 < 4) {
                    point2DArray[n][n2].setLocation(dArray[n][n2][0], dArray[n][n2][1]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void ensureCornerCapacity(int n) {
        Point2D[][] point2DArrayArray;
        int n2 = this.inCornerPoints.length;
        if (n2 < n + 1) {
            point2DArrayArray = new Point2D[n + 10][];
            System.arraycopy(this.inCornerPoints, 0, point2DArrayArray, 0, n2);
            this.inCornerPoints = point2DArrayArray;
        }
        if ((n2 = this.outCornerPoints.length) < n + 1) {
            point2DArrayArray = new Point2D[n + 10][];
            System.arraycopy(this.outCornerPoints, 0, point2DArrayArray, 0, n2);
            this.outCornerPoints = point2DArrayArray;
        }
    }

    private void trimCornerPoints() {
        Point2D[][] point2DArrayArray;
        int n;
        int n2 = n = this.inCornerPoints.length;
        while (n2 > 0) {
            if (this.inCornerPoints[n2 - 1] != null) {
                point2DArrayArray = new Point2D[n2][];
                System.arraycopy(this.inCornerPoints, 0, point2DArrayArray, 0, n2);
                this.inCornerPoints = point2DArrayArray;
                break;
            }
            --n2;
        }
        n2 = n = this.outCornerPoints.length;
        while (n2 > 0) {
            if (this.outCornerPoints[n2 - 1] != null) {
                point2DArrayArray = new Point2D[n2][];
                System.arraycopy(this.outCornerPoints, 0, point2DArrayArray, 0, n2);
                this.outCornerPoints = point2DArrayArray;
                break;
            }
            --n2;
        }
    }

    private int getKeyFrame(int n, TreeSet<Integer> treeSet) {
        if (this.fixed) {
            return this.fixedKey;
        }
        int n2 = 0;
        for (int n3 : treeSet) {
            if (n3 > n) continue;
            n2 = n3;
        }
        return n2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public class Corner
    extends TPoint {
        public void setXY(double d, double d2) {
            QuadEditor quadEditor;
            super.setXY(d, d2);
            boolean bl = !PerspectiveFilter.this.isEnabled();
            Corner[] cornerArray = bl ? PerspectiveFilter.this.quad.inCorners : PerspectiveFilter.this.quad.outCorners;
            QuadEditor quadEditor2 = quadEditor = bl ? PerspectiveFilter.this.inputEditor : PerspectiveFilter.this.outputEditor;
            if (quadEditor.shapes[quadEditor.selectedShapeIndex].equals("Rectangle")) {
                if (this == cornerArray[0]) {
                    cornerArray[3].x = d;
                    cornerArray[1].y = d2;
                } else if (this == cornerArray[1]) {
                    cornerArray[2].x = d;
                    cornerArray[0].y = d2;
                } else if (this == cornerArray[2]) {
                    cornerArray[1].x = d;
                    cornerArray[3].y = d2;
                } else if (this == cornerArray[3]) {
                    cornerArray[0].x = d;
                    cornerArray[2].y = d2;
                }
            }
            PerspectiveFilter.this.saveCorners(PerspectiveFilter.this.vidPanel == null ? 0 : PerspectiveFilter.this.vidPanel.getFrameNumber(), bl);
            quadEditor.refreshFields();
            if (quadEditor == PerspectiveFilter.this.outputEditor) {
                PerspectiveFilter.this.support.firePropertyChange("image", null, null);
            }
            PerspectiveFilter.this.support.firePropertyChange("cornerlocation", null, this);
            if (PerspectiveFilter.this.vidPanel != null) {
                PerspectiveFilter.this.vidPanel.repaint();
            }
        }
    }

    private class Inspector
    extends JDialog {
        JButton helpButton;
        JButton colorButton;
        JTabbedPane tabbedPane;
        JPanel contentPane;

        public Inspector() {
            super(PerspectiveFilter.this.frame, !(PerspectiveFilter.this.frame instanceof OSPFrame));
            this.setResizable(false);
            this.createGUI();
            PerspectiveFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            this.tabbedPane = new JTabbedPane();
            PerspectiveFilter.this.inputEditor = new QuadEditor(true);
            PerspectiveFilter.this.outputEditor = new QuadEditor(false);
            ((PerspectiveFilter)PerspectiveFilter.this).outputEditor.selectedShapeIndex = 1;
            this.tabbedPane.addTab("", PerspectiveFilter.this.inputEditor);
            this.tabbedPane.addTab("", PerspectiveFilter.this.outputEditor);
            this.tabbedPane.setSelectedComponent(PerspectiveFilter.this.inputEditor);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    PerspectiveFilter.this.refresh();
                    ((Inspector)Inspector.this).PerspectiveFilter.this.support.firePropertyChange("image", null, null);
                    ((Inspector)Inspector.this).PerspectiveFilter.this.support.firePropertyChange("tab", null, null);
                }
            });
            this.helpButton = new JButton();
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = String.valueOf(MediaRes.getString("PerspectiveFilter.Help.Message1")) + "\n" + MediaRes.getString("PerspectiveFilter.Help.Message2") + "\n" + MediaRes.getString("PerspectiveFilter.Help.Message3") + "\n" + MediaRes.getString("PerspectiveFilter.Help.Message4") + "\n\n" + MediaRes.getString("PerspectiveFilter.Help.Message5") + "\n  " + MediaRes.getString("PerspectiveFilter.Help.Message6") + "\n  " + MediaRes.getString("PerspectiveFilter.Help.Message7") + "\n  " + MediaRes.getString("PerspectiveFilter.Help.Message8") + "\n      " + MediaRes.getString("PerspectiveFilter.Help.Message9");
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(((Inspector)Inspector.this).PerspectiveFilter.this.vidPanel), string, MediaRes.getString("PerspectiveFilter.Help.Title"), 1);
                }
            });
            this.colorButton = new JButton();
            this.colorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(null, MediaRes.getString("PerspectiveFilter.Dialog.Color.Title"), PerspectiveFilter.this.quad.color);
                    if (color != null) {
                        PerspectiveFilter.this.quad.color = color;
                        ((Inspector)Inspector.this).PerspectiveFilter.this.support.firePropertyChange("color", null, color);
                    }
                }
            });
            PerspectiveFilter.this.ableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = !PerspectiveFilter.super.isEnabled();
                    Inspector.this.colorButton.setEnabled(bl);
                    Inspector.this.tabbedPane.setEnabled(bl);
                    PerspectiveFilter.this.inputEditor.setEnabled(bl);
                    PerspectiveFilter.this.outputEditor.setEnabled(bl);
                }
            });
            this.contentPane = new JPanel(new BorderLayout());
            this.setContentPane(this.contentPane);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(this.helpButton);
            jPanel.add(this.colorButton);
            jPanel.add(PerspectiveFilter.this.ableButton);
            jPanel.add(PerspectiveFilter.this.closeButton);
            this.contentPane.add((Component)jPanel, "South");
            this.contentPane.add((Component)this.tabbedPane, "Center");
        }

        void initialize() {
            PerspectiveFilter.this.refresh();
            this.pack();
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (PerspectiveFilter.this.vidPanel != null) {
                if (bl) {
                    PerspectiveFilter.this.vidPanel.addDrawable(PerspectiveFilter.this.quad);
                    PerspectiveFilter.this.support.firePropertyChange("visible", null, null);
                    PerspectiveFilter.this.vidPanel.addPropertyChangeListener("selectedpoint", PerspectiveFilter.this.quad);
                    PerspectiveFilter.this.addPropertyChangeListener("visible", PerspectiveFilter.this.vidPanel);
                } else {
                    PerspectiveFilter.this.vidPanel.removeDrawable(PerspectiveFilter.this.quad);
                    PerspectiveFilter.this.support.firePropertyChange("visible", null, null);
                    PerspectiveFilter.this.removePropertyChangeListener("visible", PerspectiveFilter.this.vidPanel);
                    PerspectiveFilter.this.vidPanel.removePropertyChangeListener("selectedpoint", PerspectiveFilter.this.quad);
                }
            }
            boolean bl2 = PerspectiveFilter.super.isEnabled();
            this.colorButton.setEnabled(bl2);
            this.tabbedPane.setEnabled(bl2);
            PerspectiveFilter.this.inputEditor.setEnabled(bl2);
            PerspectiveFilter.this.outputEditor.setEnabled(bl2);
            PerspectiveFilter.this.support.firePropertyChange("image", null, null);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            int n;
            PerspectiveFilter perspectiveFilter = (PerspectiveFilter)object;
            perspectiveFilter.trimCornerPoints();
            double[][][] dArrayArray = new double[perspectiveFilter.inCornerPoints.length][][];
            Iterator iterator = perspectiveFilter.inKeyFrames.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                perspectiveFilter.refreshCorners(n);
                dArrayArray[n] = perspectiveFilter.getCornerData(perspectiveFilter.inCornerPoints[n]);
            }
            xMLControl.setValue("in_corners", dArrayArray);
            dArrayArray = new double[perspectiveFilter.outCornerPoints.length][][];
            iterator = perspectiveFilter.outKeyFrames.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                perspectiveFilter.refreshCorners(n);
                dArrayArray[n] = perspectiveFilter.getCornerData(perspectiveFilter.outCornerPoints[n]);
            }
            xMLControl.setValue("out_corners", dArrayArray);
            if (perspectiveFilter.vidPanel != null) {
                VideoClip videoClip = perspectiveFilter.vidPanel.getPlayer().getVideoClip();
                xMLControl.setValue("startframe", videoClip.getStartFrameNumber());
                perspectiveFilter.refreshCorners(perspectiveFilter.vidPanel.getFrameNumber());
            }
            if (perspectiveFilter.frame != null && perspectiveFilter.inspector != null && perspectiveFilter.inspector.isVisible()) {
                int n2 = ((PerspectiveFilter)perspectiveFilter).inspector.getLocation().x - perspectiveFilter.frame.getLocation().x;
                int n3 = ((PerspectiveFilter)perspectiveFilter).inspector.getLocation().y - perspectiveFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n2);
                xMLControl.setValue("inspector_y", n3);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new PerspectiveFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            int n;
            PerspectiveFilter perspectiveFilter = (PerspectiveFilter)object;
            double[][][] dArray = (double[][][])xMLControl.getObject("in_corners");
            if (dArray != null) {
                perspectiveFilter.loadCornerData(dArray, true);
            }
            if ((dArray = (double[][][])xMLControl.getObject("out_corners")) != null) {
                perspectiveFilter.loadCornerData(dArray, false);
            }
            if ((n = xMLControl.getInt("startframe")) != Integer.MIN_VALUE) {
                perspectiveFilter.refreshCorners(n);
            }
            if (perspectiveFilter.vidPanel != null) {
                perspectiveFilter.refreshCorners(perspectiveFilter.vidPanel.getFrameNumber());
            }
            perspectiveFilter.inspectorX = xMLControl.getInt("inspector_x");
            perspectiveFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }

    private class QuadEditor
    extends JPanel {
        DecimalField[][] fields;
        boolean isInput;
        String[] shapes;
        int selectedShapeIndex;
        JComboBox shapeDropdown;
        JLabel shapeLabel;
        boolean refreshing;
        Box[] boxes;
        TitledBorder cornersBorder;

        QuadEditor(boolean bl) {
            super(new BorderLayout());
            this.fields = new DecimalField[4][2];
            this.shapes = new String[]{"Any", "Rectangle"};
            this.shapeDropdown = new JComboBox();
            this.shapeLabel = new JLabel();
            this.boxes = new Box[4];
            this.cornersBorder = BorderFactory.createTitledBorder("");
            this.isInput = bl;
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Corner[] cornerArray = QuadEditor.this.isInput ? PerspectiveFilter.this.quad.inCorners : PerspectiveFilter.this.quad.outCorners;
                    int n = 0;
                    while (n < QuadEditor.this.fields.length) {
                        if (actionEvent.getSource() == QuadEditor.this.fields[n][0] || actionEvent.getSource() == QuadEditor.this.fields[n][1]) {
                            ((TPoint)cornerArray[n]).setXY(QuadEditor.this.fields[n][0].getValue(), QuadEditor.this.fields[n][1].getValue());
                        }
                        ++n;
                    }
                    QuadEditor.this.refreshFields();
                    ((QuadEditor)QuadEditor.this).PerspectiveFilter.this.support.firePropertyChange("image", null, null);
                }
            };
            JPanel jPanel = new JPanel(new GridLayout(2, 2));
            jPanel.setBorder(this.cornersBorder);
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n][0] = new DecimalField(4, 1);
                this.fields[n][0].addActionListener(abstractAction);
                this.fields[n][1] = new DecimalField(4, 1);
                this.fields[n][1].addActionListener(abstractAction);
                this.boxes[n] = Box.createHorizontalBox();
                JLabel jLabel = new JLabel(String.valueOf(n) + ":  x");
                jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
                this.boxes[n].add(jLabel);
                this.boxes[n].add(this.fields[n][0]);
                jLabel = new JLabel("y");
                jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
                this.boxes[n].add(jLabel);
                this.boxes[n].add(this.fields[n][1]);
                this.boxes[n].setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                ++n;
            }
            jPanel.add(this.boxes[0]);
            jPanel.add(this.boxes[1]);
            jPanel.add(this.boxes[3]);
            jPanel.add(this.boxes[2]);
            this.shapeLabel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 4));
            this.shapeDropdown.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 8));
            this.shapeDropdown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (QuadEditor.this.refreshing) {
                        return;
                    }
                    QuadEditor.this.selectedShapeIndex = QuadEditor.this.shapeDropdown.getSelectedIndex();
                    if (QuadEditor.this.shapes[QuadEditor.this.selectedShapeIndex].equals("Rectangle")) {
                        Corner[] cornerArray = QuadEditor.this.isInput ? PerspectiveFilter.this.quad.inCorners : PerspectiveFilter.this.quad.outCorners;
                        int n = 0;
                        while (n < 4) {
                            ((TPoint)cornerArray[n]).setXY(cornerArray[n].x, cornerArray[n].y);
                            ++n;
                        }
                        if (((QuadEditor)QuadEditor.this).PerspectiveFilter.this.vidPanel != null) {
                            ((QuadEditor)QuadEditor.this).PerspectiveFilter.this.vidPanel.repaint();
                        }
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(this.shapeLabel);
            box.add(this.shapeDropdown);
            this.add((Component)box, "North");
            this.add((Component)jPanel, "Center");
            this.refreshGUI();
            this.refreshFields();
        }

        void refreshGUI() {
            this.refreshing = true;
            this.shapeLabel.setText(MediaRes.getString("PerspectiveFilter.Label.Shape"));
            this.cornersBorder.setTitle(MediaRes.getString("PerspectiveFilter.Corners.Title"));
            this.shapeDropdown.removeAllItems();
            if (this == PerspectiveFilter.this.inputEditor) {
                this.shapeDropdown.addItem(MediaRes.getString("PerspectiveFilter.Shape.Any"));
            } else {
                int n = 0;
                while (n < this.shapes.length) {
                    this.shapeDropdown.addItem(MediaRes.getString("PerspectiveFilter.Shape." + this.shapes[n]));
                    ++n;
                }
            }
            this.shapeDropdown.setSelectedIndex(this.selectedShapeIndex);
            this.refreshing = false;
        }

        void refreshFields() {
            Corner[] cornerArray = this == PerspectiveFilter.this.outputEditor ? PerspectiveFilter.this.quad.outCorners : PerspectiveFilter.this.quad.inCorners;
            int n = 0;
            while (n < 4) {
                this.fields[n][0].setValue(cornerArray[n].x);
                this.fields[n][1].setValue(cornerArray[n].y);
                ++n;
            }
        }

        public void setEnabled(boolean bl) {
            this.shapeDropdown.setEnabled(bl);
            this.shapeLabel.setEnabled(bl);
            int n = 0;
            while (n < this.boxes.length) {
                Component[] componentArray = this.boxes[n].getComponents();
                int n2 = componentArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Component component = componentArray[n3];
                    component.setEnabled(bl);
                    ++n3;
                }
                ++n;
            }
            this.cornersBorder.setTitleColor(bl ? this.shapeLabel.getForeground() : new Color(153, 153, 153));
        }
    }

    private class Quadrilateral
    implements Trackable,
    Interactive,
    PropertyChangeListener {
        private Corner[] inCorners = new Corner[4];
        private Corner[] outCorners = new Corner[4];
        private Point2D[] screenPts = new Point2D[4];
        private GeneralPath path = new GeneralPath();
        private Stroke stroke = new BasicStroke(2.0f);
        private Stroke cornerStroke = new BasicStroke();
        private Shape selectionShape = new Rectangle(-4, -4, 8, 8);
        private Shape cornerShape = new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0);
        private Shape[] hitShapes = new Shape[4];
        private Shape[] drawShapes = new Shape[5];
        private Corner selectedCorner;
        private AffineTransform transform = new AffineTransform();
        private TextLayout[] textLayouts = new TextLayout[4];
        private Font font = new JTextField().getFont();
        private Point p = new Point();
        private Color color = Color.RED;

        public Quadrilateral() {
            int n = 0;
            while (n < this.inCorners.length) {
                this.inCorners[n] = new Corner();
                this.outCorners[n] = new Corner();
                this.textLayouts[n] = new TextLayout(String.valueOf(n), this.font, frc);
                ++n;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Corner corner = this.selectedCorner;
            this.selectedCorner = null;
            int n = 0;
            while (n < 4) {
                if (propertyChangeEvent.getNewValue() == this.inCorners[n]) {
                    this.selectedCorner = this.inCorners[n];
                } else if (propertyChangeEvent.getNewValue() == this.outCorners[n]) {
                    this.selectedCorner = this.outCorners[n];
                }
                ++n;
            }
            if (this.selectedCorner != corner && PerspectiveFilter.this.vidPanel != null) {
                PerspectiveFilter.this.vidPanel.repaint();
            }
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            Object object;
            Object object2;
            if (!PerspectiveFilter.super.isEnabled()) {
                return;
            }
            VideoPanel videoPanel = (VideoPanel)drawingPanel;
            Corner[] cornerArray = PerspectiveFilter.this.isEnabled() ? this.outCorners : this.inCorners;
            int n = 0;
            while (n < 4) {
                this.screenPts[n] = cornerArray[n].getScreenPosition(videoPanel);
                this.transform.setToTranslation(this.screenPts[n].getX(), this.screenPts[n].getY());
                object2 = cornerArray[n] == this.selectedCorner ? this.selectionShape : this.cornerShape;
                object = cornerArray[n] == this.selectedCorner ? this.stroke : this.cornerStroke;
                this.hitShapes[n] = this.transform.createTransformedShape((Shape)object2);
                this.drawShapes[n] = object.createStrokedShape(this.hitShapes[n]);
                ++n;
            }
            this.path.reset();
            this.path.moveTo((float)this.screenPts[0].getX(), (float)this.screenPts[0].getY());
            this.path.lineTo((float)this.screenPts[1].getX(), (float)this.screenPts[1].getY());
            this.path.lineTo((float)this.screenPts[2].getX(), (float)this.screenPts[2].getY());
            this.path.lineTo((float)this.screenPts[3].getX(), (float)this.screenPts[3].getY());
            this.path.closePath();
            this.drawShapes[4] = this.stroke.createStrokedShape(this.path);
            Graphics2D graphics2D = (Graphics2D)graphics;
            object2 = graphics2D.getColor();
            graphics2D.setColor(this.color);
            object = graphics.getFont();
            graphics2D.setFont(this.font);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n2 = 0;
            while (n2 < this.drawShapes.length) {
                graphics2D.fill(this.drawShapes[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.textLayouts.length) {
                this.p.setLocation(this.screenPts[n2].getX() - 4.0 - (double)this.font.getSize(), this.screenPts[n2].getY() - 6.0);
                this.textLayouts[n2].draw(graphics2D, this.p.x, this.p.y);
                ++n2;
            }
            graphics2D.setFont((Font)object);
            graphics2D.setColor((Color)object2);
        }

        public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
            if (!PerspectiveFilter.super.isEnabled()) {
                return null;
            }
            if (!(drawingPanel instanceof VideoPanel) || !this.isEnabled()) {
                return null;
            }
            int n3 = 0;
            while (n3 < this.hitShapes.length) {
                if (this.hitShapes[n3] != null && this.hitShapes[n3].contains(n, n2)) {
                    if (!PerspectiveFilter.this.isEnabled()) {
                        return this.inCorners[n3];
                    }
                    return this.outCorners[n3];
                }
                ++n3;
            }
            return null;
        }

        public double getX() {
            return 0.0;
        }

        public double getY() {
            return 0.0;
        }

        public void setX(double d) {
        }

        public void setY(double d) {
        }

        public void setXY(double d, double d2) {
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isMeasured() {
            return false;
        }

        public double getXMin() {
            return this.getX();
        }

        public double getXMax() {
            return this.getX();
        }

        public double getYMin() {
            return this.getY();
        }

        public double getYMax() {
            return this.getY();
        }
    }
}

