/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoPanel;

public class RadialDistortionFilter
extends Filter {
    public static final String RECTILINEAR = "Rectilinear";
    public static final String EQUIDISTANT = "Equidistant";
    public static final String EQUISOLID = "Equisolid";
    public static final String STEREOGRAPHIC = "Stereographic";
    public static final String ORTHOGRAPHIC = "Orthographic";
    protected static final ArrayList<String> PROJECTION_TYPES = new ArrayList();
    protected static FontRenderContext frc = new FontRenderContext(null, false, false);
    protected static Color enabledColor;
    protected static Color disabledColor;
    protected static double minRadius;
    protected static double maxRadius;
    protected static double minFOV;
    protected static double maxFOV;
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private Graphics2D gIn;
    private int[] pixelsIn;
    private int[] pixelsOut;
    private double[] xOut;
    private double[] yOut;
    private double[] xIn;
    private double[] yIn;
    private int w;
    private int h;
    private double pixelsToCorner;
    private boolean isValidTransform = false;
    private boolean updatingDisplay = false;
    private double outputFOV;
    private boolean hasLowerLimit;
    private int lowerRadiusLimit = (int)(100.0 * minRadius);
    private int interpolation = 1;
    private double fixedRadius = 0.75;
    private double sourceFOV = 1.5707963267948966;
    private String sourceProjectionType = "Rectilinear";
    private String outputProjectionType = "Rectilinear";
    private Color color = Color.GREEN;
    private Inspector inspector;
    private Circle circle = new Circle();

    static {
        minRadius = 0.2;
        maxRadius = 1.0;
        minFOV = 0.17453292519943295;
        maxFOV = 3.1405926535897932;
        PROJECTION_TYPES.add(RECTILINEAR);
        PROJECTION_TYPES.add(EQUISOLID);
        PROJECTION_TYPES.add(EQUIDISTANT);
        PROJECTION_TYPES.add(STEREOGRAPHIC);
        PROJECTION_TYPES.add(ORTHOGRAPHIC);
        enabledColor = UIManager.getColor("Label.foreground");
        if (enabledColor == null) {
            enabledColor = Color.BLACK;
        }
        if ((disabledColor = UIManager.getColor("Label.disabledForeground")) == null) {
            disabledColor = UIManager.getColor("Label.disabledText");
        }
        if (disabledColor == null) {
            disabledColor = Color.LIGHT_GRAY;
        }
    }

    public RadialDistortionFilter() {
        this.refresh();
        this.hasInspector = true;
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToTransformed(this.input);
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        return this.inspector;
    }

    public void refresh() {
        super.refresh();
        this.ableButton.setText(this.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
        if (this.inspector != null) {
            this.inspector.refreshGUI();
        }
    }

    public void setFixedRadius(double d) {
        if (Double.isNaN(d)) {
            return;
        }
        d = Math.abs(d);
        d = Math.min(d, maxRadius);
        if (this.fixedRadius != (d = Math.max(d, minRadius))) {
            this.fixedRadius = d;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.isValidTransform = false;
            this.support.firePropertyChange("image", null, null);
        }
    }

    public double getFixedRadius() {
        return this.fixedRadius;
    }

    public void setSourceFOV(double d) {
        if (Double.isNaN(d)) {
            return;
        }
        d = Math.abs(d);
        d = Math.min(d, 3.141092653589793);
        if (this.sourceFOV != (d = Math.max(d, minFOV))) {
            this.sourceFOV = d;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.isValidTransform = false;
            this.support.firePropertyChange("image", null, null);
        }
    }

    public double getSourceFOV() {
        return this.sourceFOV;
    }

    public void setSourceProjectionType(String string) {
        if (!this.sourceProjectionType.equals(string) && PROJECTION_TYPES.contains(string)) {
            this.sourceProjectionType = string;
            this.hasLowerLimit = this.getAngleAtRadius(0.5, this.outputProjectionType, 1.5707963267948966) < this.getAngleAtRadius(0.5, this.sourceProjectionType, 1.5707963267948966);
            this.isValidTransform = false;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.support.firePropertyChange("image", null, null);
        }
    }

    public String getSourceProjectionType() {
        return this.sourceProjectionType;
    }

    public void setOutputProjectionType(String string) {
        if (!this.outputProjectionType.equals(string) && PROJECTION_TYPES.contains(string)) {
            this.outputProjectionType = string;
            this.hasLowerLimit = this.getAngleAtRadius(0.5, this.outputProjectionType, 1.5707963267948966) < this.getAngleAtRadius(0.5, this.sourceProjectionType, 1.5707963267948966);
            this.isValidTransform = false;
            if (this.inspector != null) {
                this.inspector.updateDisplay();
            }
            this.support.firePropertyChange("image", null, null);
        }
    }

    public String getOutputProjectionType() {
        return this.outputProjectionType;
    }

    private String[] getProjectionTypeDescriptions() {
        String[] stringArray = new String[PROJECTION_TYPES.size()];
        int n = 0;
        while (n < stringArray.length) {
            String string = PROJECTION_TYPES.get(n);
            stringArray[n] = MediaRes.getString("RadialDistortionFilter.ProjectionType." + string);
            ++n;
        }
        return stringArray;
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixelsToCorner = Math.sqrt(this.w * this.w + this.h * this.h) / 2.0;
        this.output = new BufferedImage(this.w, this.h, 1);
        this.pixelsIn = new int[this.w * this.h];
        this.pixelsOut = new int[this.w * this.h];
        this.xIn = new double[this.w * this.h];
        this.yIn = new double[this.w * this.h];
        this.xOut = new double[this.w * this.h];
        this.yOut = new double[this.w * this.h];
        int n = 0;
        while (n < this.w) {
            int n2 = 0;
            while (n2 < this.h) {
                this.xOut[n2 * this.w + n] = n;
                this.yOut[n2 * this.w + n] = n2;
                ++n2;
            }
            ++n;
        }
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
        this.isValidTransform = false;
    }

    private void setOutputToTransformed(BufferedImage bufferedImage) {
        if (!this.isValidTransform) {
            this.transform(this.xOut, this.yOut, this.xIn, this.yIn);
        }
        bufferedImage.getRaster().getDataElements(0, 0, this.w, this.h, this.pixelsIn);
        int n = 0;
        while (n < this.pixelsOut.length) {
            this.pixelsOut[n] = this.getColor(this.xIn[n], this.yIn[n], this.w, this.h, this.pixelsIn);
            ++n;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixelsOut);
    }

    private void transform(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.refreshScale();
        double d = (double)this.w / 2.0;
        double d2 = (double)this.h / 2.0;
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d3 = dArray[n2] - d;
            double d4 = dArray2[n2] - d2;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = this.getStretchFactor(d5);
            double d7 = 1.0E-4;
            dArray3[n2] = d + d6 * d3 + d7;
            dArray4[n2] = d2 + d6 * d4 + d7;
            ++n2;
        }
        this.isValidTransform = true;
    }

    private double findRadiusLimit() {
        double d = 1.0E-6;
        int n = 10;
        double d2 = 0.8;
        double d3 = this.getAngleAtRadius(d2, this.sourceProjectionType, this.sourceFOV) - this.getAngleAtRadius(d2, this.outputProjectionType, Math.PI);
        double d4 = this.getDerivativeAtRadius(d2, this.sourceProjectionType, this.sourceFOV) - this.getDerivativeAtRadius(d2, this.outputProjectionType, Math.PI);
        int n2 = 0;
        while (Math.abs(d3) > d && n2 < n) {
            d3 = this.getAngleAtRadius(d2 -= d3 / d4, this.sourceProjectionType, this.sourceFOV) - this.getAngleAtRadius(d2, this.outputProjectionType, Math.PI);
            d4 = this.getDerivativeAtRadius(d2, this.sourceProjectionType, this.sourceFOV) - this.getDerivativeAtRadius(d2, this.outputProjectionType, Math.PI);
            ++n2;
        }
        return n2 < n ? d2 : Double.NaN;
    }

    private double getAngleAtRadius(double d, String string, double d2) {
        if (RECTILINEAR.equals(string)) {
            return Math.atan(d * Math.tan(d2 / 2.0));
        }
        if (EQUIDISTANT.equals(string)) {
            return d * d2 / 2.0;
        }
        if (EQUISOLID.equals(string)) {
            return 2.0 * Math.asin(d * Math.sin(d2 / 4.0));
        }
        if (STEREOGRAPHIC.equals(string)) {
            return 2.0 * Math.atan(d * Math.tan(d2 / 4.0));
        }
        if (ORTHOGRAPHIC.equals(string)) {
            return Math.asin(d * Math.sin(d2 / 2.0));
        }
        return d * d2 / 2.0;
    }

    private double getDerivativeAtRadius(double d, String string, double d2) {
        if (RECTILINEAR.equals(string)) {
            double d3 = Math.tan(d2 / 2.0);
            return d3 / (1.0 + d * d * d3 * d3);
        }
        if (EQUIDISTANT.equals(string)) {
            return d2 / 2.0;
        }
        if (EQUISOLID.equals(string)) {
            double d4 = Math.sin(d2 / 4.0);
            return 2.0 * d4 / Math.sqrt(1.0 - d * d * d4 * d4);
        }
        if (STEREOGRAPHIC.equals(string)) {
            double d5 = Math.tan(d2 / 4.0);
            return 2.0 * d5 / (1.0 + d * d * d5 * d5);
        }
        if (ORTHOGRAPHIC.equals(string)) {
            double d6 = Math.sin(d2 / 2.0);
            return d6 / Math.sqrt(1.0 - d * d * d6 * d6);
        }
        return d2 / 2.0;
    }

    private void refreshScale() {
        if (this.sourceFOV == 0.0) {
            return;
        }
        double d = this.getAngleAtRadius(this.fixedRadius, this.sourceProjectionType, this.sourceFOV);
        if (RECTILINEAR.equals(this.outputProjectionType)) {
            this.outputFOV = 2.0 * Math.atan(Math.tan(d) / this.fixedRadius);
        } else if (EQUIDISTANT.equals(this.outputProjectionType)) {
            this.outputFOV = 2.0 * d / this.fixedRadius;
        } else if (EQUISOLID.equals(this.outputProjectionType)) {
            this.outputFOV = 4.0 * Math.asin(Math.sin(d / 2.0) / this.fixedRadius);
        } else if (STEREOGRAPHIC.equals(this.outputProjectionType)) {
            this.outputFOV = 4.0 * Math.atan(Math.tan(d / 2.0) / this.fixedRadius);
        } else if (ORTHOGRAPHIC.equals(this.outputProjectionType)) {
            this.outputFOV = 2.0 * Math.asin(Math.sin(d) / this.fixedRadius);
        }
        if (Double.isNaN(this.outputFOV)) {
            this.outputFOV = maxFOV;
        }
        if (this.hasLowerLimit) {
            double d2 = this.findRadiusLimit();
            if (!Double.isNaN(d2) && d2 > 0.005 && d2 < 1.01) {
                this.lowerRadiusLimit = Math.max((int)Math.floor(100.0 * d2), (int)(100.0 * minRadius));
            }
            if (this.outputFOV > maxFOV && this.fixedRadius != (double)this.lowerRadiusLimit / 100.0) {
                this.fixedRadius = (double)this.lowerRadiusLimit / 100.0;
                this.refreshScale();
            }
        } else {
            this.lowerRadiusLimit = (int)(100.0 * minRadius);
        }
    }

    private double getStretchFactor(double d) {
        if (d == 0.0 || this.sourceFOV == 0.0) {
            return 1.0;
        }
        double d2 = d / this.pixelsToCorner;
        double d3 = this.getAngleAtRadius(d2, this.outputProjectionType, this.outputFOV);
        double d4 = d;
        if (RECTILINEAR.equals(this.sourceProjectionType)) {
            double d5 = this.pixelsToCorner / Math.tan(this.sourceFOV / 2.0);
            d4 = d5 * Math.tan(d3);
        } else if (EQUIDISTANT.equals(this.sourceProjectionType)) {
            double d6 = 2.0 * this.pixelsToCorner / this.sourceFOV;
            d4 = d6 * d3;
        } else if (EQUISOLID.equals(this.sourceProjectionType)) {
            double d7 = this.pixelsToCorner / Math.sin(this.sourceFOV / 4.0);
            d4 = d7 * Math.sin(d3 / 2.0);
        } else if (STEREOGRAPHIC.equals(this.sourceProjectionType)) {
            double d8 = this.pixelsToCorner / Math.tan(this.sourceFOV / 4.0);
            d4 = d8 * Math.tan(d3 / 2.0);
        } else if (ORTHOGRAPHIC.equals(this.sourceProjectionType)) {
            double d9 = this.pixelsToCorner / Math.sin(this.sourceFOV / 2.0);
            d4 = d9 * Math.sin(d3);
        }
        return d4 / d;
    }

    private int getColor(double d, double d2, int n, int n2, int[] nArray) {
        double d3;
        int n3 = (int)Math.floor(d);
        int n4 = (int)Math.floor(d2);
        if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
            return 0;
        }
        if (n3 + 1 == n || n4 + 1 == n2) {
            return nArray[n4 * n + n3];
        }
        double d4 = n3 == 0 ? d : d % (double)n3;
        double d5 = d3 = n4 == 0 ? d2 : d2 % (double)n4;
        if (this.interpolation == 2) {
            int[] nArray2 = new int[]{nArray[n4 * n + n3], nArray[n4 * n + n3 + 1], nArray[(n4 + 1) * n + n3], nArray[(n4 + 1) * n + n3 + 1]};
            int[] nArray3 = new int[4];
            int n5 = 0;
            while (n5 < 4) {
                nArray3[n5] = nArray2[n5] >> 16 & 0xFF;
                ++n5;
            }
            n5 = this.bilinearInterpolation(d4, d3, nArray3);
            int n6 = 0;
            while (n6 < 4) {
                nArray3[n6] = nArray2[n6] >> 8 & 0xFF;
                ++n6;
            }
            n6 = this.bilinearInterpolation(d4, d3, nArray3);
            int n7 = 0;
            while (n7 < 4) {
                nArray3[n7] = nArray2[n7] & 0xFF;
                ++n7;
            }
            n7 = this.bilinearInterpolation(d4, d3, nArray3);
            return n5 << 16 | n6 << 8 | n7;
        }
        return d4 < 0.5 ? (d3 < 0.5 ? nArray[n4 * n + n3] : nArray[(n4 + 1) * n + n3]) : (d3 < 0.5 ? nArray[n4 * n + n3 + 1] : nArray[(n4 + 1) * n + n3 + 1]);
    }

    private int bilinearInterpolation(double d, double d2, int[] nArray) {
        return (int)((1.0 - d2) * ((1.0 - d) * (double)nArray[0] + d * (double)nArray[2]) + d2 * ((1.0 - d) * (double)nArray[1] + d * (double)nArray[3]));
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Circle
    implements Trackable {
        TPoint center = new TPoint();
        TPoint corner = new TPoint();
        Ellipse2D ellipse = new Ellipse2D.Double();
        Stroke stroke = new BasicStroke(2.0f);

        private Circle() {
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            if (!RadialDistortionFilter.super.isEnabled()) {
                return;
            }
            VideoPanel videoPanel = (VideoPanel)drawingPanel;
            BufferedImage bufferedImage = videoPanel.getVideo().getImage();
            double d = bufferedImage.getWidth() / 2;
            double d2 = bufferedImage.getHeight() / 2;
            double d3 = RadialDistortionFilter.this.fixedRadius * RadialDistortionFilter.this.pixelsToCorner;
            this.center.setLocation(d, d2);
            this.corner.setLocation(d - d3, d2 - d3);
            Point point = this.center.getScreenPosition(videoPanel);
            Point point2 = this.corner.getScreenPosition(videoPanel);
            this.ellipse.setFrameFromCenter(point, point2);
            Shape shape = this.stroke.createStrokedShape(this.ellipse);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(RadialDistortionFilter.this.color);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(shape);
            graphics2D.setColor(color);
        }
    }

    private class Inspector
    extends JDialog {
        JButton helpButton;
        JButton colorButton;
        JPanel contentPane;
        JSlider radiusSlider;
        JSlider sourceAngleSlider;
        JComboBox sourceTypeDropdown;
        JComboBox outputTypeDropdown;
        JLabel radiusLabel;
        JLabel sourceAngleLabel;
        JLabel outputAngleLabel;
        JLabel sourceTypeLabel;
        JLabel outputTypeLabel;
        IntegerField radiusField;
        IntegerField sourceAngleField;
        IntegerField outputAngleField;
        TitledBorder sourceBorder;
        TitledBorder outputBorder;
        TitledBorder circleBorder;

        public Inspector() {
            super(RadialDistortionFilter.this.frame, !(RadialDistortionFilter.this.frame instanceof OSPFrame));
            this.setResizable(false);
            this.createGUI();
            this.refreshGUI();
            this.pack();
            this.updateDisplay();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            this.helpButton = new JButton();
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = String.valueOf(MediaRes.getString("RadialDistortionFilter.Help.Message1")) + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message2") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message3") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message4") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message5") + "\n\n" + MediaRes.getString("RadialDistortionFilter.Help.Message6") + "\n" + MediaRes.getString("RadialDistortionFilter.Help.Message7");
                    int n = 0;
                    while (n < PROJECTION_TYPES.size()) {
                        String string2 = PROJECTION_TYPES.get(n);
                        string = String.valueOf(string) + "\n    " + (n + 1) + ". " + MediaRes.getString("RadialDistortionFilter.Help.Message." + string2);
                        ++n;
                    }
                    string = String.valueOf(string) + "\n\n" + MediaRes.getString("RadialDistortionFilter.Help.Message8") + "\n    " + MediaRes.getString("RadialDistortionFilter.Help.Message9") + "\n    " + MediaRes.getString("RadialDistortionFilter.Help.Message10") + "\n    " + MediaRes.getString("RadialDistortionFilter.Help.Message11");
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(((Inspector)Inspector.this).RadialDistortionFilter.this.vidPanel), string, MediaRes.getString("RadialDistortionFilter.Help.Title"), 1);
                }
            });
            this.colorButton = new JButton();
            this.colorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(null, MediaRes.getString("PerspectiveFilter.Dialog.Color.Title"), RadialDistortionFilter.this.color);
                    if (color != null) {
                        RadialDistortionFilter.this.color = color;
                        ((Inspector)Inspector.this).RadialDistortionFilter.this.support.firePropertyChange("color", null, color);
                    }
                }
            });
            Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            String[] stringArray = RadialDistortionFilter.this.getProjectionTypeDescriptions();
            this.sourceTypeDropdown = new JComboBox<String>(stringArray);
            this.sourceTypeDropdown.setSelectedItem(MediaRes.getString("RadialDistortionFilter.ProjectionType." + RadialDistortionFilter.this.sourceProjectionType));
            this.sourceTypeDropdown.setBorder(border);
            this.sourceTypeDropdown.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = Inspector.this.sourceTypeDropdown.getSelectedItem().toString();
                    String[] stringArray = RadialDistortionFilter.this.getProjectionTypeDescriptions();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equals(string)) {
                            RadialDistortionFilter.this.setSourceProjectionType(PROJECTION_TYPES.get(n));
                        }
                        ++n;
                    }
                }
            });
            this.outputTypeDropdown = new JComboBox<String>(stringArray);
            this.outputTypeDropdown.setSelectedItem(MediaRes.getString("RadialDistortionFilter.ProjectionType." + RadialDistortionFilter.this.outputProjectionType));
            this.outputTypeDropdown.setBorder(border);
            this.outputTypeDropdown.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = Inspector.this.outputTypeDropdown.getSelectedItem().toString();
                    String[] stringArray = RadialDistortionFilter.this.getProjectionTypeDescriptions();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equals(string)) {
                            RadialDistortionFilter.this.setOutputProjectionType(PROJECTION_TYPES.get(n));
                        }
                        ++n;
                    }
                }
            });
            border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            this.sourceAngleSlider = new JSlider(5, 180, 90);
            this.sourceAngleSlider.setBorder(border);
            this.sourceAngleSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = Inspector.this.sourceAngleSlider.getValue();
                    RadialDistortionFilter.this.setSourceFOV((double)n * Math.PI / 180.0);
                }
            });
            int n = (int)(100.0 * maxRadius);
            int n2 = (int)(100.0 * minRadius);
            int n3 = (int)(100.0 * RadialDistortionFilter.this.fixedRadius);
            this.radiusSlider = new JSlider(n2, n, n3);
            this.radiusSlider.setBorder(border);
            this.radiusSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = Inspector.this.radiusSlider.getValue();
                    n = Math.max(n, RadialDistortionFilter.this.lowerRadiusLimit);
                    RadialDistortionFilter.this.setFixedRadius((double)n / 100.0);
                }
            });
            this.radiusSlider.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    Inspector.this.updateDisplay();
                }
            });
            border = BorderFactory.createEmptyBorder(2, 4, 2, 2);
            this.sourceTypeLabel = new JLabel();
            this.sourceTypeLabel.setBorder(border);
            this.outputTypeLabel = new JLabel();
            this.outputTypeLabel.setBorder(border);
            this.sourceAngleLabel = new JLabel();
            this.sourceAngleLabel.setBorder(border);
            this.outputAngleLabel = new JLabel();
            this.outputAngleLabel.setBorder(border);
            this.radiusLabel = new JLabel();
            this.radiusLabel.setBorder(border);
            this.sourceAngleField = new IntegerField(3);
            this.sourceAngleField.setMaxValue(180.0);
            this.sourceAngleField.setMinValue(5.0);
            this.sourceAngleField.setUnits("\u00ba");
            this.sourceAngleField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Inspector.this.sourceAngleField.getIntValue();
                    RadialDistortionFilter.this.setSourceFOV((double)n * Math.PI / 180.0);
                    Inspector.this.updateDisplay();
                    Inspector.this.sourceAngleField.selectAll();
                }
            });
            this.sourceAngleField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    Inspector.this.sourceAngleField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    int n = Inspector.this.sourceAngleField.getIntValue();
                    RadialDistortionFilter.this.setSourceFOV((double)n * Math.PI / 180.0);
                    Inspector.this.updateDisplay();
                }
            });
            this.outputAngleField = new IntegerField(3);
            this.outputAngleField.setMaxValue(180.0);
            this.outputAngleField.setMinValue(0.0);
            this.outputAngleField.setEditable(false);
            this.outputAngleField.setUnits("\u00ba");
            this.radiusField = new IntegerField(3);
            this.radiusField.setMaxValue(n);
            this.radiusField.setMinValue(n2);
            this.radiusField.setUnits("%");
            this.radiusField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Inspector.this.radiusField.getIntValue();
                    RadialDistortionFilter.this.setFixedRadius((double)n / 100.0);
                    Inspector.this.updateDisplay();
                    Inspector.this.radiusField.selectAll();
                }
            });
            this.radiusField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    Inspector.this.radiusField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    int n = Inspector.this.radiusField.getIntValue();
                    RadialDistortionFilter.this.setFixedRadius((double)n / 100.0);
                    Inspector.this.updateDisplay();
                }
            });
            this.contentPane = new JPanel(new BorderLayout());
            this.setContentPane(this.contentPane);
            JPanel jPanel = new JPanel(new FlowLayout());
            this.contentPane.add((Component)jPanel, "South");
            jPanel.add(this.helpButton);
            jPanel.add(this.colorButton);
            jPanel.add(RadialDistortionFilter.this.ableButton);
            jPanel.add(RadialDistortionFilter.this.closeButton);
            border = BorderFactory.createEmptyBorder(2, 2, 2, 4);
            Box box = Box.createVerticalBox();
            this.contentPane.add((Component)box, "Center");
            Box box2 = Box.createVerticalBox();
            this.sourceBorder = BorderFactory.createTitledBorder("");
            this.sourceBorder.setTitleColor(Color.red);
            box2.setBorder(this.sourceBorder);
            box.add(box2);
            Box box3 = Box.createHorizontalBox();
            box3.setBorder(border);
            box3.add(this.sourceTypeLabel);
            box3.add(this.sourceTypeDropdown);
            box3.add(this.sourceAngleLabel);
            box3.add(this.sourceAngleField);
            box2.add(box3);
            box3 = Box.createHorizontalBox();
            box3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            box3.add(this.sourceAngleSlider);
            box2.add(box3);
            Box box4 = Box.createVerticalBox();
            this.outputBorder = BorderFactory.createTitledBorder("");
            box4.setBorder(this.outputBorder);
            box.add(box4);
            box3 = Box.createHorizontalBox();
            box3.setBorder(border);
            box3.add(this.outputTypeLabel);
            box3.add(this.outputTypeDropdown);
            box3.add(this.outputAngleLabel);
            box3.add(this.outputAngleField);
            box4.add(box3);
            Box box5 = Box.createVerticalBox();
            this.circleBorder = BorderFactory.createTitledBorder("");
            box5.setBorder(this.circleBorder);
            box.add(box5);
            box3 = Box.createHorizontalBox();
            box3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            box3.add(this.radiusLabel);
            box3.add(this.radiusField);
            box3.add(this.radiusSlider);
            box5.add(box3);
        }

        void refreshGUI() {
            this.setTitle(MediaRes.getString("RadialDistortionFilter.Inspector.Title"));
            this.sourceTypeLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.ProjectionType")) + ":");
            this.outputTypeLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.ProjectionType")) + ":");
            this.sourceAngleLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Angle")) + ":");
            this.outputAngleLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Angle")) + ":");
            this.radiusLabel.setText(String.valueOf(MediaRes.getString("RadialDistortionFilter.Label.Diameter")) + ":");
            this.helpButton.setText(MediaRes.getString("PerspectiveFilter.Button.Help"));
            this.colorButton.setText(MediaRes.getString("PerspectiveFilter.Button.Color"));
            this.sourceBorder.setTitle(MediaRes.getString("RadialDistortionFilter.BorderTitle.Source"));
            this.outputBorder.setTitle(MediaRes.getString("RadialDistortionFilter.BorderTitle.Output"));
            this.circleBorder.setTitle(MediaRes.getString("RadialDistortionFilter.BorderTitle.Circle"));
            boolean bl = RadialDistortionFilter.this.isEnabled();
            this.sourceTypeLabel.setEnabled(bl);
            this.outputTypeLabel.setEnabled(bl);
            this.radiusLabel.setEnabled(bl);
            this.sourceAngleLabel.setEnabled(bl);
            this.outputAngleLabel.setEnabled(bl);
            this.radiusField.setEnabled(bl);
            this.sourceAngleField.setEnabled(bl);
            this.outputAngleField.setEnabled(bl);
            this.radiusSlider.setEnabled(bl);
            this.sourceAngleSlider.setEnabled(bl);
            this.sourceTypeDropdown.setEnabled(bl);
            this.outputTypeDropdown.setEnabled(bl);
            this.colorButton.setEnabled(bl);
            Color color = bl ? enabledColor : disabledColor;
            this.sourceBorder.setTitleColor(color);
            this.outputBorder.setTitleColor(color);
            this.circleBorder.setTitleColor(color);
            this.repaint();
        }

        void updateDisplay() {
            if (RadialDistortionFilter.this.updatingDisplay) {
                return;
            }
            RadialDistortionFilter.this.updatingDisplay = true;
            RadialDistortionFilter.this.refreshScale();
            int n = (int)Math.round(180.0 * RadialDistortionFilter.this.sourceFOV / Math.PI);
            this.sourceAngleField.setIntValue(n);
            this.sourceAngleSlider.setValue(n);
            n = (int)Math.round(180.0 * RadialDistortionFilter.this.outputFOV / Math.PI);
            this.outputAngleField.setIntValue(n);
            n = (int)Math.round(100.0 * RadialDistortionFilter.this.fixedRadius);
            this.radiusSlider.setValue(n);
            this.radiusField.setIntValue(n);
            RadialDistortionFilter.this.updatingDisplay = false;
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.refreshGUI();
            if (RadialDistortionFilter.this.vidPanel != null) {
                if (bl) {
                    RadialDistortionFilter.this.vidPanel.addDrawable(RadialDistortionFilter.this.circle);
                    RadialDistortionFilter.this.support.firePropertyChange("visible", null, null);
                    RadialDistortionFilter.this.addPropertyChangeListener("visible", RadialDistortionFilter.this.vidPanel);
                } else {
                    RadialDistortionFilter.this.vidPanel.removeDrawable(RadialDistortionFilter.this.circle);
                    RadialDistortionFilter.this.support.firePropertyChange("visible", null, null);
                    RadialDistortionFilter.this.removePropertyChangeListener("visible", RadialDistortionFilter.this.vidPanel);
                }
            }
            RadialDistortionFilter.this.support.firePropertyChange("image", null, null);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            RadialDistortionFilter radialDistortionFilter = (RadialDistortionFilter)object;
            xMLControl.setValue("fixed_radius", radialDistortionFilter.fixedRadius);
            xMLControl.setValue("input_type", radialDistortionFilter.sourceProjectionType);
            xMLControl.setValue("input_fov", radialDistortionFilter.sourceFOV);
            xMLControl.setValue("output_type", radialDistortionFilter.outputProjectionType);
            xMLControl.setValue("color", radialDistortionFilter.color);
            if (radialDistortionFilter.frame != null && radialDistortionFilter.inspector != null && radialDistortionFilter.inspector.isVisible()) {
                int n = ((RadialDistortionFilter)radialDistortionFilter).inspector.getLocation().x - radialDistortionFilter.frame.getLocation().x;
                int n2 = ((RadialDistortionFilter)radialDistortionFilter).inspector.getLocation().y - radialDistortionFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new RadialDistortionFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            RadialDistortionFilter radialDistortionFilter = (RadialDistortionFilter)object;
            radialDistortionFilter.setFixedRadius(xMLControl.getDouble("fixed_radius"));
            radialDistortionFilter.setSourceFOV(xMLControl.getDouble("input_fov"));
            radialDistortionFilter.setSourceProjectionType(xMLControl.getString("input_type"));
            radialDistortionFilter.setOutputProjectionType(xMLControl.getString("output_type"));
            Color color = (Color)xMLControl.getObject("color");
            if (color != null) {
                radialDistortionFilter.color = color;
            }
            radialDistortionFilter.inspectorX = xMLControl.getInt("inspector_x");
            radialDistortionFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

