/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TCircle
extends TShape {
    protected Ellipse2D circle = new Ellipse2D.Double();
    protected int radius = 5;
    protected int n;

    public TCircle(int n) {
        this(n, 0.0, 0.0);
    }

    public TCircle(int n, double d, double d2) {
        super(d, d2);
        this.n = n;
        this.setColor(Color.red);
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getFrameNumber(VideoPanel videoPanel) {
        return this.n;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof VideoPanel)) {
            return null;
        }
        VideoPanel videoPanel = (VideoPanel)drawingPanel;
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        if (this.getBounds(videoPanel).contains(n, n2)) {
            return this;
        }
        return null;
    }

    protected Shape getShape(VideoPanel videoPanel) {
        Point point = this.getScreenPosition(videoPanel);
        double d = point.x - this.radius;
        double d2 = point.y - this.radius;
        if (this.stroke == null) {
            this.circle.setFrame(d, d2, 2 * this.radius, 2 * this.radius);
            return this.circle;
        }
        double d3 = this.stroke.getLineWidth();
        this.circle.setFrame(d + d3 / 2.0, d2 + d3 / 2.0, (double)(2 * this.radius) - d3, (double)(2 * this.radius) - d3);
        return this.stroke.createStrokedShape(this.circle);
    }
}

