/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TLine
extends TShape {
    protected Line2D line = new Line2D.Double();
    protected TPoint end1 = new LineEnd();
    protected TPoint end2 = new LineEnd();
    protected Rectangle end1Rect = new Rectangle(0, 0, 8, 8);
    protected Rectangle end2Rect = new Rectangle(0, 0, 8, 8);

    public TLine() {
    }

    public TLine(double d, double d2, double d3, double d4) {
        this.end1.setXY(d, d2);
        this.end2.setXY(d3, d4);
    }

    public TPoint getEnd1() {
        return this.end1;
    }

    public TPoint getEnd2() {
        return this.end2;
    }

    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke != null) {
            this.stroke = basicStroke;
        }
    }

    public void setXY(double d, double d2) {
        double d3 = d - this.getX();
        double d4 = d2 - this.getY();
        this.end1.translate(d3, d4);
        this.end2.translate(d3, d4);
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (this.end1Rect.contains(n, n2)) {
            return this.end1;
        }
        if (this.end2Rect.contains(n, n2)) {
            return this.end2;
        }
        this.setHitRectCenter(n, n2);
        if (this.line.intersects(hitRect)) {
            return this;
        }
        return null;
    }

    protected Shape getShape(VideoPanel videoPanel) {
        this.center(this.end1, this.end2);
        Point point = this.end1.getScreenPosition(videoPanel);
        Point point2 = this.end2.getScreenPosition(videoPanel);
        this.line.setLine(point, point2);
        this.end1Rect.setLocation(point.x - 4, point.y - 4);
        this.end2Rect.setLocation(point2.x - 4, point2.y - 4);
        return this.stroke.createStrokedShape(this.line);
    }

    class LineEnd
    extends TPoint {
        LineEnd() {
        }

        public Rectangle getBounds(VideoPanel videoPanel) {
            return TLine.this.getBounds(videoPanel);
        }
    }
}

