/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.TLine;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;

public class TLineProfile
extends TLine {
    protected int[] pixels = new int[0];
    protected int[] values = new int[0];

    public TLineProfile(double d, double d2, double d3, double d4) {
        this.end1 = new LineEnd(d, d2);
        this.end2 = new LineEnd(d3, d4);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!(drawingPanel instanceof VideoPanel)) {
            return;
        }
        VideoPanel videoPanel = (VideoPanel)drawingPanel;
        if (!this.isVisible()) {
            return;
        }
        super.draw(videoPanel, graphics);
        this.getProfileData(videoPanel);
    }

    public int[] getProfile() {
        return this.values;
    }

    protected void getProfileData(VideoPanel videoPanel) {
        BufferedImage bufferedImage;
        if (videoPanel.getVideo() == null) {
            return;
        }
        int n = (int)this.end1.distance(this.end2);
        if (n != this.pixels.length) {
            this.pixels = new int[n];
            this.values = new int[n];
        }
        if ((bufferedImage = videoPanel.getVideo().getImage()).getType() == 1) {
            try {
                int n2 = Math.min((int)this.end1.getX(), (int)this.end2.getX());
                int n3 = (int)this.end1.getY();
                bufferedImage.getRaster().getDataElements(n2, n3, n, 1, this.pixels);
                int n4 = 0;
                while (n4 < this.pixels.length) {
                    int n5 = this.pixels[n4];
                    int n6 = n5 >> 16 & 0xFF;
                    int n7 = n5 >> 8 & 0xFF;
                    int n8 = n5 & 0xFF;
                    this.values[n4] = (n6 + n7 + n8) / 3;
                    ++n4;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
    }

    private class LineEnd
    extends TPoint {
        public LineEnd(double d, double d2) {
            super(d, d2);
        }

        public void setXY(double d, double d2) {
            this.setLocation(d, this.getY());
        }

        public void translate(double d, double d2) {
            this.setLocation(this.getX() + d, this.getY() + d2);
        }

        public Rectangle getBounds(VideoPanel videoPanel) {
            return TLineProfile.this.getBounds(videoPanel);
        }
    }
}

