/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TVector
extends TShape {
    protected GeneralPath path = new GeneralPath();
    protected Line2D line = new Line2D.Double();
    protected Shape head;
    protected Shape shaft;
    protected int length = 16;
    protected int width = 4;
    protected AffineTransform rotation = new AffineTransform();
    protected TPoint tail = new LineEnd();
    protected TPoint tip = new LineEnd();
    protected Rectangle tipRect = new Rectangle(0, 0, 8, 8);
    protected boolean tipEnabled = true;

    public TVector() {
        this.setStroke(new BasicStroke(1.0f));
    }

    public TVector(double d, double d2, double d3, double d4) {
        this.tail.setXY(d, d2);
        this.tip.setXY(d + d3, d2 + d4);
        this.setStroke(new BasicStroke(1.0f));
    }

    public TPoint getTip() {
        return this.tip;
    }

    public TPoint getTail() {
        return this.tail;
    }

    public void setXComponent(double d) {
        this.tip.setX(this.tail.getX() + d);
    }

    public void setYComponent(double d) {
        this.tip.setY(this.tail.getY() + d);
    }

    public void setXYComponents(double d, double d2) {
        this.tip.setXY(this.tail.getX() + d, this.tail.getY() + d2);
    }

    public double getXComponent() {
        return this.tip.getX() - this.tail.getX();
    }

    public double getYComponent() {
        return this.tip.getY() - this.tail.getY();
    }

    public void setXY(double d, double d2) {
        double d3 = d - this.getX();
        double d4 = d2 - this.getY();
        this.tip.translate(d3, d4);
        this.tail.translate(d3, d4);
    }

    public void setTipEnabled(boolean bl) {
        this.tipEnabled = bl;
    }

    public boolean isTipEnabled() {
        return this.tipEnabled;
    }

    public void setTipLength(int n) {
        n = Math.max(8, n);
        this.width = n / 4;
        this.length = 4 * this.width;
    }

    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        this.stroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, basicStroke.getDashArray(), basicStroke.getDashPhase());
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof VideoPanel)) {
            return null;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        this.setHitRectCenter(n, n2);
        if (this.shaft != null && this.shaft.intersects(hitRect)) {
            return this;
        }
        if (this.tipEnabled && this.head != null && this.head.intersects(hitRect)) {
            return this.tip;
        }
        return null;
    }

    protected Shape getShape(VideoPanel videoPanel) {
        this.center(this.tip, this.tail);
        Point point = this.tail.getScreenPosition(videoPanel);
        Point point2 = this.tip.getScreenPosition(videoPanel);
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        this.rotation.setToRotation(d, point.x, point.y);
        this.rotation.translate(point.x, point.y);
        float f = (float)point.distance(point2);
        this.path.reset();
        this.path.moveTo(f - 4.0f, 0.0f);
        this.path.lineTo(f - 6.0f, -2.0f);
        this.path.lineTo(f, 0.0f);
        this.path.lineTo(f - 6.0f, 2.0f);
        this.path.closePath();
        this.head = this.rotation.createTransformedShape(this.path);
        float f2 = this.stroke.getLineWidth();
        this.line.setLine(0.0, 0.0, (f -= 1.58f * f2) - (float)this.length, 0.0);
        this.shaft = this.rotation.createTransformedShape(this.line);
        this.path.reset();
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo(f - (float)this.length + (float)this.width, 0.0f);
        this.path.lineTo(f - (float)this.length, -this.width);
        this.path.lineTo(f, 0.0f);
        this.path.lineTo(f - (float)this.length, this.width);
        this.path.lineTo(f - (float)this.length + (float)this.width, 0.0f);
        Shape shape = this.rotation.createTransformedShape(this.path);
        return this.stroke.createStrokedShape(shape);
    }

    class LineEnd
    extends TPoint {
        LineEnd() {
        }

        public Rectangle getBounds(VideoPanel videoPanel) {
            return TVector.this.getBounds(videoPanel);
        }

        public int getFrameNumber(VideoPanel videoPanel) {
            return TVector.this.getFrameNumber(videoPanel);
        }
    }
}

