/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.UserFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateMatcher {
    private static final double LARGE_NUMBER = 1.0E10;
    private BufferedImage original;
    private BufferedImage template;
    private BufferedImage working;
    private BufferedImage match;
    private Shape mask;
    private int[] pixels;
    private int[] templateR;
    private int[] templateG;
    private int[] templateB;
    private boolean[] isPixelTransparent;
    private int[] targetPixels;
    private int[] matchPixels;
    private int wTemplate;
    private int hTemplate;
    private int wTarget;
    private int hTarget;
    private int wTest;
    private int hTest;
    private TPoint p = new TPoint();
    private double largeNumber = 1.0E20;
    private DatasetCurveFitter fitter;
    private Dataset dataset;
    private UserFunction f;
    private double[] pixelOffsets = new double[]{-1.0, 0.0, 1.0};
    private double[] xValues = new double[3];
    private double[] yValues = new double[3];
    private double peakHeight;
    private double peakWidth;
    private int trimLeft;
    private int trimTop;
    private int[] alphas = new int[2];
    private int index;

    public TemplateMatcher(BufferedImage bufferedImage, Shape shape) {
        this.mask = shape;
        this.setTemplate(bufferedImage);
        this.dataset = new Dataset();
        this.fitter = new DatasetCurveFitter(this.dataset, new FitBuilder(null));
        this.fitter.setActive(true);
        this.fitter.setAutofit(true);
        this.f = new UserFunction("gaussian");
        this.f.setParameters(new String[]{"a", "b", "c"}, new double[]{1.0, 0.0, 1.0});
        this.f.setExpression("a*exp(-(x-b)^2/c)", new String[]{"x"});
    }

    public void setTemplate(BufferedImage bufferedImage) {
        if (this.template != null && bufferedImage.getType() == 2 && this.wTemplate == bufferedImage.getWidth() && this.hTemplate == bufferedImage.getHeight()) {
            this.template = bufferedImage;
            this.template.getRaster().getDataElements(0, 0, this.wTemplate, this.hTemplate, this.pixels);
            int n = 0;
            while (n < this.pixels.length) {
                int n2 = this.pixels[n];
                this.templateR[n] = TemplateMatcher.getRed(n2);
                this.templateG[n] = TemplateMatcher.getGreen(n2);
                this.templateB[n] = TemplateMatcher.getBlue(n2);
                this.isPixelTransparent[n] = TemplateMatcher.getAlpha(n2) == 0;
                ++n;
            }
        } else {
            if (bufferedImage.getType() != 2) {
                this.original = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                this.original.createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
            } else {
                this.original = bufferedImage;
            }
            this.template = this.buildTemplate(this.original, 255, 0);
            this.setTemplate(this.template);
        }
    }

    public BufferedImage getTemplate() {
        if (this.template == null) {
            this.template = this.buildTemplate(this.original, 255, 0);
            this.setTemplate(this.template);
        }
        return this.template;
    }

    public BufferedImage buildTemplate(BufferedImage bufferedImage, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        BufferedImage bufferedImage2;
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        if (this.original.getWidth() != n8 || this.original.getHeight() != n9) {
            return null;
        }
        if (n == 0 && n2 == 0) {
            return this.template != null ? this.template : this.original;
        }
        this.alphas[0] = n;
        this.alphas[1] = n2;
        if (bufferedImage.getType() == 2) {
            bufferedImage2 = bufferedImage;
        } else {
            bufferedImage2 = new BufferedImage(n8, n9, 2);
            bufferedImage2.createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
        }
        if (this.working == null) {
            this.working = new BufferedImage(n8, n9, 2);
        }
        if (this.template == null || n8 != this.wTemplate || n9 != this.hTemplate) {
            this.wTemplate = n8;
            this.hTemplate = n9;
            int n10 = n8 * n9;
            this.template = new BufferedImage(n8, n9, 2);
            this.pixels = new int[n10];
            this.templateR = new int[n10];
            this.templateG = new int[n10];
            this.templateB = new int[n10];
            this.isPixelTransparent = new boolean[n10];
            this.matchPixels = new int[n10];
        }
        Graphics2D graphics2D = this.working.createGraphics();
        if ((n = Math.max(0, Math.min(255, n))) > 0) {
            graphics2D.setComposite(this.getComposite(n));
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        }
        if ((n2 = Math.max(0, Math.min(255, n2))) > 0) {
            graphics2D.setComposite(this.getComposite(n2));
            graphics2D.drawImage((Image)this.original, 0, 0, null);
        }
        this.working.getRaster().getDataElements(0, 0, this.wTemplate, this.hTemplate, this.pixels);
        if (this.mask != null) {
            n7 = 0;
            while (n7 < this.pixels.length) {
                n6 = 1;
                n5 = n7 % this.wTemplate;
                n4 = n7 / this.wTemplate;
                n3 = 0;
                while (n3 < 2) {
                    int n11 = 0;
                    while (n11 < 2) {
                        this.p.setLocation(n5 + n3, n4 + n11);
                        n6 = n6 != 0 && this.mask.contains(this.p) ? 1 : 0;
                        ++n11;
                    }
                    ++n3;
                }
                if (n6 == 0) {
                    int cfr_ignored_0 = this.pixels[n7];
                    this.pixels[n7] = 0;
                }
                ++n7;
            }
        }
        this.template.getRaster().setDataElements(0, 0, this.wTemplate, this.hTemplate, this.pixels);
        n7 = 0;
        n6 = 0;
        this.trimTop = 0;
        this.trimLeft = 0;
        n5 = 1;
        while (n5 != 0 && this.trimLeft < this.wTemplate) {
            n4 = 0;
            while (n4 < this.hTemplate) {
                n3 = n4 * this.wTemplate + this.trimLeft;
                n5 = n5 != 0 && TemplateMatcher.getAlpha(this.pixels[n3]) == 0 ? 1 : 0;
                ++n4;
            }
            if (n5 == 0) continue;
            ++this.trimLeft;
        }
        n5 = 1;
        while (n5 != 0 && this.trimLeft + n7 < this.wTemplate) {
            n4 = 0;
            while (n4 < this.hTemplate) {
                n3 = (n4 + 1) * this.wTemplate - 1 - n7;
                n5 = n5 != 0 && TemplateMatcher.getAlpha(this.pixels[n3]) == 0 ? 1 : 0;
                ++n4;
            }
            if (n5 == 0) continue;
            ++n7;
        }
        n5 = 1;
        while (n5 != 0 && this.trimTop < this.hTemplate) {
            n4 = 0;
            while (n4 < this.wTemplate) {
                n3 = this.trimTop * this.wTemplate + n4;
                n5 = n5 != 0 && TemplateMatcher.getAlpha(this.pixels[n3]) == 0 ? 1 : 0;
                ++n4;
            }
            if (n5 == 0) continue;
            ++this.trimTop;
        }
        n5 = 1;
        while (n5 != 0 && this.trimTop + n6 < this.hTemplate) {
            n4 = 0;
            while (n4 < this.wTemplate) {
                n3 = (this.hTemplate - 1 - n6) * this.wTemplate + n4;
                n5 = n5 != 0 && TemplateMatcher.getAlpha(this.pixels[n3]) == 0 ? 1 : 0;
                ++n4;
            }
            if (n5 == 0) continue;
            ++n6;
        }
        if (this.trimLeft + n7 + this.trimTop + n6 > 0) {
            this.wTemplate -= this.trimLeft + n7;
            this.hTemplate -= this.trimTop + n6;
            this.wTemplate = Math.max(this.wTemplate, 1);
            this.hTemplate = Math.max(this.hTemplate, 1);
            n4 = this.wTemplate * this.hTemplate;
            this.pixels = new int[n4];
            this.templateR = new int[n4];
            this.templateG = new int[n4];
            this.templateB = new int[n4];
            this.isPixelTransparent = new boolean[n4];
            this.matchPixels = new int[n4];
            BufferedImage bufferedImage3 = new BufferedImage(this.wTemplate, this.hTemplate, 2);
            bufferedImage3.createGraphics().drawImage((Image)this.template, -this.trimLeft, -this.trimTop, null);
            this.template = bufferedImage3;
            this.template.getRaster().getDataElements(0, 0, this.wTemplate, this.hTemplate, this.pixels);
        }
        return this.template;
    }

    public int[] getAlphas() {
        return this.alphas;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getWorkingPixels(int[] nArray) {
        if (nArray == null || nArray.length != this.wTemplate * this.hTemplate) {
            nArray = new int[this.wTemplate * this.hTemplate];
        }
        this.working.getRaster().getDataElements(0, 0, this.wTemplate, this.hTemplate, nArray);
        return nArray;
    }

    public void setWorkingPixels(int[] nArray) {
        if (nArray != null && nArray.length == this.wTemplate * this.hTemplate) {
            this.working.getRaster().setDataElements(0, 0, this.wTemplate, this.hTemplate, nArray);
        }
    }

    public TPoint getMatchLocation(BufferedImage bufferedImage, Rectangle rectangle) {
        double d;
        int n;
        int n2;
        this.wTarget = bufferedImage.getWidth();
        this.hTarget = bufferedImage.getHeight();
        int n3 = n2 = this.wTemplate / 2;
        if (this.wTemplate % 2 > 0) {
            ++n3;
        }
        int n4 = n = this.hTemplate / 2;
        if (this.hTemplate % 2 > 0) {
            ++n4;
        }
        rectangle.x = Math.max(n2, Math.min(this.wTarget - n3, rectangle.x));
        rectangle.y = Math.max(n, Math.min(this.hTarget - n4, rectangle.y));
        rectangle.width = Math.min(this.wTarget - rectangle.x - n3, rectangle.width);
        rectangle.height = Math.min(this.hTarget - rectangle.y - n4, rectangle.height);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            this.peakHeight = Double.NaN;
            this.peakWidth = Double.NaN;
            return null;
        }
        int n5 = Math.max(0, rectangle.x - n2);
        int n6 = Math.min(this.wTarget, rectangle.x + rectangle.width + n3);
        int n7 = Math.max(0, rectangle.y - n);
        int n8 = Math.min(this.hTarget, rectangle.y + rectangle.height + n4);
        this.wTest = n6 - n5;
        this.hTest = n8 - n7;
        if (bufferedImage.getType() != 1) {
            BufferedImage bufferedImage2 = new BufferedImage(this.wTarget, this.hTarget, 1);
            bufferedImage2.createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        this.targetPixels = new int[this.wTest * this.hTest];
        bufferedImage.getRaster().getDataElements(n5, n7, this.wTest, this.hTest, this.targetPixels);
        double d2 = this.largeNumber;
        int n9 = 0;
        int n10 = 0;
        double d3 = 0.0;
        int n11 = 0;
        while (n11 <= rectangle.width) {
            int n12 = 0;
            while (n12 <= rectangle.height) {
                d = this.getDifferenceAtTestPoint(n11, n12);
                d3 += d;
                if (d < d2) {
                    d2 = d;
                    n9 = n11;
                    n10 = n12;
                }
                ++n12;
            }
            ++n11;
        }
        this.peakHeight = (d3 /= (double)(rectangle.width * rectangle.height)) / d2 - 1.0;
        this.peakWidth = Double.NaN;
        double d4 = 0.0;
        d = 0.0;
        if (!Double.isInfinite(this.peakHeight)) {
            double d5;
            this.xValues[1] = this.yValues[1] = this.peakHeight;
            int n13 = -1;
            while (n13 < 2) {
                if (n13 != 0) {
                    double d6 = this.getDifferenceAtTestPoint(n9 + n13, n10);
                    this.xValues[n13 + 1] = d3 / d6 - 1.0;
                    d6 = this.getDifferenceAtTestPoint(n9, n10 + n13);
                    this.yValues[n13 + 1] = d3 / d6 - 1.0;
                }
                ++n13;
            }
            double d7 = 1.0 / (this.xValues[1] - this.xValues[0]);
            double d8 = 1.0 / (this.xValues[1] - this.xValues[2]);
            if (Double.isNaN(d7)) {
                d7 = 1.0E10;
            }
            if (Double.isNaN(d8)) {
                d8 = 1.0E10;
            }
            double d9 = (d4 = 0.6 * (d8 - d7) / (d8 + d7)) > 0.0 ? this.peakHeight / this.xValues[0] : this.peakHeight / this.xValues[2];
            double d10 = d4 > 0.0 ? d4 + 1.0 : d4 - 1.0;
            d10 = d10 * d10 / Math.log(d9);
            d7 = 1.0 / (this.yValues[1] - this.yValues[0]);
            d8 = 1.0 / (this.yValues[1] - this.yValues[2]);
            if (Double.isNaN(d7)) {
                d7 = 1.0E10;
            }
            if (Double.isNaN(d8)) {
                d8 = 1.0E10;
            }
            d9 = (d = 0.6 * (d8 - d7) / (d8 + d7)) > 0.0 ? this.peakHeight / this.yValues[0] : this.peakHeight / this.yValues[2];
            double d11 = d > 0.0 ? d + 1.0 : d - 1.0;
            d11 = d11 * d11 / Math.log(d9);
            this.dataset.clear();
            this.dataset.append(this.pixelOffsets, this.xValues);
            double d12 = 1.0;
            int n14 = 0;
            while (n14 < 3) {
                d5 = n14 == 0 ? d10 : (n14 == 1 ? d10 / 3.0 : d10 * 3.0);
                this.f.setParameterValue(0, this.peakHeight);
                this.f.setParameterValue(1, d4);
                this.f.setParameterValue(2, d5);
                d12 = this.fitter.fit(this.f);
                if (d12 < 0.01) {
                    d4 = this.f.getParameterValue(1);
                    this.peakWidth = this.f.getParameterValue(2);
                    break;
                }
                ++n14;
            }
            if (!Double.isNaN(this.peakWidth)) {
                this.dataset.clear();
                this.dataset.append(this.pixelOffsets, this.yValues);
                n14 = 0;
                while (n14 < 3) {
                    d5 = n14 == 0 ? d11 : (n14 == 1 ? d11 / 3.0 : d11 * 3.0);
                    this.f.setParameterValue(0, this.peakHeight);
                    this.f.setParameterValue(1, d);
                    this.f.setParameterValue(2, d5);
                    d12 = this.fitter.fit(this.f);
                    if (d12 < 0.01) {
                        d = this.f.getParameterValue(1);
                        this.peakWidth = (this.peakWidth + this.f.getParameterValue(2)) / 2.0;
                        break;
                    }
                    ++n14;
                }
                if (d12 > 0.01) {
                    this.peakWidth = Double.NaN;
                }
            }
        }
        n9 = n9 + rectangle.x - n2 - this.trimLeft;
        n10 = n10 + rectangle.y - n - this.trimTop;
        this.refreshMatchImage(bufferedImage, n9, n10);
        return new TPoint((double)n9 + d4, (double)n10 + d);
    }

    private void refreshMatchImage(BufferedImage bufferedImage, int n, int n2) {
        bufferedImage.getRaster().getDataElements(n + 1, n2 + 1, this.wTemplate, this.hTemplate, this.matchPixels);
        int n3 = 0;
        while (n3 < this.matchPixels.length) {
            this.matchPixels[n3] = TemplateMatcher.getValue(this.isPixelTransparent[n3] ? 0 : 255, this.matchPixels[n3]);
            ++n3;
        }
        if (this.match == null || this.match.getWidth() != this.wTemplate || this.match.getHeight() != this.hTemplate) {
            this.match = new BufferedImage(this.wTemplate, this.hTemplate, 2);
        }
        this.match.getRaster().setDataElements(0, 0, this.wTemplate, this.hTemplate, this.matchPixels);
    }

    public TPoint getMatchLocation(BufferedImage bufferedImage, Rectangle rectangle, double d, double d2, double d3, int n) {
        double d4;
        int n2;
        Object object;
        int n3;
        int n4;
        this.wTarget = bufferedImage.getWidth();
        this.hTarget = bufferedImage.getHeight();
        int n5 = n4 = this.wTemplate / 2;
        if (this.wTemplate % 2 > 0) {
            ++n5;
        }
        int n6 = n3 = this.hTemplate / 2;
        if (this.hTemplate % 2 > 0) {
            ++n6;
        }
        rectangle.x = Math.max(n4, Math.min(this.wTarget - n5, rectangle.x));
        rectangle.y = Math.max(n3, Math.min(this.hTarget - n6, rectangle.y));
        rectangle.width = Math.min(this.wTarget - rectangle.x - n5, rectangle.width);
        rectangle.height = Math.min(this.hTarget - rectangle.y - n6, rectangle.height);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            this.peakHeight = Double.NaN;
            this.peakWidth = Double.NaN;
            return null;
        }
        int n7 = Math.max(0, rectangle.x - n4);
        int n8 = Math.min(this.wTarget, rectangle.x + rectangle.width + n5);
        int n9 = Math.max(0, rectangle.y - n3);
        int n10 = Math.min(this.hTarget, rectangle.y + rectangle.height + n6);
        this.wTest = n8 - n7;
        this.hTest = n10 - n9;
        if (bufferedImage.getType() != 1) {
            object = new BufferedImage(this.wTarget, this.hTarget, 1);
            ((BufferedImage)object).createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = object;
        }
        this.targetPixels = new int[this.wTest * this.hTest];
        bufferedImage.getRaster().getDataElements(n7, n9, this.wTest, this.hTest, this.targetPixels);
        object = this.getSearchPoints(rectangle, d, d2, d3);
        if (object == null) {
            this.peakHeight = Double.NaN;
            this.peakWidth = -1.0;
            return null;
        }
        HashMap<Point2D, Double> hashMap = new HashMap<Point2D, Double>();
        double d5 = this.largeNumber;
        int n11 = 0;
        int n12 = 0;
        double d6 = 0.0;
        Point2D point2D = null;
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            Point2D point2D2 = (Point2D)iterator.next();
            n2 = (int)point2D2.getX();
            int n13 = (int)point2D2.getY();
            d4 = this.getDifferenceAtTestPoint(n2, n13);
            hashMap.put(point2D2, d4);
            d6 += d4;
            if (!(d4 < d5)) continue;
            d5 = d4;
            n11 = n2;
            n12 = n13;
            point2D = point2D2;
        }
        this.peakHeight = (d6 /= (double)((ArrayList)object).size()) / d5 - 1.0;
        this.peakWidth = Double.NaN;
        double d7 = 0.0;
        n2 = ((ArrayList)object).indexOf(point2D);
        if (!Double.isInfinite(this.peakHeight) && n2 > 0 && n2 < ((ArrayList)object).size() - 1) {
            Point2D point2D3 = (Point2D)((ArrayList)object).get(n2 - 1);
            d4 = (Double)hashMap.get(point2D3);
            this.xValues[0] = -point2D3.distance(point2D);
            this.yValues[0] = d6 / d4 - 1.0;
            this.xValues[1] = 0.0;
            this.yValues[1] = this.peakHeight;
            point2D3 = (Point2D)((ArrayList)object).get(n2 + 1);
            d4 = (Double)hashMap.get(point2D3);
            this.xValues[2] = point2D3.distance(point2D);
            this.yValues[2] = d6 / d4 - 1.0;
            double d8 = -this.xValues[0] / (this.yValues[1] - this.yValues[0]);
            double d9 = this.xValues[2] / (this.yValues[1] - this.yValues[2]);
            if (Double.isNaN(d8)) {
                d8 = 1.0E10;
            }
            if (Double.isNaN(d9)) {
                d9 = 1.0E10;
            }
            double d10 = (d7 = 0.3 * (this.xValues[2] - this.xValues[0]) * (d9 - d8) / (d9 + d8)) > 0.0 ? this.peakHeight / this.yValues[0] : this.peakHeight / this.yValues[2];
            double d11 = d7 > 0.0 ? d7 - this.xValues[0] : d7 - this.xValues[2];
            d11 = d11 * d11 / Math.log(d10);
            this.dataset.clear();
            this.dataset.append(this.xValues, this.yValues);
            double d12 = 1.0;
            int n14 = 0;
            while (n14 < 3) {
                double d13 = n14 == 0 ? d11 : (n14 == 1 ? d11 / 3.0 : d11 * 3.0);
                this.f.setParameterValue(0, this.peakHeight);
                this.f.setParameterValue(1, d7);
                this.f.setParameterValue(2, d13);
                d12 = this.fitter.fit(this.f);
                if (d12 < 0.01) {
                    d7 = this.f.getParameterValue(1);
                    this.peakWidth = this.f.getParameterValue(2);
                    break;
                }
                ++n14;
            }
        }
        double d14 = d7 * Math.cos(d3);
        double d15 = d7 * Math.sin(d3);
        n11 = n11 + rectangle.x - n4 - this.trimLeft;
        n12 = n12 + rectangle.y - n3 - this.trimTop;
        this.refreshMatchImage(bufferedImage, n11, n12);
        return new TPoint((double)n11 + d14, (double)n12 + d15);
    }

    public BufferedImage getMatchImage() {
        return this.match;
    }

    public double[] getMatchWidthAndHeight() {
        return new double[]{this.peakWidth, this.peakHeight};
    }

    public static int getValue(int n, int n2) {
        int n3 = TemplateMatcher.getRed(n2);
        int n4 = TemplateMatcher.getGreen(n2);
        int n5 = TemplateMatcher.getBlue(n2);
        return TemplateMatcher.getValue(n, n3, n4, n5);
    }

    public static int getValue(int n, int n2, int n3, int n4) {
        int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        return n5;
    }

    public static int getAlpha(int n) {
        int n2 = n >> 24 & 0xFF;
        return n2;
    }

    public static int getRed(int n) {
        int n2 = n >> 16 & 0xFF;
        return n2;
    }

    public static int getGreen(int n) {
        int n2 = n >> 8 & 0xFF;
        return n2;
    }

    public static int getBlue(int n) {
        int n2 = n & 0xFF;
        return n2;
    }

    public ArrayList<Point2D> getSearchPoints(Rectangle rectangle, double d, double d2, double d3) {
        double d4 = -Math.tan(d3);
        Line2D.Double double_ = new Line2D.Double();
        if (Math.abs(d4) > 1.0E10) {
            ((Line2D)double_).setLine(d, d2, d, d2 + 1.0);
        } else if (Math.abs(d4) < 1.0E-10) {
            ((Line2D)double_).setLine(d, d2, d + 1.0, d2);
        } else {
            ((Line2D)double_).setLine(d, d2, d + 1.0, d2 + d4);
        }
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double(Double.NaN, Double.NaN);
        Point2D point2D = double_2;
        boolean bl = false;
        double d5 = rectangle.x;
        Object[] objectArray = this.getDistanceAndPointAtX(double_, d5);
        if (objectArray != null) {
            point2D.setLocation((Point2D)objectArray[1]);
            if (point2D.getY() >= (double)rectangle.y && point2D.getY() <= (double)(rectangle.y + rectangle.height)) {
                point2D = double_3;
            }
        }
        if ((objectArray = this.getDistanceAndPointAtX(double_, d5 += (double)rectangle.width)) != null) {
            point2D.setLocation((Point2D)objectArray[1]);
            if (point2D.getY() >= (double)rectangle.y && point2D.getY() <= (double)(rectangle.y + rectangle.height)) {
                if (point2D == double_2) {
                    point2D = double_3;
                } else {
                    bl = true;
                }
            }
        }
        if (!bl && (objectArray = this.getDistanceAndPointAtY(double_, d5 = (double)rectangle.y)) != null) {
            point2D.setLocation((Point2D)objectArray[1]);
            if (point2D.getX() >= (double)rectangle.x && point2D.getX() <= (double)(rectangle.x + rectangle.width)) {
                if (point2D == double_2) {
                    point2D = double_3;
                } else if (!double_2.equals(double_3)) {
                    bl = true;
                }
            }
        }
        if (!bl && (objectArray = this.getDistanceAndPointAtY(double_, d5 += (double)rectangle.height)) != null) {
            point2D.setLocation((Point2D)objectArray[1]);
            if (point2D.getX() >= (double)rectangle.x && point2D.getX() <= (double)(rectangle.x + rectangle.width) && point2D == double_3 && !double_2.equals(double_3)) {
                bl = true;
            }
        }
        if (bl) {
            Object object2;
            double_.setLine(double_2, double_3);
            if (((Point2D)double_2).getX() > ((Point2D)double_3).getX()) {
                double_.setLine(double_3, double_2);
            }
            int n = (int)Math.ceil(Math.min(((Point2D)double_2).getX(), ((Point2D)double_3).getX()));
            int n2 = (int)Math.floor(Math.max(((Point2D)double_2).getX(), ((Point2D)double_3).getX()));
            int n3 = (int)Math.ceil(Math.min(((Point2D)double_2).getY(), ((Point2D)double_3).getY()));
            int n4 = (int)Math.floor(Math.max(((Point2D)double_2).getY(), ((Point2D)double_3).getY()));
            TreeMap<Double, Point2D> treeMap = new TreeMap<Double, Point2D>();
            int n5 = n;
            while (n5 <= n2) {
                object2 = this.getDistanceAndPointAtX(double_, n5);
                if (object2 != null) {
                    treeMap.put((Double)object2[0], (Point2D)object2[1]);
                }
                ++n5;
            }
            n5 = n3;
            while (n5 <= n4) {
                object2 = this.getDistanceAndPointAtY(double_, n5);
                if (object2 != null) {
                    treeMap.put((Double)object2[0], (Point2D)object2[1]);
                }
                ++n5;
            }
            point2D = null;
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            for (Object object2 : treeMap.keySet()) {
                Point2D point2D2 = (Point2D)treeMap.get(object2);
                if (point2D != null) {
                    double d6 = (point2D.getX() + point2D2.getX()) / 2.0 - (double)rectangle.x;
                    double d7 = (point2D.getY() + point2D2.getY()) / 2.0 - (double)rectangle.y;
                    point2D.setLocation(d6, d7);
                    arrayList.add(point2D);
                }
                point2D = point2D2;
            }
            return arrayList;
        }
        return null;
    }

    private Object[] getDistanceAndPointAtX(Line2D line2D, double d) {
        double d2 = line2D.getX2() - line2D.getX1();
        if (d2 == 0.0) {
            return null;
        }
        double d3 = (d - line2D.getX1()) / d2;
        double d4 = line2D.getY1() + d3 * (line2D.getY2() - line2D.getY1());
        return new Object[]{d3, new Point2D.Double(d, d4)};
    }

    private Object[] getDistanceAndPointAtY(Line2D line2D, double d) {
        double d2 = line2D.getY2() - line2D.getY1();
        if (d2 == 0.0) {
            return null;
        }
        double d3 = (d - line2D.getY1()) / d2;
        double d4 = line2D.getX1() + d3 * (line2D.getX2() - line2D.getX1());
        return new Object[]{d3, new Point2D.Double(d4, d)};
    }

    private double getDifferenceAtTestPoint(int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.wTemplate) {
            int n4 = 0;
            while (n4 < this.hTemplate) {
                int n5 = n4 * this.wTemplate + n3;
                int n6 = (n2 + n4) * this.wTest + n + n3;
                if (n6 < 0 || n6 >= this.targetPixels.length) {
                    return Double.NaN;
                }
                if (!this.isPixelTransparent[n5]) {
                    int n7 = this.targetPixels[n6];
                    d += this.getRGBDifference(n7, this.templateR[n5], this.templateG[n5], this.templateB[n5]);
                }
                ++n4;
            }
            ++n3;
        }
        return d;
    }

    private double getRGBDifference(int n, int n2, int n3, int n4) {
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        int n8 = n2 - n5;
        int n9 = n3 - n6;
        int n10 = n4 - n7;
        return n8 * n8 + n9 * n9 + n10 * n10;
    }

    private AlphaComposite getComposite(int n) {
        float f = 1.0f * (float)n / 255.0f;
        return AlphaComposite.getInstance(3, f);
    }
}

