/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Circle;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoPanel;

public class TrackableCircle
extends Circle
implements Trackable {
    protected int n;

    public TrackableCircle(int n, double d, double d2) {
        super(d, d2);
        this.n = n;
        this.color = Color.green;
    }

    public int getFrameNumber() {
        return this.n;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!(drawingPanel instanceof VideoPanel)) {
            return;
        }
        VideoPanel videoPanel = (VideoPanel)drawingPanel;
        double d = this.getX();
        double d2 = this.getY();
        if (!videoPanel.isDrawingInImageSpace()) {
            d = videoPanel.getCoords().imageToWorldX(this.n, this.getX(), this.getY());
            d2 = videoPanel.getCoords().imageToWorldY(this.n, this.getX(), this.getY());
        }
        int n = drawingPanel.xToPix(d) - this.pixRadius;
        int n2 = drawingPanel.yToPix(d2) - this.pixRadius;
        graphics.setColor(this.color);
        graphics.fillOval(n, n2, 2 * this.pixRadius, 2 * this.pixRadius);
    }
}

