/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFrame;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifVideoRecorder;
import org.opensourcephysics.tools.VideoCaptureTool;

public class VideoGrabber
extends VideoCaptureTool {
    public static VideoGrabber VIDEO_CAPTURE_TOOL = null;
    static Dimension defaultSize = new Dimension(320, 240);
    BufferedImage scratch;
    VideoRecorder recorder;
    VideoType videoType;
    VideoPanel recorderPanel;
    VideoPanel playerPanel;
    String playerFileName;
    JFrame recorderFrame;
    JFrame playerFrame;
    Action clearAction;
    Action saveAsAction;
    Action recordAction;
    Action vidTypeAction;
    Action fpsAction;
    JButton clearButton;
    JButton saveAsButton;
    JCheckBox recordCheckBox;
    JCheckBox loopCheckBox;
    JComboBox vidTypeDropDown;
    JLabel fpsLabel;
    JComboBox fpsDropDown;
    boolean recording = true;
    boolean saved = false;
    int frameCount = 0;
    Dimension imageSize;
    int[] pixels = new int[1];
    Map<String, VideoType> vidTypes = new HashMap<String, VideoType>();
    boolean previewAll = false;

    static {
        try {
            String string = "org.opensourcephysics.media.xuggle.XuggleIO";
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("registerWithVideoIO", new Class[0]);
            method.invoke(null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
    }

    public VideoGrabber() {
        this(defaultSize);
    }

    public VideoGrabber(Dimension dimension) {
        super(false);
        this.imageSize = dimension;
        this.createGUI();
        this.vidTypeAction.actionPerformed(null);
        this.setRecording(false);
    }

    public static VideoGrabber getTool() {
        if (VIDEO_CAPTURE_TOOL == null) {
            VIDEO_CAPTURE_TOOL = new VideoGrabber();
        }
        return VIDEO_CAPTURE_TOOL;
    }

    public static VideoGrabber getTool(Dimension dimension) {
        if (VIDEO_CAPTURE_TOOL == null) {
            VIDEO_CAPTURE_TOOL = new VideoGrabber(dimension);
        } else {
            VideoGrabber.VIDEO_CAPTURE_TOOL.imageSize = dimension;
            VideoGrabber.VIDEO_CAPTURE_TOOL.recorderPanel.setPreferredSize(dimension);
            VideoGrabber.VIDEO_CAPTURE_TOOL.recorderFrame.pack();
        }
        return VIDEO_CAPTURE_TOOL;
    }

    public void clear() {
        this.clearAction.actionPerformed(null);
    }

    public boolean addFrame(BufferedImage bufferedImage) {
        if (this.isRecording()) {
            try {
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                int n3 = n % 16;
                int n4 = n2 % 16;
                if (n3 != 0 || n4 != 0) {
                    bufferedImage = bufferedImage.getSubimage(n3 / 2, n4 / 2, n - n3, n2 - n4);
                    n = bufferedImage.getWidth();
                    n2 = bufferedImage.getHeight();
                }
                if (this.pixels.length != n * n2) {
                    this.pixels = new int[n * n2];
                }
                boolean bl = false;
                if (this.previewAll) {
                    this.scratch = null;
                } else if (this.scratch == null || this.scratch.getWidth() != n || this.scratch.getHeight() != n2) {
                    this.scratch = new BufferedImage(n, n2, 1);
                    bl = true;
                }
                BufferedImage bufferedImage2 = this.previewAll ? new BufferedImage(n, n2, 1) : this.scratch;
                bufferedImage.getRaster().getDataElements(0, 0, n, n2, this.pixels);
                bufferedImage2.getRaster().setDataElements(0, 0, n, n2, this.pixels);
                Video video = this.recorderPanel.getVideo();
                if (video == null) {
                    this.recorderPanel.setVideo(new ImageVideo(bufferedImage2));
                    this.recorderPanel.getPlayer().setReadoutTypes("frame", null);
                    if (this.recorder instanceof GifVideoRecorder) {
                        int n5 = this.loopCheckBox.isSelected() ? 0 : 1;
                        ((GifVideoRecorder)this.recorder).getGifEncoder().setRepeat(n5);
                    }
                } else if (this.previewAll) {
                    ImageVideo imageVideo = (ImageVideo)video;
                    imageVideo.insert(new Image[]{bufferedImage2}, imageVideo.getFrameCount(), null);
                } else if (bl) {
                    this.recorderPanel.setVideo(new ImageVideo(bufferedImage2));
                    this.recorderPanel.getPlayer().setReadoutTypes("frame", null);
                }
                this.recorder.addFrame(bufferedImage2);
                ++this.frameCount;
                String string = (String)this.fpsDropDown.getSelectedItem();
                double d = 1000.0 / Double.parseDouble(string);
                this.recorderPanel.getPlayer().getClipControl().setFrameDuration(d);
                this.recorderPanel.getPlayer().getVideoClip().setStepCount(this.frameCount);
                this.recorderPanel.getPlayer().setStepNumber(this.frameCount - 1);
                if (video == null) {
                    this.imageSize = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                    final Dimension dimension = new Dimension(bufferedImage.getWidth() + 4, bufferedImage.getHeight() + 4);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            VideoGrabber.this.recorderPanel.setPreferredSize(dimension);
                            VideoGrabber.this.recorderFrame.pack();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    this.refreshGUI();
                }
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public void setVisible(boolean bl) {
        this.recorderFrame.setVisible(bl);
    }

    public boolean isVisible() {
        return this.recorderFrame.isVisible();
    }

    public void setRecording(boolean bl) {
        this.recording = bl;
        this.refreshGUI();
    }

    public boolean isRecording() {
        return this.recording && this.recorder != null;
    }

    public void setVideoType(VideoType videoType) {
        if (videoType == null || videoType == this.videoType) {
            return;
        }
        this.videoType = videoType;
        this.recorder = videoType.getRecorder();
        this.clearAction.actionPerformed(null);
    }

    public void setFrameRate(double d) {
        d = Math.max(d, 1.0);
        d = Math.min(d, 60.0);
        d = Math.round(100.0 * d) / 100L;
        int n = this.fpsDropDown.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.fpsDropDown.getItemAt(n2);
            double d2 = Double.parseDouble(string);
            if (d == d2) {
                this.fpsDropDown.setSelectedIndex(n2);
                return;
            }
            if (d > d2) {
                String string2 = String.valueOf(d);
                this.fpsDropDown.insertItemAt(string2, n2);
                this.fpsDropDown.setSelectedItem(string2);
                return;
            }
            ++n2;
        }
    }

    public String saveVideoAs() {
        if (this.recorder != null) {
            try {
                return this.recorder.saveVideoAs();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException.getMessage(), "File Not Saved", 2);
            }
        }
        return null;
    }

    public VideoRecorder getRecorder() {
        return this.recorder;
    }

    protected void createGUI() {
        Object object;
        Object object2;
        this.createActions();
        this.clearButton = new JButton(this.clearAction);
        this.saveAsButton = new JButton(this.saveAsAction);
        this.recordCheckBox = new JCheckBox(this.recordAction);
        this.recordCheckBox.setOpaque(false);
        this.loopCheckBox = new JCheckBox();
        this.loopCheckBox.setOpaque(false);
        this.fpsLabel = new JLabel();
        Object[] objectArray = new String[]{"30", "29.97", "25", "20", "15", "12", "10", "8", "6", "5", "4", "3", "2", "1"};
        this.fpsDropDown = new JComboBox(objectArray){

            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        this.fpsDropDown.addActionListener(this.fpsAction);
        this.vidTypeDropDown = new JComboBox(){

            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        Object object3 = VideoIO.getVideoTypes();
        int n = ((VideoType[])object3).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object3[n2];
            if (object2.canRecord()) {
                object = object2.getDescription();
                this.vidTypes.put((String)object, (VideoType)object2);
                this.vidTypeDropDown.addItem(object);
            }
            ++n2;
        }
        this.vidTypeDropDown.addActionListener(this.vidTypeAction);
        this.recorderFrame = new JFrame();
        this.recorderFrame.setDefaultCloseOperation(1);
        this.recorderFrame.setName("VideoCaptureTool");
        this.recorderFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (VideoGrabber.this.recorder instanceof ScratchVideoRecorder) {
                    ScratchVideoRecorder scratchVideoRecorder = (ScratchVideoRecorder)VideoGrabber.this.recorder;
                    if (scratchVideoRecorder.scratchFile != null) {
                        try {
                            scratchVideoRecorder.saveScratch();
                            scratchVideoRecorder.scratchFile.delete();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
        object2 = new JPanel(new BorderLayout());
        this.recorderFrame.setContentPane((Container)object2);
        this.recorderPanel = new FixedSizeVideoPanel();
        this.recorderPanel.setPreferredSize(this.imageSize);
        JPanel jPanel = new JPanel(new BorderLayout());
        ((Container)object2).add((Component)jPanel, "South");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.recorderPanel.getPlayer().setBorder(null);
        this.recorderPanel.setPlayerVisible(false);
        this.recorderPanel.getPlayer().setLoopingButtonVisible(false);
        ((Container)object2).add((Component)this.recorderPanel, "Center");
        object3 = new JToolBar();
        ((JToolBar)object3).setFloatable(false);
        if (this.previewAll) {
            jToolBar.add(this.recorderPanel.getPlayer());
            jPanel.add((Component)jToolBar, "Center");
        } else {
            ((Container)object3).add(this.recorderPanel.getPlayer().readout);
        }
        jPanel.add((Component)object3, "South");
        ((Container)object3).add(this.recordCheckBox);
        ((Container)object3).add(Box.createHorizontalGlue());
        ((Container)object3).add(this.clearButton);
        ((Container)object3).add(this.saveAsButton);
        object = new JToolBar();
        ((JToolBar)object).setFloatable(false);
        ((Container)object2).add((Component)object, "North");
        ((Container)object).add(this.vidTypeDropDown);
        ((JToolBar)object).addSeparator();
        ((Container)object).add(this.fpsLabel);
        ((Container)object).add(this.fpsDropDown);
        ((JToolBar)object).addSeparator();
        ((Container)object).add(this.loopCheckBox);
        ((Container)object).add(Box.createHorizontalGlue());
        this.recorderFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (dimension.width - this.recorderFrame.getBounds().width) / 2;
        this.recorderFrame.setLocation(n3, 0);
    }

    protected void createActions() {
        this.clearAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoGrabber.this.recorderPanel.setVideo(null);
                VideoGrabber.this.recorderPanel.getPlayer().getVideoClip().setStepCount(1);
                if (VideoGrabber.this.recorder != null) {
                    String string = (String)VideoGrabber.this.fpsDropDown.getSelectedItem();
                    double d = 1000.0 / Double.parseDouble(string);
                    VideoGrabber.this.recorder.setFrameDuration(d);
                    try {
                        VideoGrabber.this.recorder.createVideo();
                        VideoGrabber.this.frameCount = 0;
                        VideoGrabber.this.saved = false;
                        VideoGrabber.this.recorderPanel.setVideo(null);
                        VideoGrabber.this.recorderPanel.getPlayer().setReadoutTypes("frame", null);
                        VideoGrabber.this.recorderPanel.getPlayer().getVideoClip().setStepCount(1);
                        VideoGrabber.this.refreshGUI();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                System.gc();
            }
        };
        this.saveAsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VideoGrabber.this.recorder != null) {
                    try {
                        String string = VideoGrabber.this.recorder.saveVideoAs();
                        if (string != null) {
                            Video video = VideoGrabber.this.videoType.getVideo(string);
                            if (VideoGrabber.this.playerPanel == null) {
                                VideoGrabber.this.playerPanel = new FixedSizeVideoPanel();
                                VideoGrabber.this.playerFrame = new VideoFrame(VideoGrabber.this.playerPanel);
                                int n = VideoGrabber.this.imageSize.width + 4;
                                int n2 = VideoGrabber.this.imageSize.height + VideoGrabber.this.recorderPanel.getPlayer().height + 4;
                                VideoGrabber.this.playerPanel.setPreferredSize(new Dimension(n, n2));
                                VideoGrabber.this.playerFrame.pack();
                            }
                            VideoGrabber.this.playerPanel.setVideo(video);
                            if (VideoGrabber.this.loopCheckBox.isVisible() && VideoGrabber.this.loopCheckBox.isSelected()) {
                                VideoGrabber.this.playerPanel.getPlayer().setLooping(true);
                                VideoGrabber.this.playerPanel.getPlayer().play();
                            }
                            VideoGrabber.this.playerFrame.setVisible(true);
                            VideoGrabber.this.saved = true;
                            VideoGrabber.this.playerFileName = string;
                            VideoGrabber.this.clearAction.actionPerformed(null);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        this.recordAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoGrabber.this.recording = !VideoGrabber.this.recording;
                VideoGrabber.this.refreshGUI();
            }
        };
        this.vidTypeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = VideoGrabber.this.vidTypeDropDown.getSelectedItem();
                VideoType videoType = VideoGrabber.this.vidTypes.get(object);
                if (videoType != null) {
                    VideoGrabber.this.setVideoType(videoType);
                }
            }
        };
        this.fpsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoGrabber.this.clearAction.actionPerformed(null);
            }
        };
    }

    protected void refreshGUI() {
        this.recordCheckBox.setSelected(this.isRecording());
        this.clearButton.setEnabled(this.frameCount != 0);
        this.saveAsButton.setEnabled(this.frameCount != 0);
        this.vidTypeDropDown.setEnabled(this.frameCount == 0);
        this.vidTypeDropDown.setSelectedItem(this.videoType.getDescription());
        this.fpsDropDown.setEnabled(this.frameCount == 0);
        this.fpsDropDown.setVisible(!(this.videoType instanceof ImageVideoType));
        this.fpsLabel.setVisible(!(this.videoType instanceof ImageVideoType));
        this.loopCheckBox.setEnabled(this.frameCount == 0);
        this.recorderPanel.getPlayer().readout.setEnabled(this.frameCount != 0);
        this.recordCheckBox.setText(MediaRes.getString("VideoGrabber.Action.Capture"));
        this.loopCheckBox.setText(MediaRes.getString("VideoGrabber.Action.Loop"));
        this.loopCheckBox.setVisible(this.videoType.getClass().getSimpleName().equals("GifVideoType"));
        this.fpsLabel.setText(String.valueOf(MediaRes.getString("VideoGrabber.Label.PlayRate")) + " ");
        this.clearButton.setText(MediaRes.getString("VideoGrabber.Action.Clear"));
        this.saveAsButton.setText(MediaRes.getString("VideoGrabber.Action.SaveAs"));
        if (this.recordCheckBox.isSelected()) {
            this.recorderFrame.setTitle(String.valueOf(MediaRes.getString("VideoGrabber.Title.Capturing")) + this.videoType.getDescription());
        } else {
            this.recorderFrame.setTitle(this.videoType.getDescription());
        }
        if (this.playerFrame != null && this.playerFrame.isVisible()) {
            this.playerFrame.setTitle(String.valueOf(MediaRes.getString("VideoGrabber.Title.Saved")) + XML.getName(this.playerFileName));
        }
    }

    public static /* bridge */ /* synthetic */ VideoCaptureTool getTool() {
        return VideoGrabber.getTool();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FixedSizeVideoPanel
    extends VideoPanel {
        FixedSizeVideoPanel() {
            this.setBackground(Color.black);
            this.setDrawingInImageSpace(true);
            this.setShowCoordinates(false);
        }

        @Override
        protected void scale(ArrayList<Drawable> arrayList) {
            double d = this.imageWidth;
            double d2 = ((double)this.getWidth() - d - 1.0) * 0.5 / d;
            double d3 = this.imageHeight;
            double d4 = ((double)this.getHeight() - d3 - 1.0) * 0.5 / d3;
            double d5 = Math.min(d2, d4);
            super.setImageBorder(d5);
            super.scale(arrayList);
        }
    }
}

