/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoPlayer
extends JComponent
implements PropertyChangeListener {
    protected static Icon inOutIcon;
    protected static Icon playIcon;
    protected static Icon grayPlayIcon;
    protected static Icon pauseIcon;
    protected static Icon resetIcon;
    protected static Icon loopIcon;
    protected static Icon noloopIcon;
    protected static Icon videoClipIcon;
    protected static Icon stepIcon;
    protected static Icon grayStepIcon;
    protected static Icon backIcon;
    protected static Icon grayBackIcon;
    protected VideoPanel vidPanel;
    protected ClipControl clipControl;
    private String[] readoutTypes;
    private String readoutType;
    private boolean inspectorButtonVisible = true;
    protected int height = 54;
    private JToolBar toolbar;
    protected JButton readout;
    private JButton playButton;
    private JButton resetButton;
    private JSpinner rateSpinner;
    private JButton stepButton;
    private JButton stepSizeButton;
    private JButton backButton;
    private JButton loopButton;
    private JButton inspectorButton;
    private JSlider slider;
    private Hashtable<Integer, JLabel> sliderLabels;
    private JLabel inLabel;
    private JLabel outLabel;
    private NumberFormat timeFormat = NumberFormat.getNumberInstance();
    private ActionListener readoutListener;
    private ActionListener timeSetListener;
    private String active;
    private boolean disabled = false;

    static {
        String string = "/org/opensourcephysics/resources/media/images/in_out.gif";
        inOutIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/play.gif";
        playIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/play_gray.gif";
        grayPlayIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/pause.gif";
        pauseIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/reset.gif";
        resetIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/looping_on.gif";
        loopIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/looping_off.gif";
        noloopIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/video_clip.gif";
        videoClipIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/step.gif";
        stepIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/step_gray.gif";
        grayStepIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/back.gif";
        backIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/back_gray.gif";
        grayBackIcon = ResourceLoader.getIcon(string);
    }

    public VideoPlayer(VideoPanel videoPanel, VideoClip videoClip) {
        this(videoPanel);
        this.setVideoClip(videoClip);
    }

    public VideoPlayer(VideoPanel videoPanel) {
        this.vidPanel = videoPanel;
        this.vidPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (VideoPlayer.this.vidPanel.isPlayerVisible()) {
                    VideoPlayer.this.setBounds();
                    VideoPlayer.this.vidPanel.repaint();
                }
            }
        });
        this.createGUI();
        this.timeFormat.setMinimumIntegerDigits(1);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumFractionDigits(3);
        this.clipControl = ClipControl.getControl(new VideoClip(null));
        this.clipControl.addPropertyChangeListener(this);
        this.getVideoClip().addPropertyChangeListener(this);
        this.updatePlayButtons(false);
        this.updateSlider();
        this.setReadoutTypes("frame time step", "frame");
        this.refresh();
    }

    public void setVideoClip(VideoClip videoClip) {
        boolean bl = this.clipControl.isPlaying();
        this.stop();
        if (this.getVideoClip() == videoClip) {
            ClipInspector clipInspector;
            boolean bl2 = this.clipControl.isLooping();
            double d = this.clipControl.getRate();
            double d2 = this.clipControl.getMeanFrameDuration();
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(videoClip);
            this.clipControl.addPropertyChangeListener(this);
            this.clipControl.setLooping(bl2);
            this.clipControl.setRate(d);
            this.clipControl.setFrameDuration(d2);
            if (bl) {
                this.clipControl.play();
            }
            if ((clipInspector = this.getVideoClip().inspector) != null) {
                clipInspector.clipControl = this.clipControl;
            }
        } else {
            VideoClip videoClip2 = this.getVideoClip();
            videoClip2.removePropertyChangeListener(this);
            videoClip2.hideClipInspector();
            Video video = videoClip2.getVideo();
            if (video != null) {
                video.dispose();
            }
            videoClip2.video = null;
            if (videoClip == null) {
                videoClip = new VideoClip(null);
            }
            videoClip.addPropertyChangeListener(this);
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(videoClip);
            this.clipControl.addPropertyChangeListener(this);
            this.setReadoutTypes("frame time step", videoClip.readoutType);
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.updateLoopButton(this.clipControl.isLooping());
            this.updateReadout();
            this.updateSlider();
            this.firePropertyChange("videoclip", videoClip2, videoClip);
            System.gc();
        }
    }

    public VideoClip getVideoClip() {
        return this.clipControl.getVideoClip();
    }

    public ClipControl getClipControl() {
        return this.clipControl;
    }

    public void setReadoutTypes(String string, String string2) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        String string3 = string.toLowerCase();
        int n = string3.indexOf("time");
        if (n >= 0) {
            treeMap.put(new Integer(n), "time");
        }
        if ((n = string3.indexOf("step")) >= 0) {
            treeMap.put(new Integer(n), "step");
        }
        if ((n = string3.indexOf("frame")) >= 0) {
            treeMap.put(new Integer(n), "frame");
        }
        if (treeMap.isEmpty()) {
            return;
        }
        this.readoutTypes = treeMap.values().toArray(new String[0]);
        if (string2 == null) {
            string2 = this.readoutTypes[0];
        }
        this.setReadoutType(string2);
    }

    public void setReadoutType(String string) {
        String string2 = string.toLowerCase();
        String string3 = " " + MediaRes.getString("VideoPlayer.Readout.ToolTip");
        if (string2.indexOf("time") >= 0) {
            this.readoutType = "time";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Time")) + string3);
        } else if (string2.indexOf("step") >= 0) {
            this.readoutType = "step";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Step")) + string3);
        } else if (string2.indexOf("frame") >= 0) {
            this.readoutType = "frame";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Frame")) + string3);
        }
        boolean bl = false;
        int n = 0;
        while (n < this.readoutTypes.length) {
            bl = bl || this.readoutTypes[n].equals(this.readoutType);
            ++n;
        }
        if (!bl) {
            String[] stringArray = new String[this.readoutTypes.length + 1];
            stringArray[0] = this.readoutType;
            int n2 = 0;
            while (n2 < this.readoutTypes.length) {
                stringArray[n2 + 1] = this.readoutTypes[n2];
                ++n2;
            }
            this.readoutTypes = stringArray;
        }
        this.getVideoClip().readoutType = this.readoutType;
        this.updateReadout();
    }

    public void play() {
        this.clipControl.play();
    }

    public void stop() {
        this.clipControl.stop();
    }

    public void step() {
        this.stop();
        this.clipControl.step();
    }

    public void back() {
        this.stop();
        this.clipControl.back();
    }

    public void setRate(double d) {
        this.clipControl.setRate(d);
    }

    public double getRate() {
        return this.clipControl.getRate();
    }

    public void setLooping(boolean bl) {
        this.clipControl.setLooping(bl);
    }

    public boolean isLooping() {
        return this.clipControl.isLooping();
    }

    public void setStepNumber(int n) {
        this.clipControl.setStepNumber(n);
    }

    public int getStepNumber() {
        return this.clipControl.getStepNumber();
    }

    public int getFrameNumber() {
        return this.clipControl.getFrameNumber();
    }

    public double getTime() {
        return this.clipControl.getTime() + this.clipControl.clip.getStartTime();
    }

    public double getStepTime(int n) {
        if (n < 0 || n >= this.clipControl.clip.getStepCount()) {
            return Double.NaN;
        }
        return this.clipControl.getStepTime(n) + this.clipControl.clip.getStartTime();
    }

    public double getFrameTime(int n) {
        return this.clipControl.clip.getStartTime() + (double)(n - this.clipControl.clip.getStartFrameNumber()) * this.clipControl.getMeanFrameDuration();
    }

    public double getMeanStepDuration() {
        double d = this.getClipControl().getMeanFrameDuration() * (double)this.getVideoClip().getStepSize();
        return d;
    }

    public void setInspectorButtonVisible(final boolean bl) {
        if (bl == this.inspectorButtonVisible) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                VideoPlayer.this.inspectorButtonVisible = bl;
                if (bl) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.inspectorButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.inspectorButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void setLoopingButtonVisible(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.loopButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.loopButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepnumber")) {
            this.updateReadout();
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.firePropertyChange("stepnumber", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("frameduration")) {
            this.updateReadout();
            this.firePropertyChange("frameduration", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("playing")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.updatePlayButtons(bl);
            this.firePropertyChange("playing", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("looping")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.updateLoopButton(bl);
        } else if (string.equals("rate")) {
            this.rateSpinner.setValue(new Double(this.getRate()));
        } else if (string.equals("stepcount")) {
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.updateReadout();
            this.updateSlider();
        } else if (string.equals("framecount")) {
            this.updateSlider();
        } else if (string.equals("stepsize")) {
            this.updateReadout();
            this.updateSlider();
        } else if (string.equals("startframe")) {
            this.updateReadout();
            this.updateSlider();
        } else if (string.equals("starttime")) {
            this.updateReadout();
        }
    }

    public void refresh() {
        this.stepButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepForward.ToolTip"));
        this.backButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepBack.ToolTip"));
        this.resetButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Reset.ToolTip"));
        this.inspectorButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
        this.loopButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Looping.ToolTip"));
        this.setReadoutType(this.readoutType);
        this.updatePlayButtons(this.clipControl.isPlaying());
        this.updateLoopButton(this.clipControl.isLooping());
        if (this.getVideoClip().inspector != null) {
            this.getVideoClip().inspector.refresh();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.disabled = !bl;
    }

    private void setBounds() {
        this.toolbar.revalidate();
        this.height = this.playButton.getPreferredSize().height + 8;
        int n = this.vidPanel.getHeight() - this.height;
        int n2 = this.vidPanel.getWidth();
        this.setBounds(0, n, n2, this.height);
        this.toolbar.revalidate();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.playButton = new PlayerButton(playIcon, pauseIcon);
        this.playButton.setDisabledIcon(grayPlayIcon);
        this.playButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled || !VideoPlayer.this.playButton.isEnabled()) {
                    return;
                }
                if (VideoPlayer.this.playButton.isSelected()) {
                    VideoPlayer.this.stop();
                } else {
                    VideoPlayer.this.play();
                }
            }
        });
        this.playButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (VideoPlayer.this.disabled || !VideoPlayer.this.playButton.isEnabled()) {
                    return;
                }
                if (keyEvent.getKeyCode() == 32) {
                    if (VideoPlayer.this.playButton.isSelected()) {
                        VideoPlayer.this.stop();
                    } else {
                        VideoPlayer.this.play();
                    }
                }
            }
        });
        this.resetButton = new PlayerButton(resetIcon);
        this.resetButton.setPressedIcon(resetIcon);
        this.resetButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                VideoPlayer.this.stop();
                VideoPlayer.this.clipControl.setStepNumber(0);
                VideoPlayer.this.updatePlayButtons(false);
            }
        });
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 0.01, 10.0, 0.1);
        this.rateSpinner = new JSpinner(spinnerNumberModel){

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = Math.max(((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height, dimension.height);
                dimension.width = 5 * this.getFont().getSize() - 10 * FontSizer.getLevel();
                return dimension;
            }

            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        final JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.rateSpinner, "0%");
        numberEditor.getTextField().setHorizontalAlignment(2);
        numberEditor.getTextField().setFont(new Font("Dialog", 0, 12));
        this.rateSpinner.setEditor(numberEditor);
        this.rateSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Double d = (Double)VideoPlayer.this.rateSpinner.getValue();
                VideoPlayer.this.setRate(d);
                spinnerNumberModel.setStepSize(d >= 2.0 ? 0.5 : (d >= 0.2 ? 0.1 : 0.01));
            }
        });
        numberEditor.getTextField().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    double d = (Double)VideoPlayer.this.rateSpinner.getValue();
                    try {
                        String string = numberEditor.getTextField().getText();
                        if (string.endsWith("%")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        int n = Integer.parseInt(string);
                        double d2 = Math.max((double)n / 100.0, 0.01);
                        if ((d2 = Math.min(d2, 10.0)) != d) {
                            VideoPlayer.this.rateSpinner.setValue(new Double(d2));
                        } else {
                            int n2 = (int)(d * 100.0);
                            numberEditor.getTextField().setText(String.valueOf(String.valueOf(n2)) + "%");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        int n = (int)(d * 100.0);
                        numberEditor.getTextField().setText(String.valueOf(String.valueOf(n)) + "%");
                    }
                    numberEditor.getTextField().selectAll();
                }
            }
        });
        this.stepButton = new PlayerButton(stepIcon);
        this.stepButton.setDisabledIcon(grayStepIcon);
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if ((actionEvent.getModifiers() & 1) == 1) {
                    VideoPlayer.this.stop();
                    VideoPlayer.this.setStepNumber(VideoPlayer.this.getStepNumber() + 5);
                } else {
                    VideoPlayer.this.step();
                }
            }
        });
        this.backButton = new PlayerButton(backIcon);
        this.backButton.setDisabledIcon(grayBackIcon);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if ((actionEvent.getModifiers() & 1) == 1) {
                    VideoPlayer.this.stop();
                    VideoPlayer.this.setStepNumber(VideoPlayer.this.getStepNumber() - 5);
                } else {
                    VideoPlayer.this.back();
                }
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (mouseEvent.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(true));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(true));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (mouseEvent.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(false));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(false));
                }
            }
        };
        this.stepButton.addMouseListener(mouseAdapter);
        this.backButton.addMouseListener(mouseAdapter);
        this.readoutListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoPlayer.this.setReadoutType(actionEvent.getActionCommand());
            }
        };
        this.timeSetListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector clipInspector;
                VideoClip videoClip = VideoPlayer.this.getVideoClip();
                Object object = JOptionPane.showInputDialog(VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.SetTime.Message"), String.valueOf(MediaRes.getString("VideoPlayer.Dialog.SetTime.Title")) + " " + VideoPlayer.this.getFrameNumber(), -1, null, null, VideoPlayer.this.getTime() / 1000.0);
                if (object != null) {
                    if (object.equals("")) {
                        videoClip.setStartTime(Double.NaN);
                    } else {
                        try {
                            double d = Double.parseDouble(object.toString());
                            double d2 = d * 1000.0 - VideoPlayer.this.clipControl.getTime();
                            videoClip.setStartTime(d2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                if ((clipInspector = videoClip.inspector) != null && clipInspector.isVisible()) {
                    clipInspector.t0Field.setValue(videoClip.getStartTime() / 1000.0);
                }
            }
        };
        this.slider = new JSlider(0, 0, 0);
        this.slider.setOpaque(false);
        this.slider.setMinorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VideoClip videoClip = VideoPlayer.this.getVideoClip();
                int n = VideoPlayer.this.slider.getValue();
                if (n < videoClip.getStartFrameNumber()) {
                    VideoPlayer.this.slider.setValue(videoClip.getStartFrameNumber());
                } else if (n > videoClip.getEndFrameNumber()) {
                    VideoPlayer.this.slider.setValue(videoClip.getEndFrameNumber());
                } else {
                    int n2 = videoClip.frameToStep(n);
                    if (n2 != VideoPlayer.this.getStepNumber() && !VideoPlayer.this.disabled) {
                        VideoPlayer.this.setStepNumber(n2);
                    } else if (!videoClip.includesFrame(n)) {
                        VideoPlayer.this.slider.setValue(videoClip.stepToFrame(n2));
                    }
                }
            }
        });
        this.inLabel = new JLabel(inOutIcon);
        this.outLabel = new JLabel(inOutIcon);
        this.sliderLabels = new Hashtable();
        this.sliderLabels.put(new Integer(0), this.inLabel);
        this.sliderLabels.put(new Integer(9), this.outLabel);
        this.slider.setLabelTable(this.sliderLabels);
        this.slider.setPaintLabels(true);
        final MouseListener mouseListener = this.slider.getMouseListeners()[0];
        this.slider.removeMouseListener(mouseListener);
        final MouseMotionListener mouseMotionListener = this.slider.getMouseMotionListeners()[0];
        this.slider.removeMouseMotionListener(mouseMotionListener);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            float inset = 0.0f;
            int x;
            int maxEndFrame;

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                VideoPlayer.this.stop();
                this.maxEndFrame = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    String string;
                    String string2;
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            VideoClip videoClip = VideoPlayer.this.getVideoClip();
                            int n = (this).VideoPlayer.this.clipControl.getFrameNumber();
                            if ("in".equals(actionEvent.getActionCommand())) {
                                videoClip.setStartFrameNumber(n, maxEndFrame);
                                if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                                    videoClip.inspector.startField.setValue(videoClip.getStartFrameNumber());
                                }
                            } else {
                                videoClip.setEndFrameNumber(n);
                                if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                                    videoClip.inspector.endField.setValue(videoClip.getEndFrameNumber());
                                }
                            }
                            VideoPlayer.this.refresh();
                        }
                    };
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(String.valueOf(MediaRes.getString("ClipInspector.Title")) + "...");
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ClipInspector clipInspector;
                            if (VideoPlayer.this.disabled) {
                                return;
                            }
                            Frame frame = null;
                            Container container = (this).VideoPlayer.this.vidPanel.getTopLevelAncestor();
                            if (container instanceof Frame) {
                                frame = (Frame)container;
                            }
                            if ((clipInspector = VideoPlayer.this.getVideoClip().getClipInspector((this).VideoPlayer.this.clipControl, frame)).isVisible()) {
                                return;
                            }
                            Point point = new Frame().getLocation();
                            Point point2 = clipInspector.getLocation();
                            if (point2.x == point.x && point2.y == point.y) {
                                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                                int n = (dimension.width - clipInspector.getBounds().width) / 2;
                                int n2 = (dimension.height - clipInspector.getBounds().height) / 2;
                                clipInspector.setLocation(n, n2);
                            }
                            clipInspector.initialize();
                            clipInspector.setVisible(true);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.addSeparator();
                    int n = VideoPlayer.this.clipControl.getFrameNumber();
                    if (VideoPlayer.this.active == null || VideoPlayer.this.active.equals("in")) {
                        string2 = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetIn");
                        string2 = String.valueOf(string2) + " (" + n + ")";
                        jMenuItem = new JMenuItem(string2);
                        jMenuItem.setActionCommand("in");
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    if (VideoPlayer.this.active == null || VideoPlayer.this.active.equals("out")) {
                        string2 = MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetOut");
                        string2 = String.valueOf(string2) + " (" + n + ")";
                        jMenuItem = new JMenuItem(string2);
                        jMenuItem.setActionCommand("out");
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    VideoPlayer.this.active = null;
                    boolean bl = false;
                    String[] stringArray = VideoPlayer.this.readoutTypes;
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        string = stringArray[n3];
                        if (string.equals("time")) {
                            bl = true;
                        }
                        ++n3;
                    }
                    if (bl) {
                        jPopupMenu.addSeparator();
                        if (VideoPlayer.this.getTime() != 0.0) {
                            string = MediaRes.getString("VideoPlayer.Popup.Menu.SetTimeToZero");
                            jMenuItem = new JMenuItem(string);
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    if (VideoPlayer.this.disabled) {
                                        return;
                                    }
                                    double d = -(this).VideoPlayer.this.clipControl.getTime();
                                    VideoPlayer.this.getVideoClip().setStartTime(d);
                                }
                            });
                            jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                            jPopupMenu.add(jMenuItem);
                        }
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                        jMenuItem.setActionCommand("time");
                        jMenuItem.addActionListener(VideoPlayer.this.timeSetListener);
                        jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    jPopupMenu.show(VideoPlayer.this.slider, mouseEvent.getX(), mouseEvent.getY());
                } else if (VideoPlayer.this.active == null) {
                    mouseListener.mousePressed(mouseEvent);
                } else {
                    VideoPlayer.this.stop();
                    this.x = mouseEvent.getX();
                    if (VideoPlayer.this.active == "in") {
                        int n = VideoPlayer.this.getVideoClip().getStartFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + n);
                    } else if (VideoPlayer.this.active == "out") {
                        int n = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + n);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                VideoClip videoClip = VideoPlayer.this.getVideoClip();
                if (VideoPlayer.this.active == null) {
                    mouseListener.mouseReleased(mouseEvent);
                } else {
                    videoClip.trimFrameCount();
                    VideoPlayer.this.vidPanel.setMessage(null);
                }
                videoClip.setAdjusting(false);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                if (VideoPlayer.this.disabled) {
                    return;
                }
                mouseListener.mouseExited(mouseEvent);
                VideoPlayer.this.firePropertyChange("slider", null, new Boolean(false));
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                VideoPlayer.this.active = null;
                if (VideoPlayer.this.disabled) {
                    return;
                }
                int n = VideoPlayer.this.slider.getHeight() - VideoPlayer.this.inLabel.getHeight() - 2;
                if (this.inset == 0.0f) {
                    this.inset = ((VideoPlayer)VideoPlayer.this).slider.getInsets().left + 7;
                }
                int n2 = Math.min(0, VideoPlayer.this.getVideoClip().getFrameShift());
                if (mouseEvent.getY() > n) {
                    VideoClip videoClip = VideoPlayer.this.getVideoClip();
                    double d = ((float)VideoPlayer.this.slider.getWidth() - 2.0f * this.inset) / (float)(videoClip.getFrameCount() - 1);
                    int n3 = VideoPlayer.this.getVideoClip().getStartFrameNumber();
                    int n4 = (int)((double)this.inset + (double)(n3 + n2) * d);
                    String string = " " + MediaRes.getString("VideoPlayer.InOutMarker.ToolTip");
                    if (mouseEvent.getX() < n4 + 8 && mouseEvent.getX() > n4 - 8) {
                        VideoPlayer.this.active = "in";
                        VideoPlayer.this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + n3 + string);
                    } else {
                        int n5 = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                        n4 = (int)((double)this.inset + (double)(n5 + n2) * d);
                        if (mouseEvent.getX() < n4 + 8 && mouseEvent.getX() > n4 - 8) {
                            VideoPlayer.this.active = "out";
                            VideoPlayer.this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + n5 + string);
                        }
                    }
                }
                if (VideoPlayer.this.active == null) {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                    VideoPlayer.this.slider.setToolTipText(MediaRes.getString("VideoPlayer.Slider.ToolTip"));
                } else {
                    VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                if (VideoPlayer.this.active == null) {
                    mouseMotionListener.mouseDragged(mouseEvent);
                    return;
                }
                VideoClip videoClip = VideoPlayer.this.getVideoClip();
                videoClip.setAdjusting(true);
                boolean bl = mouseEvent.getX() > this.x;
                this.x = mouseEvent.getX();
                int n = Math.min(0, VideoPlayer.this.getVideoClip().getFrameShift());
                int n2 = Math.round((float)(videoClip.getFrameCount() - 1) * ((float)mouseEvent.getX() - this.inset) / ((float)VideoPlayer.this.slider.getWidth() - 2.0f * this.inset));
                n2 = bl ? Math.min(n2, videoClip.getFrameCount() - 1 + VideoPlayer.this.getVideoClip().getStepSize()) : Math.min(n2, videoClip.getFrameCount() - 1);
                n2 = Math.max(n2 - n, 0);
                if (VideoPlayer.this.active.equals("in")) {
                    int n3 = videoClip.getStartFrameNumber();
                    if (videoClip.setStartFrameNumber(n2, this.maxEndFrame)) {
                        int n4 = videoClip.getStartFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + n4);
                        if (!videoClip.isDefaultStartTime) {
                            double d = videoClip.getStartTime();
                            videoClip.setStartTime(d += (double)(n4 - n3) * VideoPlayer.this.clipControl.getMeanFrameDuration());
                        }
                        VideoPlayer.this.clipControl.setStepNumber(0);
                        if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                            videoClip.inspector.startField.setValue(n4);
                            videoClip.inspector.t0Field.setValue(videoClip.getStartTime() / 1000.0);
                        }
                        VideoPlayer.this.updateReadout();
                    }
                } else if (VideoPlayer.this.active.equals("out") && videoClip.setEndFrameNumber(n2)) {
                    int n5 = videoClip.getEndFrameNumber();
                    VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + n5);
                    VideoPlayer.this.clipControl.setStepNumber(videoClip.getStepCount() - 1);
                    if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                        videoClip.inspector.endField.setValue(videoClip.getEndFrameNumber());
                    }
                }
            }
        };
        this.slider.addMouseListener(mouseInputAdapter);
        this.slider.addMouseMotionListener(mouseInputAdapter);
        InputMap inputMap = this.slider.getInputMap(0);
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.slider);
        actionMap.put(inputMap.get(KeyStroke.getKeyStroke(33, 0)), null);
        actionMap.put(inputMap.get(KeyStroke.getKeyStroke(34, 0)), null);
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 33: {
                        VideoPlayer.this.back();
                        break;
                    }
                    case 34: {
                        VideoPlayer.this.step();
                    }
                }
            }
        });
        this.readout = new PlayerButton(this){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dimension;
            }
        };
        this.readout.setForeground(new Color(204, 51, 51));
        this.readout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem;
                if (VideoPlayer.this.disabled) {
                    return;
                }
                final VideoClip videoClip = VideoPlayer.this.getVideoClip();
                if (VideoPlayer.this.readoutTypes.length < 2) {
                    return;
                }
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenu jMenu = new JMenu(MediaRes.getString("VideoPlayer.Readout.Menu.Display"));
                jPopupMenu.add(jMenu);
                int n = 0;
                while (n < VideoPlayer.this.readoutTypes.length) {
                    String string = VideoPlayer.this.readoutTypes[n];
                    if (string.equals("step")) {
                        jMenuItem = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Step"));
                        jMenuItem.setSelected(string.equals(VideoPlayer.this.readoutType));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                        jMenu.add(jMenuItem);
                    } else if (string.equals("time")) {
                        jMenuItem = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Time"));
                        jMenuItem.setSelected(string.equals(VideoPlayer.this.readoutType));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                        jMenu.add(jMenuItem);
                        jPopupMenu.addSeparator();
                        if (VideoPlayer.this.getTime() != 0.0) {
                            String string2 = MediaRes.getString("VideoPlayer.Popup.Menu.SetTimeToZero");
                            jMenuItem = new JMenuItem(string2);
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    if (VideoPlayer.this.disabled) {
                                        return;
                                    }
                                    double d = -(this).VideoPlayer.this.clipControl.getTime();
                                    VideoPlayer.this.getVideoClip().setStartTime(d);
                                }
                            });
                            jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                            jPopupMenu.add(jMenuItem);
                        }
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(VideoPlayer.this.timeSetListener);
                        jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                        jPopupMenu.add(jMenuItem);
                    } else {
                        jMenuItem = new JCheckBoxMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Frame"));
                        jMenuItem.setSelected(string.equals(VideoPlayer.this.readoutType));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                        jMenu.add(jMenuItem);
                    }
                    ++n;
                }
                final Video video = videoClip.getVideo();
                if (video != null && video.getFrameCount() > 1) {
                    jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.Renumber"));
                    jMenuItem.setActionCommand("frame");
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = video.getFrameNumber();
                            Object object = JOptionPane.showInputDialog((this).VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.SetFrameNumber.Message"), String.valueOf(MediaRes.getString("VideoPlayer.Dialog.SetFrameNumber.Title")) + " " + n, -1, null, null, VideoPlayer.this.getFrameNumber());
                            if (object != null && !object.equals("")) {
                                try {
                                    int n2 = Integer.parseInt(object.toString());
                                    int n3 = n - n2;
                                    int n4 = videoClip.getStartFrameNumber();
                                    int n5 = videoClip.getStepCount();
                                    videoClip.setFrameShift(n3, n4, n5);
                                    VideoPlayer.this.updateSlider();
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        }
                    });
                    jMenuItem.addActionListener(VideoPlayer.this.readoutListener);
                    jPopupMenu.add(jMenuItem);
                }
                jPopupMenu.show(VideoPlayer.this.readout, 0, VideoPlayer.this.readout.getHeight());
            }
        });
        this.readout.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    VideoPlayer.this.readout.doClick(0);
                }
            }
        });
        this.stepSizeButton = new PlayerButton(this){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = ((VideoPlayer)this).rateSpinner.getPreferredSize().height;
                return dimension;
            }
        };
        this.stepSizeButton.setForeground(new Color(204, 51, 51));
        this.stepSizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VideoPlayer.this.disabled) {
                    return;
                }
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VideoClip videoClip;
                        int n;
                        block3: {
                            n = VideoPlayer.this.getFrameNumber();
                            videoClip = VideoPlayer.this.getVideoClip();
                            try {
                                int n2 = Integer.parseInt(actionEvent.getActionCommand());
                                videoClip.setStepSize(n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                String string = String.valueOf(VideoPlayer.this.getVideoClip().getStepSize());
                                Object object = JOptionPane.showInputDialog((this).VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.StepSize.Message"), MediaRes.getString("VideoPlayer.Dialog.StepSize.Title"), -1, null, null, string);
                                if (object == null) break block3;
                                int n3 = Integer.parseInt(object.toString());
                                videoClip.setStepSize(n3);
                            }
                        }
                        VideoPlayer.this.setStepNumber(videoClip.frameToStep(n));
                        if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                            videoClip.inspector.stepSizeField.setValue(videoClip.getStepSize());
                        }
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = 1;
                while (n < 6) {
                    JMenuItem jMenuItem = new JMenuItem(String.valueOf(n));
                    jMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                }
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Button.StepSize.Other"));
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show(VideoPlayer.this.stepSizeButton, 0, VideoPlayer.this.stepSizeButton.getHeight());
            }
        });
        this.stepSizeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    VideoPlayer.this.stepSizeButton.doClick(0);
                }
            }
        });
        this.inspectorButton = new PlayerButton(videoClipIcon);
        this.inspectorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector clipInspector;
                if (VideoPlayer.this.disabled) {
                    return;
                }
                Frame frame = null;
                Container container = VideoPlayer.this.vidPanel.getTopLevelAncestor();
                if (container instanceof Frame) {
                    frame = (Frame)container;
                }
                if ((clipInspector = VideoPlayer.this.getVideoClip().getClipInspector(VideoPlayer.this.clipControl, frame)).isVisible()) {
                    return;
                }
                Point point = new Frame().getLocation();
                Point point2 = clipInspector.getLocation();
                if (point2.x == point.x && point2.y == point.y) {
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (dimension.width - clipInspector.getBounds().width) / 2;
                    int n2 = (dimension.height - clipInspector.getBounds().height) / 2;
                    clipInspector.setLocation(n, n2);
                }
                clipInspector.initialize();
                clipInspector.setVisible(true);
            }
        });
        this.loopButton = new PlayerButton(noloopIcon, loopIcon);
        this.loopButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
            }
        });
        this.loopButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
                }
            }
        });
        this.toolbar.add(this.readout);
        this.toolbar.add(this.rateSpinner);
        this.toolbar.add(this.resetButton);
        this.toolbar.add(this.playButton);
        this.toolbar.add(this.slider);
        this.toolbar.add(this.backButton);
        this.toolbar.add(this.stepSizeButton);
        this.toolbar.add(this.stepButton);
        this.toolbar.add(this.loopButton);
        if (this.inspectorButtonVisible) {
            this.toolbar.add(this.inspectorButton);
        }
    }

    private void updatePlayButtons(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                int n = VideoPlayer.this.getVideoClip().getStepCount();
                boolean bl2 = n > 1;
                VideoPlayer.this.playButton.setEnabled(bl2 && (bl || VideoPlayer.this.getStepNumber() < n - 1));
                VideoPlayer.this.stepButton.setEnabled(bl2 && (bl || VideoPlayer.this.getStepNumber() < n - 1));
                VideoPlayer.this.backButton.setEnabled(bl2 && (bl || VideoPlayer.this.getStepNumber() > 0));
                VideoPlayer.this.playButton.setSelected(bl);
                if (bl) {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Pause.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(pauseIcon);
                    VideoPlayer.this.playButton.setIcon(pauseIcon);
                } else {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Play.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(playIcon);
                    VideoPlayer.this.playButton.setIcon(playIcon);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void updateLoopButton(boolean bl) {
        if (bl == this.loopButton.isSelected()) {
            return;
        }
        this.loopButton.setSelected(bl);
        if (bl) {
            this.loopButton.setPressedIcon(loopIcon);
            this.loopButton.setIcon(loopIcon);
        } else {
            this.loopButton.setPressedIcon(noloopIcon);
            this.loopButton.setIcon(noloopIcon);
        }
    }

    private void updateReadout() {
        int n;
        int n2 = this.clipControl.getFrameNumber();
        int n3 = this.getVideoClip().getStartFrameNumber();
        int n4 = this.getVideoClip().getEndFrameNumber();
        if (n2 < n3) {
            this.clipControl.setStepNumber(0);
        } else if (n2 > n4) {
            this.clipControl.setStepNumber(this.getVideoClip().getStepCount());
        }
        this.slider.setValue(this.clipControl.getFrameNumber());
        int n5 = this.clipControl.getStepNumber();
        String string = this.readoutType.equals("step") ? (n5 < 10 ? "00" + n5 : (n5 < 100 ? "0" + n5 : "" + n5)) : (this.readoutType.equals("frame") ? ((n = this.clipControl.getFrameNumber()) < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n)) : this.timeFormat.format(this.getTime() / 1000.0));
        this.readout.setText(string);
        this.rateSpinner.setValue(this.getRate());
        this.stepSizeButton.setText("" + this.getVideoClip().getStepSize());
        FontSizer.setFonts(this.readout, FontSizer.getLevel());
        FontSizer.setFonts(this.rateSpinner, FontSizer.getLevel());
        FontSizer.setFonts(this.stepSizeButton, FontSizer.getLevel());
        this.stepSizeButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepSize.ToolTip"));
        this.rateSpinner.setToolTipText(MediaRes.getString("VideoPlayer.Spinner.Rate.ToolTip"));
        if (n5 == this.getVideoClip().getStepCount() - 1) {
            this.updatePlayButtons(this.clipControl.isPlaying());
        }
    }

    private void updateSlider() {
        VideoClip videoClip = this.getVideoClip();
        this.slider.setMinimum(Math.max(0, -videoClip.getFrameShift()));
        this.slider.setMaximum(this.slider.getMinimum() + videoClip.getFrameCount() - 1);
        this.sliderLabels.clear();
        this.sliderLabels.put(new Integer(videoClip.getStartFrameNumber()), this.inLabel);
        this.sliderLabels.put(new Integer(videoClip.getEndFrameNumber()), this.outLabel);
        this.slider.repaint();
    }

    protected class PlayerButton
    extends JButton {
        Icon onIcon;
        Icon offIcon;

        public PlayerButton() {
            this.setOpaque(false);
            this.setBorderPainted(false);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    PlayerButton.this.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    PlayerButton.this.setBorderPainted(false);
                }
            });
        }

        public PlayerButton(Icon icon) {
            this();
            this.setIcon(icon);
        }

        public PlayerButton(Icon icon, Icon icon2) {
            this();
            this.onIcon = icon2;
            this.offIcon = icon;
            this.setIcon(icon);
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            this.setSelectedIcon(icon);
            this.setRolloverSelectedIcon(icon);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (bl && this.onIcon != null) {
                this.setIcon(this.onIcon);
            } else if (!bl && this.offIcon != null) {
                this.setIcon(this.offIcon);
            }
        }
    }
}

