/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.quicktime;

import javax.swing.JFrame;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.quicktime.QT;
import quicktime.QTException;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTFactory;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;

public class QTPlayer
extends JFrame {
    private Thread shutdownHook;

    public QTPlayer() {
        super(MediaRes.getString("QTPlayer.Title"));
        this.setName("QTPlayerTool");
        this.setDefaultCloseOperation(1);
        this.shutdownHook = new Thread(){

            public void run() {
                QT.exit();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void load(String string) throws QTException {
        QTFile qTFile = new QTFile(string);
        OpenMovieFile openMovieFile = OpenMovieFile.asRead((QTFile)qTFile);
        Movie movie = Movie.fromFile((OpenMovieFile)openMovieFile);
        MovieController movieController = new MovieController(movie);
        QTComponent qTComponent = QTFactory.makeQTComponent((MovieController)movieController);
        this.setTitle(String.valueOf(MediaRes.getString("QTPlayer.Title")) + ": " + string);
        this.getContentPane().removeAll();
        this.getContentPane().add(qTComponent.asComponent());
        this.pack();
    }
}

