/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.quicktime;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.Timer;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.quicktime.QT;
import org.opensourcephysics.media.quicktime.QTip;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTImageProducer;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieDrawingComplete;
import quicktime.std.movies.TimeInfo;
import quicktime.std.movies.media.DataRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTVideo
implements Video,
MovieDrawingComplete {
    protected static JFileChooser chooser;
    private Movie movie;
    private QTFile qtFile;
    private Image videoImage;
    private Dimension size;
    private BufferedImage bufferedImage;
    private BufferedImage filteredImage;
    private Graphics gbi;
    private QTImageProducer qtImageProducer;
    private MoviePlayer moviePlayer;
    private QTip qTip;
    private int frameCount;
    private int[] frameTimes;
    private int frameNumber;
    private int startFrameNumber;
    private int endFrameNumber;
    private Timer timer;
    private Timer oneShot;
    private double rate = 1.0;
    private boolean playing = false;
    private boolean looping = false;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private boolean mouseEnabled = false;
    private boolean visible = true;
    private boolean isMeasured = false;
    private boolean isValidMeasure = false;
    private boolean widthDominates = true;
    private boolean isValidImage = false;
    private boolean isValidFilteredImage = false;
    private boolean firstTimeDrawn = true;
    private ImageCoordSystem coords;
    private DoubleArray aspects;
    private PropertyChangeSupport support;
    private HashMap<String, Object> properties = new HashMap();
    private FilterStack filterStack = new FilterStack();

    public QTVideo() throws IOException {
        this.initialize();
        this.loadFromDialog();
    }

    public QTVideo(String string) throws IOException {
        this.initialize();
        this.load(string);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        if (!this.visible || this.videoImage == null) {
            return;
        }
        if (this.firstTimeDrawn) {
            object = graphics.getClip();
            graphics.setClip(new Rectangle());
            graphics.drawImage(this.videoImage, 0, 0, drawingPanel);
            graphics.setClip((Shape)object);
            this.gbi.drawImage(this.videoImage, 0, 0, drawingPanel);
            this.firstTimeDrawn = false;
            this.isValidImage = false;
            this.isValidFilteredImage = false;
        }
        object = (Graphics2D)graphics;
        if (drawingPanel instanceof VideoPanel && ((VideoPanel)drawingPanel).isDrawingInImageSpace() || this.isMeasured) {
            AffineTransform affineTransform = ((Graphics2D)object).getTransform();
            ((Graphics2D)object).transform(drawingPanel.getPixelTransform());
            if (drawingPanel instanceof VideoPanel) {
                VideoPanel videoPanel = (VideoPanel)drawingPanel;
                if (!videoPanel.isDrawingInImageSpace()) {
                    ImageCoordSystem imageCoordSystem = videoPanel.getCoords();
                    ((Graphics2D)object).transform(imageCoordSystem.getToWorldTransform(this.frameNumber));
                }
            } else {
                ((Graphics2D)object).transform(this.coords.getToWorldTransform(this.frameNumber));
            }
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                ((Graphics)object).drawImage(this.videoImage, 0, 0, drawingPanel);
            } else {
                ((Graphics)object).drawImage(this.getImage(), 0, 0, drawingPanel);
            }
            ((Graphics2D)object).setTransform(affineTransform);
        } else {
            double d = (drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0;
            double d2 = (drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0;
            int n = drawingPanel.xToPix(d) - this.size.width / 2;
            int n2 = drawingPanel.yToPix(d2) - this.size.height / 2;
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                ((Graphics)object).drawImage(this.videoImage, n, n2, drawingPanel);
            } else {
                ((Graphics)object).drawImage(this.getImage(), n, n2, drawingPanel);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
        this.firePropertyChange("videoVisible", null, new Boolean(bl));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public double getXMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minX;
    }

    @Override
    public double getXMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxX;
    }

    @Override
    public double getYMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minY;
    }

    @Override
    public double getYMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxY;
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public BufferedImage getImage() {
        if (this.videoImage == null) {
            return null;
        }
        if (!this.isValidImage) {
            this.isValidImage = true;
            this.gbi.drawImage(this.videoImage, 0, 0, null);
        }
        if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
            return this.bufferedImage;
        }
        if (!this.isValidFilteredImage) {
            this.isValidFilteredImage = true;
            this.filteredImage = this.filterStack.getFilteredImage(this.bufferedImage);
        }
        return this.filteredImage;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.mouseEnabled) {
            return null;
        }
        return this;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.mouseEnabled;
    }

    @Override
    public void setFrameX(int n, double d) {
        this.setFrameXY(n, d, this.coords.imageToWorldY(n, 0.0, 0.0));
    }

    @Override
    public void setX(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameX(n, d);
            ++n;
        }
    }

    @Override
    public void setFrameY(int n, double d) {
        this.setFrameXY(n, this.coords.imageToWorldX(n, 0.0, 0.0), d);
    }

    @Override
    public void setY(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameY(n, d);
            ++n;
        }
    }

    @Override
    public double getX() {
        return this.coords.imageToWorldX(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public double getY() {
        return this.coords.imageToWorldY(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public void setFrameXY(int n, double d, double d2) {
        double d3 = this.coords.getSine(n);
        double d4 = this.coords.getCosine(n);
        double d5 = this.coords.getScaleX(n) * (d2 * d3 - d * d4);
        double d6 = this.coords.getScaleY(n) * (d2 * d4 + d * d3);
        this.coords.setOriginXY(n, d5, d6);
    }

    @Override
    public void setXY(double d, double d2) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameXY(n, d, d2);
            ++n;
        }
    }

    @Override
    public void setFrameRelativeAspect(int n, double d) {
        if (d < 0.001 || d > 1000.0) {
            return;
        }
        this.aspects.set(n, Math.abs(d));
        if (this.isMeasured) {
            if (this.widthDominates) {
                this.setFrameWidth(n, (double)this.size.width / this.coords.getScaleX(n));
            } else {
                this.setFrameHeight(n, (double)this.size.height / this.coords.getScaleY(n));
            }
        }
    }

    @Override
    public void setRelativeAspect(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameRelativeAspect(n, d);
            ++n;
        }
    }

    @Override
    public double getRelativeAspect() {
        return this.aspects.get(this.frameNumber);
    }

    @Override
    public void setFrameWidth(int n, double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = (double)this.size.width / d;
        this.coords.setScaleX(n, d4);
        this.coords.setScaleY(n, d4 * this.aspects.get(n));
        this.widthDominates = true;
        this.setFrameXY(n, d2, d3);
    }

    @Override
    public void setWidth(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameWidth(n, d);
            ++n;
        }
    }

    @Override
    public double getWidth() {
        return (double)this.size.width / this.coords.getScaleX(this.frameNumber);
    }

    @Override
    public void setFrameHeight(int n, double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = (double)this.size.height / d;
        this.coords.setScaleY(n, d4);
        this.coords.setScaleX(n, d4 / this.aspects.get(n));
        this.widthDominates = false;
        this.setFrameXY(n, d2, d3);
    }

    @Override
    public void setHeight(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameHeight(n, d);
            ++n;
        }
    }

    @Override
    public double getHeight() {
        return (double)this.size.height / this.coords.getScaleY(this.frameNumber);
    }

    @Override
    public void setFrameAngle(int n, double d) {
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        this.coords.setCosineSine(n, d4, -d5);
        this.setFrameXY(n, d2, d3);
    }

    @Override
    public void setAngle(double d) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameAngle(n, d);
            ++n;
        }
    }

    @Override
    public double getAngle() {
        return -this.coords.getAngle(this.frameNumber);
    }

    @Override
    public void step() {
        this.stop();
        this.setFrameNumber(this.frameNumber + 1);
    }

    @Override
    public void back() {
        this.stop();
        this.setFrameNumber(this.frameNumber - 1);
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public void setFrameNumber(int n) {
        if (n == this.frameNumber) {
            return;
        }
        n = Math.min(n, this.endFrameNumber);
        n = Math.max(n, this.startFrameNumber);
        this.firePropertyChange("nextframe", null, n);
        try {
            int n2 = this.movie.getTimeScale() / 500;
            this.moviePlayer.setTime(this.frameTimes[n] + n2);
            this.frameNumber = n;
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    @Override
    public int getStartFrameNumber() {
        return this.startFrameNumber;
    }

    @Override
    public void setStartFrameNumber(int n) {
        if (n == this.startFrameNumber) {
            return;
        }
        n = Math.max(0, n);
        this.startFrameNumber = Math.min(this.endFrameNumber, n);
        try {
            int n2 = this.frameTimes[this.startFrameNumber];
            int n3 = this.movie.getDuration() - n2;
            if (this.endFrameNumber < this.frameCount - 1) {
                n3 = this.frameTimes[this.endFrameNumber + 1] - n2;
            }
            this.movie.setActiveSegment(new TimeInfo(n2, n3));
        }
        catch (StdQTException stdQTException) {
            stdQTException.printStackTrace();
        }
        if (this.frameNumber < this.startFrameNumber) {
            this.setFrameNumber(this.startFrameNumber);
        }
        if (this.looping && this.playing) {
            this.timer.stop();
            this.timer.setDelay((int)((this.getEndTime() - this.getStartTime()) / this.rate));
            this.timer.setInitialDelay((int)((this.getEndTime() - this.getTime()) / this.rate));
            this.timer.start();
        }
        this.firePropertyChange("startframe", null, new Integer(this.startFrameNumber));
    }

    @Override
    public int getEndFrameNumber() {
        return this.endFrameNumber;
    }

    @Override
    public void setEndFrameNumber(int n) {
        if (n == this.endFrameNumber) {
            return;
        }
        n = Math.min(this.frameCount - 1, n);
        this.endFrameNumber = Math.max(this.startFrameNumber, n);
        try {
            int n2 = this.frameTimes[this.startFrameNumber];
            int n3 = this.movie.getDuration() - n2;
            if (this.endFrameNumber < this.frameCount - 1) {
                n3 = this.frameTimes[this.endFrameNumber + 1] - n2;
            }
            this.movie.setActiveSegment(new TimeInfo(n2, n3));
        }
        catch (StdQTException stdQTException) {
            stdQTException.printStackTrace();
        }
        if (this.frameNumber > this.endFrameNumber) {
            this.setFrameNumber(this.endFrameNumber);
        }
        if (this.looping && this.playing) {
            this.timer.stop();
            this.timer.setDelay((int)((this.getEndTime() - this.getStartTime()) / this.rate));
            this.timer.setInitialDelay((int)((this.getEndTime() - this.getTime()) / this.rate));
            this.timer.start();
        }
        this.firePropertyChange("endframe", null, new Integer(this.endFrameNumber));
    }

    @Override
    public double getFrameTime(int n) {
        try {
            return 1000.0 * (double)this.frameTimes[n] / (double)this.movie.getTimeScale();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public double getFrameDuration(int n) {
        if (this.frameCount == 1) {
            return this.getDuration();
        }
        if (n == this.frameCount - 1) {
            return this.getDuration() - this.getFrameTime(n);
        }
        return this.getFrameTime(n + 1) - this.getFrameTime(n);
    }

    @Override
    public void play() {
        if (this.frameCount == 1) {
            return;
        }
        this.playing = true;
        try {
            if ((double)this.moviePlayer.getRate() != this.rate) {
                if (this.frameNumber >= this.endFrameNumber || this.frameNumber < this.startFrameNumber) {
                    this.setFrameNumber(this.startFrameNumber);
                }
                if (this.looping) {
                    this.timer.stop();
                    this.timer.setDelay((int)((this.getEndTime() - this.getStartTime()) / this.rate));
                    this.timer.setInitialDelay((int)((this.getEndTime() - this.getTime()) / this.rate));
                    this.timer.start();
                }
                this.moviePlayer.setRate((float)this.rate);
                this.firePropertyChange("playing", null, new Boolean(true));
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    @Override
    public void stop() {
        this.playing = false;
        try {
            if (this.moviePlayer.getRate() != 0.0f) {
                this.moviePlayer.setRate(0.0f);
                this.timer.stop();
                this.oneShot.stop();
                this.firePropertyChange("playing", null, new Boolean(false));
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    @Override
    public void reset() {
        this.stop();
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public double getTime() {
        try {
            return 1000.0 * (double)this.movie.getTime() / (double)this.movie.getTimeScale();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public void setTime(double d) {
        try {
            int n = (int)(d * (double)this.movie.getTimeScale() / 1000.0);
            this.movie.setTimeValue(n);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    @Override
    public double getStartTime() {
        try {
            return 1000.0 * (double)this.frameTimes[this.startFrameNumber] / (double)this.movie.getTimeScale();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public void setStartTime(double d) {
        try {
            int n = this.frameCount - 1;
            while (n >= 0) {
                double d2 = 1000.0 * (double)this.frameTimes[n] / (double)this.movie.getTimeScale();
                if (d2 <= d) break;
                --n;
            }
            this.setStartFrameNumber(n);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    @Override
    public double getEndTime() {
        try {
            if (this.endFrameNumber == this.frameCount - 1) {
                return this.getDuration();
            }
            return 1000.0 * (double)this.frameTimes[this.endFrameNumber + 1] / (double)this.movie.getTimeScale();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public void setEndTime(double d) {
        try {
            int n = this.frameCount - 1;
            while (n >= 0) {
                double d2 = 1000.0 * (double)this.frameTimes[n] / (double)this.movie.getTimeScale();
                if (d2 <= d) break;
                --n;
            }
            this.setEndFrameNumber(n);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    @Override
    public double getDuration() {
        try {
            return 1000.0 * (double)this.movie.getDuration() / (double)this.movie.getTimeScale();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public void goToStart() {
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public void goToEnd() {
        this.setFrameNumber(this.endFrameNumber);
    }

    @Override
    public void setPlaying(boolean bl) {
        if (bl) {
            this.play();
        } else {
            this.stop();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void setLooping(boolean bl) {
        if (this.looping == bl) {
            return;
        }
        this.looping = bl;
        if (this.playing) {
            if (this.looping) {
                this.timer.setDelay((int)((this.getEndTime() - this.getStartTime()) / this.rate));
                this.timer.setInitialDelay((int)((this.getEndTime() - this.getTime()) / this.rate));
                this.timer.start();
            } else {
                this.timer.stop();
            }
        }
        this.firePropertyChange("looping", null, new Boolean(this.looping));
    }

    @Override
    public boolean isLooping() {
        return this.looping;
    }

    @Override
    public void setRate(double d) {
        if ((d = Math.abs(d)) == this.rate || d == 0.0) {
            return;
        }
        this.rate = d;
        try {
            if (this.movie.getRate() != 0.0f) {
                this.play();
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
        this.firePropertyChange("rate", null, new Double(d));
    }

    @Override
    public double getRate() {
        return this.rate;
    }

    @Override
    public void setCoords(ImageCoordSystem imageCoordSystem) {
        if (imageCoordSystem == this.coords) {
            return;
        }
        if (this.coords != null) {
            this.coords.removePropertyChangeListener(this);
        }
        imageCoordSystem.addPropertyChangeListener(this);
        this.coords = imageCoordSystem;
        this.isMeasured = true;
        this.isValidMeasure = false;
        this.firePropertyChange("coords", null, imageCoordSystem);
    }

    @Override
    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    @Override
    public void setFilterStack(FilterStack filterStack) {
        this.filterStack.removePropertyChangeListener(this);
        this.filterStack = filterStack;
        this.filterStack.addPropertyChangeListener(this);
    }

    @Override
    public FilterStack getFilterStack() {
        return this.filterStack;
    }

    @Override
    public void setProperty(String string, Object object) {
        if (string.equals("measure")) {
            this.isValidMeasure = false;
        } else {
            this.properties.put(string, object);
        }
    }

    @Override
    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void dispose() {
        this.getFilterStack().setInspectorsVisible(false);
        if (this.coords != null) {
            this.coords.removePropertyChangeListener(this);
        }
        this.stop();
        if (this.qTip != null) {
            QT.remove(this.qTip);
            this.qTip = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.coords) {
            this.isMeasured = true;
            this.isValidMeasure = false;
        } else if (propertyChangeEvent.getSource() == this.filterStack) {
            this.isValidFilteredImage = false;
            this.support.firePropertyChange(propertyChangeEvent);
        }
    }

    public int execute(Movie movie) {
        try {
            this.qtImageProducer.updateConsumers(null);
            this.isValidImage = false;
            this.isValidFilteredImage = false;
            int n = movie.getTime();
            int n2 = 0;
            while (n2 < this.frameTimes.length) {
                if (n < this.frameTimes[n2]) break;
                ++n2;
            }
            this.frameNumber = Math.min(n2 - 1, this.endFrameNumber);
            this.firePropertyChange("framenumber", null, new Integer(this.frameNumber));
            this.oneShot.stop();
            if (this.playing && !this.looping) {
                this.oneShot.setInitialDelay((int)((this.getEndTime() - this.getTime()) / this.rate));
                this.oneShot.start();
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            return qTException.errorCode();
        }
        return 0;
    }

    public String toString() {
        return (String)this.getProperty("name");
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    protected void finalize() {
        this.dispose();
    }

    private void initialize() {
        QT.start();
        this.support = new SwingPropertyChangeSupport(this);
        this.filterStack.addPropertyChangeListener(this);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QTVideo.this.setFrameNumber(QTVideo.this.startFrameNumber);
            }
        });
        this.oneShot = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QTVideo.this.stop();
                QTVideo.this.setFrameNumber(QTVideo.this.endFrameNumber);
            }
        });
        this.oneShot.setRepeats(false);
    }

    public void load(String string) throws IOException {
        if (!QTSession.isInitialized()) {
            throw new IOException("QT not available");
        }
        if (string == null || string.equals("")) {
            return;
        }
        OSPLog.fine("loading " + string);
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            throw new IOException(String.valueOf(string) + " resource not found");
        }
        this.setProperty("name", string);
        this.setProperty("absolutePath", resource.getAbsolutePath());
        String string2 = XML.forwardSlash(string);
        if (string2.indexOf(":") == -1 && !string2.startsWith("/")) {
            this.setProperty("path", string2);
        } else {
            this.setProperty("path", XML.getRelativePath(string2));
        }
        if (resource.getFile() != null) {
            this.load(resource.getFile());
            return;
        }
        if (resource.getURL() != null) {
            this.load(resource.getURL());
        }
    }

    public void load(File file) throws IOException {
        try {
            this.qtFile = new QTFile(file);
            OpenMovieFile openMovieFile = OpenMovieFile.asRead((QTFile)this.qtFile);
            this.setMovie(Movie.fromFile((OpenMovieFile)openMovieFile));
        }
        catch (StdQTException stdQTException) {
            throw new IOException("File type not supported by QuickTime");
        }
        catch (QTException qTException) {
            throw new IOException("File not found");
        }
    }

    public void load(URL uRL) throws IOException {
        try {
            DataRef dataRef = new DataRef(uRL.toString());
            Movie movie = Movie.fromDataRef((DataRef)dataRef, (int)1);
            this.setMovie(movie);
        }
        catch (StdQTException stdQTException) {
            throw new IOException("URL file type not supported by QuickTime");
        }
        catch (QTException qTException) {
            throw new IOException("URL not found");
        }
    }

    private void loadFromDialog() throws IOException {
        int n;
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        if ((n = chooser.showOpenDialog(null)) == 0) {
            this.load(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void setMovie(Movie movie) throws QTException, IOException {
        this.movie = movie;
        Movie.taskAll((int)0);
        this.moviePlayer = new MoviePlayer(this.movie);
        this.moviePlayer.setRate(0.0f);
        QDRect qDRect = this.moviePlayer.getDisplayBounds();
        this.size = new Dimension(qDRect.getWidth(), qDRect.getHeight());
        if (this.size.width == 0) {
            throw new IOException("Movie contains no video content");
        }
        this.qtImageProducer = new QTImageProducer(this.moviePlayer, this.size);
        this.videoImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)this.qtImageProducer);
        this.movie.setDrawingCompleteProc(0, (MovieDrawingComplete)this);
        this.qTip = new QTip(0, new Object[]{this.moviePlayer});
        QT.add(this.qTip);
        this.bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
        this.gbi = this.bufferedImage.createGraphics();
        int n = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.movie.goToBeginning();
        int n2 = this.movie.getTime();
        while (n2 > -1) {
            n = n2;
            arrayList.add(new Integer(n));
            n2 = this.movie.getNextInterestingTime((int)16, (int[])new int[]{1702454643}, (int)n, (float)1.0f).time;
        }
        this.frameCount = arrayList.size();
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        Object[] objectArray = arrayList.toArray();
        this.frameTimes = new int[this.frameCount];
        int n3 = 0;
        while (n3 < this.frameCount) {
            this.frameTimes[n3] = (Integer)objectArray[n3];
            ++n3;
        }
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private void findMinMaxValues() {
        VideoClip videoClip = (VideoClip)this.getProperty("videoclip");
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        int n = 0;
        if (videoClip != null) {
            n = videoClip.getStartFrameNumber();
        }
        AffineTransform affineTransform = this.coords.getToWorldTransform(n);
        affineTransform.transform(double_, double_);
        this.maxX = this.minX = ((Point2D)double_).getX();
        this.maxY = this.minY = ((Point2D)double_).getY();
        int n2 = this.frameCount;
        if (videoClip != null) {
            n2 = videoClip.getStepCount();
        }
        int n3 = 0;
        while (n3 < n2) {
            affineTransform = videoClip == null ? this.coords.getToWorldTransform(n3) : this.coords.getToWorldTransform(videoClip.stepToFrame(n3));
            int n4 = 0;
            while (n4 < 4) {
                switch (n4) {
                    case 0: {
                        ((Point2D)double_).setLocation(0.0, 0.0);
                        break;
                    }
                    case 1: {
                        ((Point2D)double_).setLocation(this.size.width, 0.0);
                        break;
                    }
                    case 2: {
                        ((Point2D)double_).setLocation(0.0, this.size.height);
                        break;
                    }
                    case 3: {
                        ((Point2D)double_).setLocation(this.size.width, this.size.height);
                    }
                }
                affineTransform.transform(double_, double_);
                this.minX = Math.min(((Point2D)double_).getX(), this.minX);
                this.maxX = Math.max(((Point2D)double_).getX(), this.maxX);
                this.minY = Math.min(((Point2D)double_).getY(), this.minY);
                this.maxY = Math.max(((Point2D)double_).getY(), this.maxY);
                ++n4;
            }
            ++n3;
        }
        this.isValidMeasure = true;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            QTVideo qTVideo = (QTVideo)object;
            String string = (String)qTVideo.getProperty("base");
            String string2 = (String)qTVideo.getProperty("absolutePath");
            xMLControl.setValue("path", XML.getPathRelativeTo(string2, string));
            if (!qTVideo.getFilterStack().isEmpty()) {
                xMLControl.setValue("filters", qTVideo.getFilterStack().getFilters());
            }
        }

        public Object createObject(XMLControl xMLControl) {
            try {
                String string = xMLControl.getString("path");
                QTVideo qTVideo = new QTVideo(string);
                VideoType videoType = VideoIO.getVideoType("QT", null);
                if (videoType != null) {
                    qTVideo.setProperty("video_type", videoType);
                }
                return qTVideo;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            QTVideo qTVideo = (QTVideo)object;
            Collection collection = (Collection)Collection.class.cast(xMLControl.getObject("filters"));
            if (collection != null) {
                qTVideo.getFilterStack().clear();
                for (Filter filter : collection) {
                    qTVideo.getFilterStack().addFilter(filter);
                }
            }
            return object;
        }
    }
}

