/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.approach;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.approach.BoxWRApp;
import org.opensourcephysics.stp.approach.BoxWRAppControl;

public class BoxApp
extends AbstractSimulation {
    PlotFrame plotFrame = new PlotFrame("time", "n", "");
    DatasetManager datasets;
    int N = 64;
    public int nleft;
    int time;
    int zeroedTime;
    int nleftAccumulator;
    int nleftSquaredAccumulator;
    NumberFormat numberFormatTwoDigits = NumberFormat.getInstance();

    public BoxApp() {
        this.plotFrame.setTitle("Approach to Equilibrium.");
        this.plotFrame.setMarkerColor(0, Color.RED);
        this.numberFormatTwoDigits.setMaximumFractionDigits(2);
        this.datasets = this.plotFrame.getDatasetManager();
    }

    public void reset() {
        this.control.setValue("N", 64);
        this.plotFrame.setPreferredMinMaxX(0.0, 100.0);
        this.plotFrame.setPreferredMinMaxY(0.0, this.N);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.plotFrame.repaint();
        this.zeroAverages();
    }

    public void initialize() {
        this.N = this.control.getInt("N");
        this.time = 0;
        this.zeroedTime = 0;
        this.nleft = this.N;
        this.nleftAccumulator = 0;
        this.nleftSquaredAccumulator = 0;
    }

    public void moveParticle() {
        double d;
        double d2 = Math.random();
        this.nleft = d2 <= (d = (double)this.nleft / (double)this.N) ? --this.nleft : ++this.nleft;
        ++this.time;
        ++this.zeroedTime;
    }

    public void stopRunning() {
        this.control.clearMessages();
        this.control.println("<n> = " + this.numberFormatTwoDigits.format((double)this.nleftAccumulator / (double)this.zeroedTime));
        this.control.println("<n\u00b2> = " + this.numberFormatTwoDigits.format((double)this.nleftSquaredAccumulator / (double)this.zeroedTime));
        this.control.println("\u03c3\u00b2 = " + this.numberFormatTwoDigits.format((double)this.nleftSquaredAccumulator / (double)this.zeroedTime - (double)this.nleftAccumulator * (double)this.nleftAccumulator / (double)this.zeroedTime / (double)this.zeroedTime));
    }

    public void zeroAverages() {
        this.nleftAccumulator = 0;
        this.nleftSquaredAccumulator = 0;
        this.zeroedTime = 0;
        this.datasets.clear();
        this.control.println("<n> = 0");
        this.control.println("<n\u00b2> = 0");
        this.control.println("\u03c3\u00b2 = 0");
    }

    public void doStep() {
        this.plotFrame.append(0, this.time, this.nleft);
        this.moveParticle();
        this.nleftAccumulator += this.nleft;
        this.nleftSquaredAccumulator += this.nleft * this.nleft;
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = BoxApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(BoxApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                BoxWRApp boxWRApp = new BoxWRApp();
                BoxWRAppControl boxWRAppControl = new BoxWRAppControl(boxWRApp, (DrawingFrame)boxWRApp.plotFrame, null);
                boxWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        boxWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                boxWRAppControl.loadXML(xMLControlElement, true);
                boxWRApp.customize();
                boxWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoxApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        BoxApp boxApp = new BoxApp();
        SimulationControl simulationControl = SimulationControl.createApp(boxApp, stringArray);
        simulationControl.addButton("zeroAverages", "Zero averages");
        boxApp.customize();
    }
}

