/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.approach;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.approach.LJgas2box;
import org.opensourcephysics.stp.approach.LJgas2boxWRApp;
import org.opensourcephysics.stp.approach.LJgas2boxWRAppControl;

public class LJgas2boxApp
extends AbstractSimulation {
    LJgas2box gas = new LJgas2box();
    PlotFrame plotFrame = new PlotFrame("time", "n1, n2", "Number of particles in each cell");
    DisplayFrame displayFrame = new DisplayFrame("Particle positions");
    DrawingPanel displayPanel = this.displayFrame.getDrawingPanel();

    public void initialize() {
        this.displayPanel.addDrawable(this.gas);
        this.plotFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.gas.numberOfParticles = this.control.getInt("N");
        this.gas.initialize();
        this.displayPanel.setPreferredMinMax(-0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength, -0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength);
    }

    public void doStep() {
        int n = 0;
        while (n < 10) {
            this.gas.step();
            ++n;
        }
        this.plotFrame.append(0, this.gas.t, this.gas.n0);
        this.plotFrame.append(1, this.gas.t, this.gas.n1);
        this.gas.zeroAverages();
    }

    public void reset() {
        this.control.setValue("N", 270);
        this.initialize();
        this.enableStepsPerDisplay(true);
    }

    public void reverse() {
        this.gas.reverse();
        this.gas.zeroAverages();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = LJgas2boxApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(LJgas2boxApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                LJgas2boxWRApp lJgas2boxWRApp = new LJgas2boxWRApp();
                LJgas2boxWRAppControl lJgas2boxWRAppControl = new LJgas2boxWRAppControl(lJgas2boxWRApp, (DrawingFrame)lJgas2boxWRApp.displayFrame, null);
                lJgas2boxWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        lJgas2boxWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                lJgas2boxWRAppControl.loadXML(xMLControlElement, true);
                lJgas2boxWRApp.customize();
                lJgas2boxWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LJgas2boxApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrame);
        this.addChildFrame(this.displayFrame);
    }

    public static void main(String[] stringArray) {
        LJgas2boxApp lJgas2boxApp = new LJgas2boxApp();
        SimulationControl simulationControl = SimulationControl.createApp(lJgas2boxApp, stringArray);
        simulationControl.addButton("reverse", "Reverse");
        lJgas2boxApp.customize();
    }
}

