/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.approach;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.approach.LJgas;
import org.opensourcephysics.stp.approach.LJgasWRApp;
import org.opensourcephysics.stp.approach.LJgasWRAppControl;

public class LJgasApp
extends AbstractSimulation {
    LJgas gas;
    PlotFrame plotFrame = new PlotFrame("time", "n1, n2, n3", "Number of particles in each cell");
    DisplayFrame displayFrame = new DisplayFrame("Particle positions");
    DrawingPanel displayPanel;

    public LJgasApp() {
        this.gas = new LJgas();
        this.displayPanel = this.displayFrame.getDrawingPanel();
        this.plotFrame.setMarkerColor(0, Color.blue);
        this.plotFrame.setMarkerColor(1, Color.black);
        this.plotFrame.setMarkerColor(2, Color.red);
        this.plotFrame.setXYColumnNames(0, "t", "left");
        this.plotFrame.setXYColumnNames(1, "t", "center");
        this.plotFrame.setXYColumnNames(2, "t", "right");
    }

    public void initialize() {
        this.displayPanel.addDrawable(this.gas);
        this.displayPanel.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.displayPanel.setAutoscaleX(true);
        this.displayPanel.setAutoscaleY(true);
        this.gas.numberOfParticles = this.control.getInt("N");
        this.gas.initialize();
        this.displayPanel.setPreferredMinMax(-0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength, -0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength);
    }

    public void doStep() {
        int n = 0;
        while (n < 10) {
            this.gas.step();
            ++n;
        }
        this.plotFrame.append(0, this.gas.t, this.gas.n0);
        this.plotFrame.append(1, this.gas.t, this.gas.n1);
        this.plotFrame.append(2, this.gas.t, this.gas.n2);
        this.gas.zeroAverages();
    }

    public void reset() {
        this.control.setValue("N", 270);
        this.initialize();
    }

    public void reverse() {
        this.gas.reverse();
        this.gas.zeroAverages();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = LJgasApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(LJgasApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                LJgasWRApp lJgasWRApp = new LJgasWRApp();
                LJgasWRAppControl lJgasWRAppControl = new LJgasWRAppControl(lJgasWRApp, (DrawingFrame)lJgasWRApp.displayFrame, null);
                lJgasWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        lJgasWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                lJgasWRAppControl.loadXML(xMLControlElement, true);
                lJgasWRApp.customize();
                lJgasWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LJgasApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrame);
        this.addChildFrame(this.displayFrame);
    }

    public static void main(String[] stringArray) {
        LJgasApp lJgasApp = new LJgasApp();
        SimulationControl simulationControl = SimulationControl.createApp(lJgasApp, stringArray);
        simulationControl.addButton("reverse", "Reverse");
        lJgasApp.customize();
    }
}

