/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.binomial;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.binomial.BinomialControl;
import org.opensourcephysics.stp.binomial.BinomialWRApp;
import org.opensourcephysics.stp.util.MyMath;

public class BinomialApp
extends AbstractCalculation {
    int N;
    double p;
    static final int MAXIMUM_NUMERATOR = 20;
    static final double tol = 1.0E-100;
    int counter = 0;
    double[] nbar = new double[100];
    PlotFrame plotFrame = new PlotFrame("n", "P", "P(n) versus n");
    PlotFrame plotFrameNorm = new PlotFrame("n/<n>", "P", "P(n) versus n/<n>");
    DatasetManager data = new DatasetManager();

    public BinomialApp() {
        this.plotFrame.setAutoscaleY(true);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrameNorm.setAutoscaleY(true);
        this.plotFrameNorm.setAutoscaleX(true);
    }

    public void addPoints() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        bl = this.N > 20;
        int n = 0;
        while (n <= this.N) {
            if (bl) {
                d = MyMath.stirling(this.N);
                d2 = MyMath.stirling(n);
                d3 = MyMath.stirling(this.N - n);
            } else {
                d = Math.log(MyMath.factorial((double)this.N));
                d2 = Math.log(MyMath.factorial((double)n));
                d3 = Math.log(MyMath.factorial((double)(this.N - n)));
            }
            double d4 = d - d2 - d3 + (double)n * Math.log(this.p) + (double)(this.N - n) * Math.log(1.0 - this.p);
            double d5 = Math.exp(d4);
            if (d5 > 1.0E-100) {
                this.data.append(this.counter, n, d5);
            }
            ++n;
        }
    }

    public void resetCalculation() {
        this.counter = 0;
        this.data.removeDatasets();
        this.plotFrame.removeDatasets();
        this.plotFrameNorm.removeDatasets();
        this.N = 60;
        this.p = 0.5;
        this.control.setValue("N", this.N);
        this.control.setValue("p", this.p);
    }

    public void calculate() {
        this.N = this.control.getInt("N");
        this.p = this.control.getDouble("p");
        this.addPoints();
        this.nbar[this.counter] = (double)this.N * this.p;
        this.plotFrame.clearData();
        this.plotFrameNorm.clearData();
        int n = 0;
        while (n <= this.counter) {
            double[] dArray = this.data.getXPoints(n);
            double[] dArray2 = this.data.getYPoints(n);
            int n2 = 0;
            while (n2 < dArray.length) {
                this.plotFrame.append(n, dArray[n2], dArray2[n2]);
                this.plotFrameNorm.append(n, dArray[n2] / this.nbar[n], dArray2[n2]);
                ++n2;
            }
            ++n;
        }
        this.plotFrame.setXYColumnNames(this.counter, "n", "P_" + this.counter + "[n]");
        this.plotFrameNorm.setXYColumnNames(this.counter, "n_norm", "P_" + this.counter + "[n]");
        ++this.counter;
    }

    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = BinomialApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(BinomialApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                BinomialWRApp binomialWRApp = new BinomialWRApp();
                BinomialControl binomialControl = new BinomialControl(binomialWRApp, binomialWRApp.plotFrame, null);
                binomialControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        binomialControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                binomialControl.loadXML(xMLControlElement, true);
                binomialWRApp.customize();
                binomialWRApp.resetCalculation();
                binomialWRApp.calculate();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BinomialApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrameNorm);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        BinomialApp binomialApp = new BinomialApp();
        CalculationControl.createApp(binomialApp, stringArray);
        binomialApp.customize();
    }
}

