/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.centralLimit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Histogram;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.stp.centralLimit.CentralAppControl;
import org.opensourcephysics.stp.centralLimit.CentralWRApp;

public class CentralApp
extends AbstractSimulation {
    int n;
    int trials;
    double x_accum;
    double x2_accum;
    double y_accum;
    double y2_accum;
    double variancex;
    double lambda = 1.0;
    DrawingFrame frame;
    PlottingPanel panel = new PlottingPanel("y", "P(y)", "");
    Histogram dist;
    String xDistribution;

    public CentralApp() {
        this.frame = new DrawingFrame("P(y)", this.panel);
        this.frame.setVisible(true);
        this.dist = new Histogram();
        this.dist.setNormalizedToOne(true);
        this.panel.addDrawable(this.dist);
        this.panel.setAutoscaleX(true);
        this.panel.setAutoscaleY(true);
        this.panel.limitAutoscaleX(0.0, 1.0);
        this.panel.limitAutoscaleY(0.0, 0.01);
    }

    public double sample_x_uniform() {
        return Math.random();
    }

    public double sample_x_exponential() {
        return -this.lambda * Math.log(1.0 - Math.random());
    }

    public double sample_x_lorentz() {
        return Math.tan(Math.PI * this.sample_x_uniform());
    }

    public double sample_y() {
        double d = 0.0;
        int n = 0;
        while (n < this.n) {
            double d2;
            if (this.xDistribution.equals("uniform")) {
                d2 = this.sample_x_uniform();
                this.x_accum += d2;
                this.x2_accum += d2 * d2;
                d += d2;
            } else if (this.xDistribution.equals("exponential")) {
                d2 = this.sample_x_exponential();
                this.x_accum += d2;
                this.x2_accum += d2 * d2;
                d += d2;
            } else if (this.xDistribution.equals("Lorentz")) {
                d2 = this.sample_x_lorentz();
                this.x_accum += d2;
                this.x2_accum += d2 * d2;
                d += d2;
            }
            ++n;
        }
        return d / (double)this.n;
    }

    public void doStep() {
        int n = 0;
        while (n < 100) {
            double d = this.sample_y();
            this.y_accum += d;
            this.y2_accum += d * d;
            ++this.trials;
            this.dist.append(d);
            ++n;
        }
        this.panel.setMessage("trials=" + this.trials);
        this.panel.render();
    }

    public void initialize() {
        this.dist.clear();
        this.frame.repaint();
        this.x_accum = 0.0;
        this.x2_accum = 0.0;
        this.y_accum = 0.0;
        this.y2_accum = 0.0;
        this.trials = 0;
        this.n = this.control.getInt("N");
        this.dist.setBinWidth(0.03 / Math.sqrt(this.n));
        this.xDistribution = this.control.getString("distribution");
        this.control.clearMessages();
    }

    public void reset() {
        this.control.setValue("N", 12);
        OSPCombo oSPCombo = new OSPCombo(new String[]{"uniform", "exponential", "Lorentz"}, 0);
        this.control.setValue("distribution", oSPCombo);
        this.initialize();
        this.enableStepsPerDisplay(true);
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        double d = this.x_accum / (double)(this.n * this.trials);
        double d2 = this.x2_accum / (double)(this.n * this.trials);
        double d3 = d2 - d * d;
        double d4 = this.y_accum / (double)this.trials;
        double d5 = this.y2_accum / (double)this.trials;
        double d6 = d5 - d4 * d4;
        d6 = d6 * (double)this.trials / (double)(this.trials - 1);
        this.control.println("trials = " + this.trials);
        if (this.xDistribution.equals("Lorentz")) {
            this.control.println("<x> = 0.0");
        } else {
            this.control.println("<x> =" + ControlUtils.f4(d) + " variance of x = " + ControlUtils.f4(d3));
        }
        this.control.println("<y> = " + ControlUtils.f2(d4));
        this.control.println("sample variance s\u00b2= " + ControlUtils.f4(d6));
        this.control.println();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = CentralApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(CentralApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                CentralWRApp centralWRApp = new CentralWRApp();
                CentralAppControl centralAppControl = new CentralAppControl(centralWRApp, centralWRApp.frame, null);
                centralAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        centralAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                centralAppControl.loadXML(xMLControlElement, true);
                centralWRApp.customize();
                centralAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CentralApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.frame);
    }

    public static void main(String[] stringArray) {
        CentralApp centralApp = new CentralApp();
        SimulationControl.createApp(centralApp, stringArray);
        centralApp.customize();
    }
}

