/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.centralLimit;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.centralLimit.CentralApp;
import org.opensourcephysics.stp.centralLimit.CentralAppControl;

public class CentralWRApp
extends CentralApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = CentralWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(CentralWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                CentralApp centralApp = new CentralApp();
                SimulationControl simulationControl = SimulationControl.createApp(centralApp);
                simulationControl.setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                simulationControl.setValue("model", null);
                centralApp.customize();
                centralApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void setParameter() {
        this.initialize();
        this.stopRunning();
        GUIUtils.repaintOSPFrames();
    }

    public void setDistribution() {
        if (this.control == null) {
            return;
        }
        this.initialize();
        this.stopRunning();
        GUIUtils.repaintOSPFrames();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        if (this.xDistribution.equals("l")) {
            ((EjsSimulationControl)this.control).getControl("meanX").setProperty("value", "0.0");
            ((EjsSimulationControl)this.control).getControl("devX2").setProperty("value", "");
        } else {
            ((EjsSimulationControl)this.control).getControl("meanX").setProperty("value", "0.5");
            ((EjsSimulationControl)this.control).getControl("devX2").setProperty("value", "");
        }
        if (this.trials < 2) {
            ((EjsSimulationControl)this.control).getControl("meanY").setProperty("value", "");
            ((EjsSimulationControl)this.control).getControl("s2").setProperty("value", "");
            return;
        }
        double d = this.y_accum / (double)this.trials;
        double d2 = this.y2_accum / (double)this.trials;
        double d3 = d2 - d * d;
        d3 = d3 * (double)this.trials / (double)(this.trials - 1);
        if (!this.xDistribution.equals("Lorentz")) {
            ((EjsSimulationControl)this.control).getControl("devX2").setProperty("value", ControlUtils.f4(this.variancex));
        }
        ((EjsSimulationControl)this.control).getControl("meanY").setProperty("value", ControlUtils.f3(d));
        ((EjsSimulationControl)this.control).getControl("s2").setProperty("value", ControlUtils.f4(d3));
    }

    public static void main(String[] stringArray) {
        CentralWRApp centralWRApp = new CentralWRApp();
        new CentralAppControl(centralWRApp, centralWRApp.frame, stringArray);
        centralWRApp.customize();
    }
}

