/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.demon.DemonWRApp;
import org.opensourcephysics.stp.demon.DemonWRAppControl;

public class DemonApp
extends AbstractSimulation {
    int N;
    int dimensions;
    int acceptedMoves = 0;
    int mcs = 0;
    double[][] v;
    double systemEnergy;
    double demonEnergy;
    double systemEnergyAccumulator = 0.0;
    double demonEnergyAccumulator = 0.0;
    double delta;
    double exponent;
    JButton logButton;
    NumberFormat nf;
    PlotFrame histogramFrame = new PlotFrame("Ed", "ln P(Ed)", "Demon Energy Distribution");
    HistogramFrame vhistogramFrame = new HistogramFrame("Vx", "Histogram", "Histogram of vx");
    double[] histogram;

    double[] offsetVelocity(double[] dArray) {
        double[] dArray2 = new double[this.dimensions];
        int n = 0;
        while (n < this.dimensions) {
            dArray2[n] = dArray[n] + (2.0 * Math.random() - 1.0) * this.delta;
            ++n;
        }
        return dArray2;
    }

    double getSpeed(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.dimensions) {
            d += dArray[n] * dArray[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public void doStep() {
        int n = 0;
        while (n < 10000 / this.N) {
            int n2 = 0;
            while (n2 < this.N) {
                int n3 = (int)(Math.random() * (double)this.N);
                double[] dArray = this.v[n3];
                double[] dArray2 = this.offsetVelocity(dArray);
                double d = Math.pow(this.getSpeed(dArray2), this.exponent) - Math.pow(this.getSpeed(dArray), this.exponent);
                if (d <= this.demonEnergy) {
                    this.v[n3] = dArray2;
                    ++this.acceptedMoves;
                    this.systemEnergy += d;
                    this.demonEnergy -= d;
                }
                this.systemEnergyAccumulator += this.systemEnergy;
                this.demonEnergyAccumulator += this.demonEnergy;
                int n4 = (int)this.demonEnergy;
                this.histogram[n4] = this.histogram[n4] + 1.0;
                this.vhistogramFrame.append(this.v[n2][0]);
                ++n2;
            }
            this.histogramFrame.clearData();
            ++this.mcs;
            n2 = 0;
            while (n2 < (int)this.systemEnergy + 1) {
                if (this.histogram[n2] > 0.0) {
                    this.histogramFrame.append(0, n2, Math.log(1.0 * this.histogram[n2] / (double)(this.mcs * this.N)));
                }
                ++n2;
            }
            ++n;
        }
    }

    public void stopRunning() {
        double d = this.mcs * this.N > 0 ? 1.0 / (double)(this.mcs * this.N) : 0.0;
        this.control.println("mcs = " + this.nf.format(this.mcs));
        this.control.println("<Ed> = " + this.nf.format(this.demonEnergyAccumulator * d));
        this.control.println("<E> = " + this.nf.format(this.systemEnergyAccumulator * d));
        this.control.println("acceptance ratio = " + this.nf.format((double)this.acceptedMoves * d));
        this.control.println();
    }

    public void initialize() {
        this.N = this.control.getInt("N");
        this.dimensions = Math.min(this.control.getInt("dimension"), 3);
        this.control.setValue("dimension", this.dimensions);
        this.systemEnergy = this.control.getDouble("system energy");
        this.delta = 0.1;
        this.exponent = this.control.getDouble("momentum exponent");
        this.v = new double[this.N][this.dimensions];
        double d = Math.pow(this.systemEnergy / (double)this.N, 1.0 / this.exponent);
        int n = 0;
        while (n < this.N) {
            this.v[n][0] = d;
            this.vhistogramFrame.append(d);
            ++n;
        }
        this.histogram = new double[(int)this.systemEnergy + 1];
        this.demonEnergy = 0.0;
        this.mcs = 0;
        this.systemEnergyAccumulator = 0.0;
        this.demonEnergyAccumulator = 0.0;
        this.acceptedMoves = 0;
        this.control.clearMessages();
    }

    public void reset() {
        this.control.setValue("N", 40);
        this.control.setValue("dimension", 3);
        this.control.setValue("system energy", 40);
        this.control.setValue("momentum exponent", "2");
        this.control.clearMessages();
        this.histogramFrame.clearData();
        this.vhistogramFrame.clearData();
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.mcs = 0;
        this.systemEnergyAccumulator = 0.0;
        this.demonEnergyAccumulator = 0.0;
        this.acceptedMoves = 0;
        this.histogramFrame.clearData();
        this.histogramFrame.repaint();
        this.control.clearMessages();
        this.stopRunning();
    }

    public DemonApp() {
        this.vhistogramFrame.setBinWidth(0.1);
        this.vhistogramFrame.setPreferredMinMaxX(-5.0, 5.0);
        this.histogramFrame.setAutoscaleY(true);
        this.histogramFrame.setAutoscaleX(true);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = DemonApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(DemonApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                DemonWRApp demonWRApp = new DemonWRApp();
                DemonWRAppControl demonWRAppControl = new DemonWRAppControl(demonWRApp, (DrawingFrame)demonWRApp.histogramFrame, null);
                demonWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        demonWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                demonWRAppControl.loadXML(xMLControlElement, true);
                demonWRApp.customize();
                demonWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DemonApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.histogramFrame);
        this.addChildFrame(this.vhistogramFrame);
    }

    public static void main(String[] stringArray) {
        DemonApp demonApp = new DemonApp();
        SimulationControl simulationControl = SimulationControl.createApp(demonApp, stringArray);
        simulationControl.addButton("zeroAverages", "Zero averages");
        demonApp.customize();
    }
}

