/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.demon.DemonApp;
import org.opensourcephysics.stp.demon.DemonWRAppControl;

public class DemonWRApp
extends DemonApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = DemonWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(DemonWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                DemonApp demonApp = new DemonApp();
                SimulationControl simulationControl = SimulationControl.createApp(demonApp);
                simulationControl.setDefaultCloseOperation(n);
                simulationControl.addButton("zeroAverages", "Zero averages");
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                simulationControl.setValue("model", null);
                demonApp.customize();
                demonApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        double d = this.mcs * this.N > 0 ? 1.0 / (double)(this.mcs * this.N) : 0.0;
        String string = this.nf.format(this.demonEnergyAccumulator * d);
        String string2 = this.nf.format(this.systemEnergyAccumulator * d);
        String string3 = this.nf.format((double)this.acceptedMoves * d);
        ((EjsSimulationControl)this.control).getControl("mcsNumber").setProperty("value", "" + this.mcs);
        ((EjsSimulationControl)this.control).getControl("edNumber").setProperty("value", string);
        ((EjsSimulationControl)this.control).getControl("eNumber").setProperty("value", string2);
        ((EjsSimulationControl)this.control).getControl("ratio").setProperty("value", string3);
    }

    public void zeroAverages() {
        this.mcs = 0;
        this.systemEnergyAccumulator = 0.0;
        this.demonEnergyAccumulator = 0.0;
        this.acceptedMoves = 0;
        this.histogramFrame.clearData();
        this.histogramFrame.repaint();
        if (this.control == null) {
            return;
        }
        ((EjsSimulationControl)this.control).getControl("mcsNumber").setProperty("value", "");
        ((EjsSimulationControl)this.control).getControl("edNumber").setProperty("value", "");
        ((EjsSimulationControl)this.control).getControl("eNumber").setProperty("value", "");
        ((EjsSimulationControl)this.control).getControl("ratio").setProperty("value", "");
    }

    public void setParameter() {
        this.zeroAverages();
        this.histogramFrame.clearData();
        this.vhistogramFrame.clearData();
        this.initialize();
        GUIUtils.repaintOSPFrames();
    }

    public static void main(String[] stringArray) {
        DemonWRApp demonWRApp = new DemonWRApp();
        new DemonWRAppControl(demonWRApp, (DrawingFrame)demonWRApp.histogramFrame, stringArray);
        demonWRApp.customize();
    }
}

