/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.demon.demonlattice;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.demon.demonlattice.ChemicalDemon;

public class ChemicalDemonApp
extends AbstractSimulation {
    ChemicalDemon demon = new ChemicalDemon();
    PlotFrame ePlot = new PlotFrame("E", "ln (P(E))", "Demon Energy distribution");
    PlotFrame nPlot = new PlotFrame("N", "ln (P(N))", "Demon Number distribution");
    DisplayFrame display = new DisplayFrame("x", "p", "Phase Space Lattice");

    public void initialize() {
        this.demon.N = this.control.getInt("N");
        this.demon.L = this.control.getInt("L");
        this.demon.pmax = this.control.getInt("p_max");
        this.demon.E = this.control.getInt("E");
        this.demon.hc = this.control.getInt("hard core (set to 1 for hard core)");
        this.demon.well = this.control.getInt("attractive well depth");
        this.demon.initialize();
        this.display.addDrawable(this.demon);
        this.display.setSquareAspect(false);
        this.display.setPreferredMinMax(0.0, this.demon.L, -this.demon.Lp / 2, this.demon.Lp / 2);
        this.nPlot.setPreferredMinMaxX(0.0, 1.0);
        this.nPlot.setAutoscaleX(true);
    }

    public void stop() {
        this.demon.averages();
        this.control.println("mcs = " + this.demon.mcs);
        this.control.println("Mean demon energy = " + ControlUtils.f2(this.demon.eave) + ",  Mean demon particle number = " + ControlUtils.f2(this.demon.nave));
        this.control.println("Mean system energy = " + ControlUtils.f2(this.demon.Eave) + ",  Mean system particle number= " + ControlUtils.f2(this.demon.Nave));
        this.control.println("acceptance ratio = " + ControlUtils.f4(1.0 * (double)this.demon.accept / (double)this.demon.steps));
    }

    public void reset() {
        this.control.setValue("N", 100);
        this.control.setValue("L", 100);
        this.control.setValue("p_max", 10);
        this.control.setValue("E", 200);
        this.control.setValue("hard core (set to 1 for hard core)", 0);
        this.control.setValue("attractive well depth", 0);
        this.control.setAdjustableValue("E for P(N,E)", 1);
        this.control.setAdjustableValue("N for P(N,E)", 1);
        this.control.setAdjustableValue("steps per display", 10);
    }

    public void doStep() {
        int n = this.control.getInt("steps per display");
        int n2 = 0;
        while (n2 < n) {
            this.demon.demonStep();
            ++n2;
        }
        this.display.setMessage("mcs = " + this.demon.mcs);
    }

    public void calculate() {
        this.ePlot.clearData();
        this.nPlot.clearData();
        int n = this.control.getInt("E for P(N,E)");
        int n2 = this.control.getInt("N for P(N,E)");
        int n3 = 0;
        while (n3 < this.demon.arraySize) {
            if (this.demon.p[n3][n2] > 0) {
                this.ePlot.append(0, n3, Math.log((double)this.demon.p[n3][n2] * 1.0 / (double)this.demon.steps));
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.demon.arraySize) {
            if (this.demon.p[n][n3] > 0) {
                this.nPlot.append(0, n3, Math.log((double)this.demon.p[n][n3] * 1.0 / (double)this.demon.steps));
            }
            ++n3;
        }
        this.ePlot.render();
        this.nPlot.render();
    }

    public void resetAverages() {
        this.demon.reset();
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new ChemicalDemonApp());
        simulationControl.addButton("calculate", "Plot Demon Distributions");
        simulationControl.addButton("resetAverages", "Reset Averages");
    }
}

