/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.diffusion;

import java.awt.Graphics;
import java.util.Random;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.BinaryLattice;

public class LatticeGas
implements Drawable {
    int L;
    double L_2;
    int N;
    final int OCCUPIED = 1;
    final int EMPTY = 0;
    int[][] site;
    int[] x;
    int[] y;
    int[] x0;
    int[] y0;
    int[] wrapX;
    int[] wrapY;
    Random random;
    int xposition;
    int yposition;
    double R2bar;
    double t;
    BinaryLattice lattice;

    public void initialize(int n, int n2) {
        this.L = n;
        this.N = n2;
        this.lattice = new BinaryLattice(n, n);
        this.site = new int[n][n];
        this.x = new int[n2];
        this.y = new int[n2];
        this.x0 = new int[n2];
        this.y0 = new int[n2];
        this.wrapX = new int[n2];
        this.wrapY = new int[n2];
        this.L_2 = 0.5 * (double)n;
        this.random = new Random(System.currentTimeMillis());
    }

    public void fillLattice() {
        int n = 0;
        while (n < this.N) {
            int n2;
            int n3 = (int)((double)this.L * this.random.nextDouble());
            if (this.site[n3][n2 = (int)((double)this.L * this.random.nextDouble())] != 0) continue;
            this.site[n3][n2] = 1;
            this.x[n] = n3;
            this.y[n] = n2;
            this.x0[n] = this.x[n];
            this.y0[n] = this.y[n];
            ++n;
        }
    }

    public void move() {
        int[] nArray = new int[2];
        int n = 0;
        while (n < this.N) {
            int n2 = (int)((double)this.N * this.random.nextDouble());
            this.xposition = this.x[n2];
            this.yposition = this.y[n2];
            this.chooseDirection(nArray);
            if (this.site[this.xposition][this.yposition] == 0) {
                this.site[this.x[n2]][this.y[n2]] = 0;
                this.x[n2] = this.xposition;
                this.y[n2] = this.yposition;
                int n3 = n2;
                this.wrapX[n3] = this.wrapX[n3] + nArray[0];
                int n4 = n2;
                this.wrapY[n4] = this.wrapY[n4] + nArray[1];
                this.site[this.x[n2]][this.y[n2]] = 1;
            }
            ++n;
        }
    }

    public static int sgn(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    void chooseDirection(int[] nArray) {
        nArray[0] = 0;
        nArray[1] = 0;
        int n = (int)(4.0 * this.random.nextDouble()) + 1;
        switch (n) {
            case 1: {
                ++this.xposition;
                if (this.xposition < this.L) break;
                this.xposition = 0;
                nArray[0] = this.L;
                break;
            }
            case 2: {
                --this.xposition;
                if (this.xposition >= 0) break;
                this.xposition = this.L - 1;
                nArray[0] = -this.L;
                break;
            }
            case 3: {
                ++this.yposition;
                if (this.yposition < this.L) break;
                this.yposition = 0;
                nArray[1] = this.L;
                break;
            }
            case 4: {
                --this.yposition;
                if (this.yposition >= 0) break;
                this.yposition = this.L - 1;
                nArray[1] = -this.L;
            }
        }
    }

    double computeR2Bar() {
        double d = 0.0;
        int n = 0;
        while (n < this.N) {
            double d2 = this.x[n] - this.x0[n] + this.wrapX[n];
            double d3 = this.y[n] - this.y0[n] + this.wrapY[n];
            d += d2 * d2 + d3 * d3;
            ++n;
        }
        this.R2bar = d / (double)this.N;
        return this.R2bar;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.lattice == null) {
            return;
        }
        this.lattice.setBlock(0, 0, this.site);
        this.lattice.draw(drawingPanel, graphics);
    }
}

