/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.einsteinsolid;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.einsteinsolid.EinsteinSolidControl;
import org.opensourcephysics.stp.einsteinsolid.EinsteinSolidWRApp;

public class EinsteinSolidApp
extends AbstractCalculation {
    int Ea;
    int Eb;
    int Na;
    int Nb;
    PlotFrame plotFrame = new PlotFrame("Ea", "P(Ea)", "Probability");
    NumberFormat numberFormat = NumberFormat.getInstance();
    int datasetCounter = 0;

    public EinsteinSolidApp() {
        this.numberFormat.setMaximumFractionDigits(4);
        this.plotFrame.setAutoclear(false);
    }

    public double binom(int n, int n2) {
        double d = 1.0;
        int n3 = n;
        int n4 = n2;
        while (n3 >= n - n2 + 1 && n4 >= 1) {
            d *= (double)n3;
            d /= (double)n4;
            --n4;
            --n3;
        }
        return d;
    }

    public void addPoints() {
        int n = this.Ea + this.Eb;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        double d = 0.0;
        int n2 = 0;
        while (n2 <= n) {
            dArray[n2] = this.binom(n2 + this.Na - 1, n2);
            dArray2[n2] = this.binom(n - n2 + this.Nb - 1, n - n2);
            d += dArray[n2] * dArray2[n2];
            ++n2;
        }
        this.plotFrame.setPreferredMinMaxX(0.0, n);
        double d2 = 0.0;
        int n3 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 <= n) {
            double d5 = dArray[n4] * dArray2[n4] / d;
            if (n4 < this.Ea) {
                d4 += d5;
            }
            if (d5 > d2) {
                d2 = d5;
                n3 = n4;
            }
            d3 += (double)n4 * d5;
            this.plotFrame.append(this.datasetCounter, n4, d5);
            String[] stringArray = new String[]{this.numberFormat.format(n4), this.numberFormat.format(d5)};
            ++n4;
        }
        this.outputResult(n3, d3, d4);
    }

    void outputResult(double d, double d2, double d3) {
        this.control.println("Initial \u03a9a = " + this.binom(this.Ea + this.Na - 1, this.Ea) + "\t \u03a9b = " + this.binom(this.Eb + this.Nb - 1, this.Eb));
        this.control.println("Most probable Ea = " + this.numberFormat.format(d));
        this.control.println("<Ea> = " + this.numberFormat.format(d2));
        this.control.println("P a to b = " + this.numberFormat.format(d3));
        this.control.println();
    }

    public void resetCalculation() {
        this.plotFrame.removeDatasets();
        this.datasetCounter = 0;
        this.Ea = 10;
        this.Eb = 2;
        this.Na = 4;
        this.Nb = 4;
        this.control.setValue("initial Ea", this.Ea);
        this.control.setValue("initial Eb", this.Eb);
        this.control.setValue("Na", this.Na);
        this.control.setValue("Nb", this.Nb);
        this.control.clearMessages();
    }

    public void calculate() {
        this.Ea = this.control.getInt("initial Ea");
        this.Eb = this.control.getInt("initial Eb");
        this.Na = this.control.getInt("Na");
        this.Nb = this.control.getInt("Nb");
        this.addPoints();
        this.plotFrame.setXYColumnNames(this.datasetCounter, "E_a", "P_" + this.datasetCounter);
        ++this.datasetCounter;
    }

    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = EinsteinSolidApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(EinsteinSolidApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                EinsteinSolidWRApp einsteinSolidWRApp = new EinsteinSolidWRApp();
                EinsteinSolidControl einsteinSolidControl = new EinsteinSolidControl(einsteinSolidWRApp, einsteinSolidWRApp.plotFrame, null);
                einsteinSolidControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        einsteinSolidControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                einsteinSolidControl.loadXML(xMLControlElement, true);
                einsteinSolidWRApp.customize();
                einsteinSolidWRApp.resetCalculation();
                einsteinSolidWRApp.calculate();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EinsteinSolidApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        EinsteinSolidApp einsteinSolidApp = new EinsteinSolidApp();
        CalculationControl.createApp(einsteinSolidApp, stringArray);
        einsteinSolidApp.customize();
    }
}

