/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.einsteinsolid;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.einsteinsolid.EinsteinsolidMCControl;
import org.opensourcephysics.stp.einsteinsolid.EinsteinsolidMCWRApp;

public class EinsteinsolidMCApp
extends AbstractSimulation {
    int N;
    int acceptedMoves = 0;
    int mcs = 0;
    int[] e;
    double systemEnergy;
    double systemEnergyAccumulator = 0.0;
    double systemEnergyAccumulator2 = 0.0;
    double[] Ea;
    double[] Ca;
    double[] Ta;
    int npoints = 0;
    double tolerance = 0.01;
    static final int nmaxTrials = 1000;
    static final int nequil = 10000;
    double T;
    NumberFormat nf;
    Random rnd = new Random();
    PlotFrame plotFrame = new PlotFrame("mcs", "E", "E");
    PlotFrame ETFrame = new PlotFrame("T", "E", "E .vs. T");
    PlotFrame CTFrame = new PlotFrame("T", "C", "C .vs. T");

    public EinsteinsolidMCApp() {
        this.Ea = new double[1000];
        this.Ca = new double[1000];
        this.Ta = new double[1000];
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
        this.ETFrame.setMarkerColor(0, Color.RED);
        this.CTFrame.setMarkerColor(0, Color.RED);
    }

    public void doStep() {
        this.T = this.control.getDouble("T");
        int n = 0;
        while (n < 10000 / this.N) {
            int n2 = 0;
            while (n2 < this.N) {
                int n3 = (int)(Math.random() * (double)this.N);
                int n4 = 2 * this.rnd.nextInt(2) - 1;
                if (n4 == 1 && this.rnd.nextDouble() < Math.exp((double)(-n4) / this.T) || n4 == -1 && this.e[n3] > 0) {
                    ++this.acceptedMoves;
                    int n5 = n3;
                    this.e[n5] = this.e[n5] + n4;
                    this.systemEnergy += (double)n4;
                }
                if (this.mcs > 10000) {
                    this.systemEnergyAccumulator += this.systemEnergy;
                    this.systemEnergyAccumulator2 += this.systemEnergy * this.systemEnergy;
                }
                ++n2;
            }
            ++this.mcs;
            ++n;
        }
        if (this.mcs < 10000) {
            return;
        }
        this.plotFrame.append(0, this.mcs, this.meanE());
    }

    public void stopRunning() {
        double d = this.mcs * this.N > 0 ? 1.0 / (double)(this.mcs * this.N) : 0.0;
        this.control.println("mcs = " + this.nf.format(this.mcs));
        this.control.println("<E> = " + this.nf.format(this.meanE()));
        this.control.println("C = " + this.nf.format(this.heatCapacity()));
        this.control.println("acceptance ratio = " + this.nf.format((double)this.acceptedMoves * d));
        this.control.println();
    }

    public void initialize() {
        this.N = this.control.getInt("N");
        this.T = this.control.getDouble("T");
        this.e = new int[this.N];
        int n = 0;
        while (n < this.N) {
            this.e[n] = 1;
            ++n;
        }
        this.clearEnergies();
        this.mcs = 0;
        this.acceptedMoves = 0;
        this.plotFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.ETFrame.setPreferredMinMaxX(0.0, 10.0);
        this.CTFrame.setPreferredMinMaxX(0.0, 10.0);
        this.ETFrame.setAutoscaleX(true);
        this.CTFrame.setAutoscaleX(true);
        this.ETFrame.setPreferredMinMaxY(0.0, 10.0);
        this.CTFrame.setPreferredMinMaxY(0.0, 10.0);
        this.ETFrame.setAutoscaleY(true);
        this.CTFrame.setAutoscaleY(true);
        this.delayTime = 0;
        this.control.clearMessages();
        this.stopRunning();
    }

    public void clearEnergies() {
        this.systemEnergy = 0.0;
        int n = 0;
        while (n < this.N) {
            this.systemEnergy += (double)this.e[n];
            ++n;
        }
        this.systemEnergyAccumulator = 0.0;
        this.systemEnergyAccumulator2 = 0.0;
    }

    public void reset() {
        this.control.setValue("N", 20);
        this.control.setAdjustableValue("T", 2.0);
        this.control.clearMessages();
    }

    public void acceptResults() {
        this.Ea[this.npoints] = this.meanE();
        this.Ca[this.npoints] = this.heatCapacity();
        this.Ta[this.npoints] = this.T;
        ++this.npoints;
        if (this.npoints > 1000) {
            this.control.print("Too many points");
            System.exit(-1);
        }
        this.plot();
        this.clearEnergies();
        this.mcs = 0;
        this.acceptedMoves = 0;
        this.plotFrame.clearData();
        this.plotFrame.repaint();
    }

    public double meanE() {
        double d = 1.0 / (double)((this.mcs - 10000) * this.N);
        return this.systemEnergyAccumulator * d;
    }

    public double heatCapacity() {
        double d = 1.0 / (double)((this.mcs - 10000) * this.N);
        double d2 = this.systemEnergyAccumulator * this.systemEnergyAccumulator;
        return (this.systemEnergyAccumulator2 * d - d2 * d * d) / this.T / this.T;
    }

    public void plot() {
        int n = 0;
        while (n < this.npoints) {
            this.ETFrame.append(0, this.Ta[n], this.Ea[n]);
            this.CTFrame.append(0, this.Ta[n], this.Ca[n]);
            ++n;
        }
        this.ETFrame.render();
        this.CTFrame.render();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = EinsteinsolidMCApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(EinsteinsolidMCApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                EinsteinsolidMCWRApp einsteinsolidMCWRApp = new EinsteinsolidMCWRApp();
                EinsteinsolidMCControl einsteinsolidMCControl = new EinsteinsolidMCControl(einsteinsolidMCWRApp, (DrawingFrame)einsteinsolidMCWRApp.plotFrame, null);
                einsteinsolidMCControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        einsteinsolidMCControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                einsteinsolidMCControl.loadXML(xMLControlElement, true);
                einsteinsolidMCWRApp.customize();
                einsteinsolidMCControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EinsteinsolidMCApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrame);
        this.addChildFrame(this.ETFrame);
        this.addChildFrame(this.CTFrame);
    }

    public static void main(String[] stringArray) {
        EinsteinsolidMCApp einsteinsolidMCApp = new EinsteinsolidMCApp();
        SimulationControl simulationControl = SimulationControl.createApp(einsteinsolidMCApp, stringArray);
        simulationControl.addButton("acceptResults", "Accept E and C");
        einsteinsolidMCApp.customize();
    }
}

