/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.estimation;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.stp.estimation.MonteCarloEstimationControl;
import org.opensourcephysics.stp.estimation.MonteCarloEstimationWRApp;

public class MonteCarloEstimationApp
extends AbstractCalculation {
    Random rng = new Random();
    int n;
    long seed;
    Function function = new MyFunction();
    PlotFrame plotFrame = new PlotFrame("x", "y", "Monte Carlo Estimation hits / misses");
    FunctionDrawer functionDrawer = new FunctionDrawer(this.function);
    double ymax = 1.0;
    double a = 0.0;
    double b = 1.0;

    public MonteCarloEstimationApp() {
        this.functionDrawer.initialize(0.0, 1.0, 1000, false);
        this.plotFrame.setMarkerColor(0, Color.blue);
        this.plotFrame.setMarkerColor(1, Color.red);
        this.plotFrame.addDrawable(this.functionDrawer);
    }

    public void calculate() {
        this.plotFrame.clearData();
        this.n = this.control.getInt("n");
        try {
            this.seed = Long.parseLong(this.control.getString("seed"));
        }
        catch (Exception exception) {
            this.control.setValue("seed", String.valueOf(System.currentTimeMillis()));
            this.seed = Long.parseLong(this.control.getString("seed"));
        }
        this.rng.setSeed(this.seed);
        long l = 0L;
        int n = 0;
        while (n < this.n) {
            double d = this.rng.nextDouble() * (this.b - this.a);
            double d2 = this.rng.nextDouble() * this.ymax;
            if (d2 <= this.function.evaluate(d)) {
                ++l;
                this.plotFrame.append(0, d, d2);
            } else {
                this.plotFrame.append(1, d, d2);
            }
            ++n;
        }
        this.displayArea(l);
    }

    public void displayArea(long l) {
        double d = (double)l * (this.b - this.a) * this.ymax / (double)this.n;
        this.control.println("estimated area = " + d);
    }

    public void resetCalculation() {
        this.control.setValue("n", 1000);
        this.control.setValue("seed", String.valueOf(System.currentTimeMillis()));
        this.plotFrame.clearData();
        this.control.clearMessages();
        this.calculate();
    }

    public void switchGUI() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = MonteCarloEstimationApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(MonteCarloEstimationApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                MonteCarloEstimationWRApp monteCarloEstimationWRApp = new MonteCarloEstimationWRApp();
                MonteCarloEstimationControl monteCarloEstimationControl = new MonteCarloEstimationControl(monteCarloEstimationWRApp, (DrawingFrame)monteCarloEstimationWRApp.plotFrame, null);
                monteCarloEstimationControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        monteCarloEstimationControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                monteCarloEstimationControl.loadXML(xMLControlElement, true);
                monteCarloEstimationWRApp.customize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MonteCarloEstimationApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        MonteCarloEstimationApp monteCarloEstimationApp = new MonteCarloEstimationApp();
        CalculationControl.createApp(monteCarloEstimationApp, stringArray);
        monteCarloEstimationApp.customize();
    }

    private static class MyFunction
    implements Function {
        private MyFunction() {
        }

        public double evaluate(double d) {
            return 1.0 - d * d < 0.0 ? 0.0 : Math.sqrt(1.0 - d * d);
        }
    }
}

