/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.extremeValue;

import java.awt.Color;
import java.util.Arrays;
import java.util.Random;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.HistogramDataset;
import org.opensourcephysics.frames.PlotFrame;

public class ExtremeValueApp
extends AbstractCalculation {
    Random random;
    PlotFrame distributions = new PlotFrame("x", "H(x)", "Histogram");
    Dataset gaussian = new HistogramDataset(0.0, 1.0, 0.001);
    Dataset LEV = new HistogramDataset(0.0, 1.0, 0.001);
    Dataset GEV = new HistogramDataset(0.0, 1.0, 0.001);
    int numberOfSamples;
    int numberOfTrials;

    public ExtremeValueApp() {
        this.random = new Random(System.currentTimeMillis());
        this.LEV.setMarkerColor(Color.red);
        this.GEV.setMarkerColor(Color.green);
        this.gaussian.setMarkerColor(Color.blue);
    }

    public void calculate() {
        this.numberOfSamples = this.control.getInt("number of samples");
        this.numberOfTrials = this.control.getInt("number of trials");
        double[] dArray = new double[this.numberOfSamples];
        double d = 0.0;
        this.clearData();
        int n = 0;
        while (n < this.numberOfTrials) {
            int n2 = 0;
            while (n2 < this.numberOfSamples) {
                dArray[n2] = this.random.nextDouble();
                d += dArray[n2];
                ++n2;
            }
            Arrays.sort(dArray);
            this.LEV.append(dArray[0], 1.0);
            this.GEV.append(dArray[this.numberOfSamples - 1], 1.0);
            this.gaussian.append(d /= (double)this.numberOfSamples, 1.0);
            ++n;
        }
        this.distributions.addDrawable(this.LEV);
        this.distributions.addDrawable(this.GEV);
        this.distributions.addDrawable(this.gaussian);
    }

    public void reset() {
        this.control.setValue("number of samples", 10);
        this.control.setValue("number of trials", 1000000);
        this.control.clearMessages();
        this.clearData();
    }

    public void clearData() {
        this.LEV.clear();
        this.GEV.clear();
        this.gaussian.clear();
        this.distributions.clearData();
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new ExtremeValueApp(), stringArray);
    }
}

