/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.fpu;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.stp.fpu.Metric;

public class FPU
implements Drawable,
ODE {
    public double[] state;
    public double[] ax;
    int N;
    double dt;
    double stiffness = 1.0;
    double spacing = 1.0;
    double alpha;
    double beta;
    ODEMultistepSolver odeSolver = new ODEMultistepSolver(this);
    double[] Ek;
    double[] pe;
    Random rnd;
    double t = 0.0;
    double E = 0.0;
    double KE = 0.0;
    double PE = 0.0;
    double L;
    int R = 1;
    Metric peMetric;

    public void initialize(int n, int n2, double d, double d2, double d3, double d4) {
        this.N = n;
        this.state = new double[1 + 2 * this.N];
        this.ax = new double[this.N];
        this.L = (double)this.N * this.spacing;
        this.R = 1;
        this.alpha = d;
        this.beta = d2;
        this.dt = d3;
        this.stiffness /= 1.0 * (double)this.R;
        this.beta /= 1.0 * (double)this.R;
        this.peMetric = new Metric(n);
        this.Ek = new double[this.N];
        this.pe = new double[this.N];
        this.odeSolver.setTolerance(1.0E-5);
        this.odeSolver.initialize(this.dt);
        this.rnd = new Random(1L);
        this.initMode(n2, d4);
    }

    public void initRadom(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.N) {
            double d3;
            this.state[2 * n + 1] = d3 = this.rnd.nextDouble() - 0.5;
            d2 += d3;
            ++n;
        }
        d2 /= (double)this.N;
        n = 0;
        while (n < this.N) {
            int n2 = 2 * n + 1;
            this.state[n2] = this.state[n2] - d2;
            ++n;
        }
        double d4 = this.getE();
        double d5 = Math.sqrt(d / (d4 /= (double)this.N));
        int n3 = 0;
        while (n3 < this.N) {
            int n4 = 2 * n3 + 1;
            this.state[n4] = this.state[n4] * d5;
            ++n3;
        }
    }

    public void initMode(int n, double d) {
        double d2 = Math.PI;
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.N) {
                this.state[2 * n2] = 0.0;
                ++n2;
            }
            this.initRadom(d);
        } else {
            int n3 = 0;
            while (n3 < this.N) {
                this.state[2 * n3] = Math.sin(d2 * (double)n * (double)n3 / (double)(this.N - 1));
                ++n3;
            }
            this.initRadom(0.0);
        }
    }

    public void doStep() {
        this.odeSolver.step();
        this.t = this.state[2 * this.N];
        this.getE();
        this.peMetric.append(this.pe);
    }

    public void getRate(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.computeAcceleration(dArray);
        int n = 0;
        while (n < this.N) {
            dArray2[2 * n] = dArray[2 * n + 1];
            dArray2[2 * n + 1] = dArray3[n];
            ++n;
        }
        dArray2[2 * this.N] = 1.0;
    }

    public double[] computeAcceleration(double[] dArray) {
        int n = 0;
        while (n < this.N) {
            this.ax[n] = 0.0;
            ++n;
        }
        n = 0;
        while (n < this.N - 1) {
            int n2 = 1;
            while (n2 < this.R + 1) {
                int n3 = n + n2;
                double d = dArray[2 * n3] - dArray[2 * n];
                double d2 = this.force(d);
                int n4 = n;
                this.ax[n4] = this.ax[n4] + d2;
                int n5 = n3;
                this.ax[n5] = this.ax[n5] - d2;
                ++n2;
            }
            ++n;
        }
        this.ax[this.N - 1] = 0.0;
        this.ax[0] = 0.0;
        return this.ax;
    }

    public double[] getState() {
        return this.state;
    }

    public void getEnergy() {
        int n = 1;
        while (n < this.N - 1) {
            this.Ek[n] = this.getEnergy(n);
            ++n;
        }
    }

    public double getEnergy(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.PI;
        int n2 = this.N - 2;
        int n3 = 1;
        while (n3 <= n2) {
            d += this.state[2 * n3] * Math.sin(d3 * (double)n * (double)n3 / (double)(this.N - 1));
            d2 += this.state[2 * n3 + 1] * Math.sin(d3 * (double)n * (double)n3 / (double)(this.N - 1));
            ++n3;
        }
        return 0.5 * ((d *= 2.0 * Math.sin(d3 * (double)n / 2.0 / (double)(n2 + 1))) * d + d2 * d2) * 2.0 / (double)(this.N - 1);
    }

    public double getE() {
        int n = 0;
        while (n < this.N) {
            this.pe[n] = 0.0;
            ++n;
        }
        n = 0;
        while (n < this.N - 1) {
            int n2 = 1;
            while (n2 < this.R + 1) {
                int n3 = n + n2;
                double d = this.state[2 * n3] - this.state[2 * n];
                double d2 = this.potential(d);
                int n4 = n;
                this.pe[n4] = this.pe[n4] + (d2 *= 0.5);
                int n5 = n3;
                this.pe[n5] = this.pe[n5] + d2;
                ++n2;
            }
            ++n;
        }
        this.E = 0.0;
        this.KE = 0.0;
        this.PE = 0.0;
        n = 0;
        while (n < this.N) {
            double d = 0.5 * this.state[2 * n + 1] * this.state[2 * n + 1];
            this.KE += d;
            this.PE += this.pe[n];
            ++n;
        }
        this.E = this.KE + this.PE;
        return this.E;
    }

    public void checkE() {
        this.getEnergy();
        double d = 0.0;
        int n = 1;
        while (n < this.N - 1) {
            d += this.Ek[n];
            ++n;
        }
        System.out.println(String.valueOf(d) + "\t" + this.getE());
    }

    public double setZeroMetric() {
        this.peMetric.reset();
        this.getE();
        this.peMetric.append(this.pe);
        double d = this.peMetric.metric;
        this.peMetric.setM0(d);
        return d;
    }

    public double force(double d) {
        return this.stiffness * d + this.alpha * d * d + this.beta * d * d * d;
    }

    public double potential(double d) {
        return 0.5 * this.stiffness * d * d + 0.3333333333333333 * d * d * d + 0.25 * this.beta * d * d * d * d;
    }

    public void resetMetric() {
        this.peMetric.reset();
        this.setZeroMetric();
        this.peMetric.zeroData();
        this.peMetric.counter = 0;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        graphics.setColor(Color.red);
        double d = this.L / (double)this.N;
        int n = (int)d;
        int n2 = (int)d;
        int n3 = 0;
        while (n3 < this.N) {
            int n4 = drawingPanel.xToPix((double)n3 * d);
            int n5 = drawingPanel.xToPix(4.0 * this.state[2 * n3] + this.L / 2.0);
            graphics.fillOval(n4, n5, 2 * n, 2 * n2);
            ++n3;
        }
    }
}

