/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.hdmc;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.hdmc.HDMC;
import org.opensourcephysics.stp.util.Rdf;

public class HDMCApp
extends AbstractSimulation {
    HDMC mc = new HDMC();
    DisplayFrame display = new DisplayFrame("Hard Disks");
    PlotFrame grFrame = new PlotFrame("r", "g(r)", "Radial distribution function");
    Rdf gr = new Rdf();
    int timestep = 0;

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new HDMCApp(), stringArray);
        simulationControl.addButton("resetData", "Reset Data");
    }

    public void reset() {
        OSPCombo oSPCombo = new OSPCombo(new String[]{"64", "144", "256"}, 0);
        this.control.setValue("number of particles", oSPCombo);
        this.control.setAdjustableValue("L", 40);
        this.control.setAdjustableValue("step size", 1.0);
        OSPCombo oSPCombo2 = new OSPCombo(new String[]{"hexagonal", "rectangular", "random"}, 1);
        this.control.setValue("initial configuration", oSPCombo2);
        this.control.setAdjustableValue("scale lengths", 1);
        this.enableStepsPerDisplay(true);
        super.setStepsPerDisplay(100);
        this.display.setSquareAspect(true);
        this.resetData();
    }

    public void initialize() {
        String string = this.control.getString("number of particles");
        this.mc.N = string.equals("64") ? 64 : (string.equals("144") ? 144 : 256);
        this.mc.L = this.control.getDouble("L");
        this.mc.initialConfiguration = this.control.getString("initial configuration");
        this.mc.stepSize = this.control.getDouble("step size");
        this.mc.initialize();
        this.gr.initialize(this.mc.L, this.mc.L, 0.1);
        this.grFrame.setPreferredMinMax(0.0, 0.5 * this.mc.L, 0.0, 10.0);
        this.grFrame.setAutoscaleY(true);
        this.display.addDrawable(this.mc);
        this.display.setPreferredMinMax(0.0, this.mc.L, 0.0, this.mc.L);
        this.resetData();
    }

    protected void doStep() {
        this.mc.s = this.control.getDouble("scale lengths");
        this.mc.oneMCstep();
        this.display.setMessage("mcs = " + this.mc.steps / this.mc.N);
        this.gr.append(this.mc.x, this.mc.y);
        this.gr.normalize();
        this.grFrame.clearData();
        this.grFrame.append(0, this.gr.rx, this.gr.ngr);
        this.grFrame.render();
    }

    public void stop() {
        double d = (double)this.mc.N / (this.mc.equivL * this.mc.equivL);
        this.control.println("Density = " + ControlUtils.f4(d));
        d = 1.0 * (double)this.mc.accept / (double)this.mc.steps;
        this.control.println("acceptance ratio = " + ControlUtils.f3(d));
        this.control.println("mcs = " + this.mc.steps / this.mc.N);
    }

    public void resetData() {
        GUIUtils.clearDrawingFrameData(false);
        this.gr.reset();
        this.mc.steps = 0;
        this.mc.mcs = 0.0;
        this.mc.accept = 0;
    }
}

