/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.idealgasintegrals.fermi;

import java.awt.Color;
import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Integral;
import org.opensourcephysics.stp.idealgasintegrals.fermi.FermiEnergyIntegral;

public class ComputeFermiIntegralApp
extends AbstractCalculation
implements Function {
    PlotFrame plotFrame = new PlotFrame("T*", "\u03bc*", "");
    PlotFrame energyFrame = new PlotFrame("T*", "e", "");
    double b = 1.0;
    double T = 1.0;
    double mu = 1.0;
    double rho = 0.5;
    double x_low = 0.0;
    double x_high = 100.0;
    int npoints = 0;
    double[] mua;
    double[] Ta;
    double[] Ea;
    double tolerance = 0.01;
    int nmaxTrials = 1000;
    NumberFormat nf = NumberFormat.getInstance();

    ComputeFermiIntegralApp() {
        this.mua = new double[this.nmaxTrials];
        this.Ta = new double[this.nmaxTrials];
        this.Ea = new double[this.nmaxTrials];
        this.plotFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.energyFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.energyFrame.setAutoscaleX(true);
        this.energyFrame.setAutoscaleY(true);
        this.plotFrame.setMarkerColor(0, Color.RED);
        this.energyFrame.setMarkerColor(0, Color.RED);
        this.plotFrame.setXYColumnNames(0, "T*", "\u03bc*");
        this.energyFrame.setXYColumnNames(0, "T*", "e");
    }

    public void reset() {
        this.control.setValue("T*", 1.0);
        this.control.setValue("\u03bc*", 1.0);
        this.control.println("Calculated integral \t T* \t guess for \u03bc*");
        this.control.println("(= 1 if \u03bc* is correct)");
        this.npoints = 0;
    }

    public double evaluate(double d) {
        return 1.5 * Math.sqrt(d) / (Math.exp(this.b * (d - this.mu)) + 1.0);
    }

    public void calculate() {
        this.mu = this.control.getDouble("\u03bc*");
        this.T = this.control.getDouble("T*");
        this.b = 1.0 / this.T;
        this.rho = Integral.simpson(this, this.x_low, this.x_high, 2000, this.tolerance);
        this.control.println(String.valueOf(this.nf.format(this.rho)) + "\t \t" + this.T + "\t" + this.mu);
        this.plot();
    }

    public double calculateE(double d, double d2) {
        FermiEnergyIntegral fermiEnergyIntegral = new FermiEnergyIntegral();
        fermiEnergyIntegral.b = 1.0 / d2;
        fermiEnergyIntegral.mu = d;
        double d3 = Integral.simpson(fermiEnergyIntegral, this.x_low, this.x_high, 2000, this.tolerance);
        return d3;
    }

    public void accept() {
        this.mua[this.npoints] = this.mu;
        this.Ta[this.npoints] = this.T;
        this.Ea[this.npoints] = this.calculateE(this.mu, this.T);
        ++this.npoints;
        if (this.npoints >= this.nmaxTrials) {
            this.control.print("Too many points");
            System.exit(-1);
        }
        this.plot();
    }

    public void plot() {
        this.plotFrame.clearData();
        this.energyFrame.clearData();
        int n = 0;
        while (n < this.npoints) {
            this.plotFrame.append(0, this.Ta[n], this.mua[n]);
            this.energyFrame.append(0, this.Ta[n], this.Ea[n]);
            ++n;
        }
        this.plotFrame.render();
        this.energyFrame.render();
    }

    public static void main(String[] stringArray) {
        CalculationControl calculationControl = CalculationControl.createApp(new ComputeFermiIntegralApp());
        calculationControl.addButton("accept", "Plot (\u03bc*,T*)");
    }
}

