/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising1d;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.CellLattice;

public class Ising1D
implements Drawable {
    public int[] spin;
    public int N;
    public double T;
    public double H;
    public double E;
    public double E_acc;
    public double E2_acc;
    public int M;
    public double M_acc;
    public double M2_acc;
    public int mcs;
    public int acceptedMoves;
    private CellLattice lattice;

    public void initialize(int n, double d, double d2) {
        this.N = n;
        this.T = d;
        this.H = d2;
        this.lattice = new CellLattice(this.N, 1);
        this.lattice.setIndexedColor(0, Color.YELLOW);
        this.lattice.setIndexedColor(2, Color.BLUE);
        this.spin = new int[this.N];
        int n2 = 0;
        while (n2 < this.N) {
            this.spin[n2] = 1;
            ++n2;
        }
        this.M = this.N;
        this.E = (double)(-this.N) - this.H * (double)this.M;
        this.resetData();
    }

    public void setTemperature(double d) {
        this.T = d;
    }

    public void setExternalField(double d) {
        this.E += this.H * (double)this.M - d * (double)this.M;
        this.H = d;
    }

    public double specificHeat() {
        int n = this.mcs == 0 ? 1 : this.mcs;
        double d = this.E2_acc / (double)n;
        double d2 = this.E_acc / (double)n;
        return (d - d2 * d2) / (this.T * this.T * (double)this.N);
    }

    public double susceptibility() {
        int n = this.mcs == 0 ? 1 : this.mcs;
        double d = this.M2_acc / (double)n;
        double d2 = this.M_acc / (double)n;
        return (d - d2 * d2) / (this.T * (double)this.N);
    }

    public void resetData() {
        this.mcs = 0;
        this.E_acc = 0.0;
        this.E2_acc = 0.0;
        this.M_acc = 0.0;
        this.M2_acc = 0.0;
        this.acceptedMoves = 0;
    }

    public void doOneMCStep() {
        int n = 0;
        while (n < this.N) {
            int n2 = (int)(Math.random() * (double)this.N);
            double d = (double)(2 * this.spin[n2]) * (this.H + (double)this.spin[(n2 + 1) % this.N] + (double)this.spin[(n2 - 1 + this.N) % this.N]);
            if (d <= 0.0 || Math.random() < Math.exp(-d / this.T)) {
                this.spin[n2] = -this.spin[n2];
                ++this.acceptedMoves;
                this.E += d;
                this.M += 2 * this.spin[n2];
            }
            ++n;
        }
        this.E_acc += this.E;
        this.E2_acc += this.E * this.E;
        this.M_acc += (double)this.M;
        this.M2_acc += (double)(this.M * this.M);
        ++this.mcs;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.lattice == null) {
            return;
        }
        int n = 0;
        while (n < this.N) {
            this.lattice.setValue(n, 0, (byte)(this.spin[n] + 1));
            ++n;
        }
        this.lattice.draw(drawingPanel, graphics);
    }
}

