/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising1d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.ising1d.Ising1D;
import org.opensourcephysics.stp.ising.ising1d.Ising1DControl;
import org.opensourcephysics.stp.ising.ising1d.Ising1DWRApp;

public class Ising1DApp
extends AbstractSimulation {
    DisplayFrame displayFrame = new DisplayFrame("Spin Configuration");
    PlotFrame eFrame = new PlotFrame("time", "E", "Energy");
    PlotFrame mFrame = new PlotFrame("time", "M", "Magnetization");
    Ising1D ising = new Ising1D();
    NumberFormat nf;

    public Ising1DApp() {
        this.eFrame.setPreferredMinMaxX(0.0, 10.0);
        this.eFrame.setAutoscaleX(true);
        this.eFrame.setAutoscaleY(true);
        this.eFrame.setMarkerColor(0, Color.RED);
        this.mFrame.setPreferredMinMaxX(0.0, 10.0);
        this.mFrame.setAutoscaleX(true);
        this.mFrame.setAutoscaleY(true);
        this.mFrame.setMarkerColor(0, Color.BLUE);
        this.displayFrame.setSize(400, 100);
        this.displayFrame.addDrawable(this.ising);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(4);
    }

    public void initialize() {
        this.ising.initialize(this.control.getInt("N"), this.control.getDouble("Temperature"), this.control.getDouble("External field"));
        this.displayFrame.setPreferredMinMax(-2.0, this.ising.N + 2, -2.0, 3.0);
        this.control.clearMessages();
        this.stopRunning();
    }

    public void doStep() {
        this.ising.setTemperature(this.control.getDouble("Temperature"));
        this.ising.setExternalField(this.control.getDouble("External field"));
        this.ising.doOneMCStep();
        this.mFrame.append(0, this.ising.mcs, (double)this.ising.M / (double)this.ising.N);
        this.eFrame.append(0, this.ising.mcs, this.ising.E / (double)this.ising.N);
    }

    public void stopRunning() {
        double d = this.ising.mcs == 0 ? 1.0 : 1.0 / (double)(this.ising.mcs * this.ising.N);
        this.control.println("mcs = " + this.ising.mcs);
        this.control.println("<E> = " + this.nf.format(this.ising.E_acc * d));
        this.control.println("C = " + this.nf.format(this.ising.specificHeat()));
        this.control.println("<M> = " + this.nf.format(this.ising.M_acc * d));
        this.control.println("Susceptibility \u03a7 = " + this.nf.format(this.ising.susceptibility()));
        this.control.println("Acceptance ratio = " + this.nf.format((double)this.ising.acceptedMoves * d));
        this.control.println();
    }

    public void reset() {
        this.control.setValue("N", 64);
        this.control.setAdjustableValue("Temperature", 1);
        this.control.setAdjustableValue("External field", 0);
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.control.clearMessages();
        this.ising.resetData();
        this.eFrame.clearData();
        this.mFrame.clearData();
        GUIUtils.repaintOSPFrames();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = Ising1DApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(Ising1DApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                Ising1DWRApp ising1DWRApp = new Ising1DWRApp();
                Ising1DControl ising1DControl = new Ising1DControl(ising1DWRApp, ising1DWRApp.eFrame, null);
                ising1DControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        ising1DControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                ising1DControl.loadXML(xMLControlElement, true);
                ising1DWRApp.customize();
                ising1DControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ising1DApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.eFrame);
        this.addChildFrame(this.mFrame);
    }

    public static void main(String[] stringArray) {
        Ising1DApp ising1DApp = new Ising1DApp();
        SimulationControl simulationControl = SimulationControl.createApp(ising1DApp);
        simulationControl.addButton("zeroAverages", "Zero averages");
        ising1DApp.customize();
    }
}

