/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising1d;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.ising.ising1d.Ising1DApp;
import org.opensourcephysics.stp.ising.ising1d.Ising1DControl;

public class Ising1DWRApp
extends Ising1DApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = Ising1DWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(Ising1DWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                Ising1DApp ising1DApp = new Ising1DApp();
                SimulationControl simulationControl = SimulationControl.createApp(ising1DApp);
                simulationControl.setDefaultCloseOperation(n);
                simulationControl.addButton("zeroAverages", "Zero averages");
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                simulationControl.setValue("model", null);
                ising1DApp.customize();
                ising1DApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        double d = this.ising.mcs == 0 ? 1.0 : 1.0 / (double)(this.ising.mcs * this.ising.N);
        ((EjsSimulationControl)this.control).getControl("meanE").setProperty("value", this.nf.format(this.ising.E_acc * d));
        ((EjsSimulationControl)this.control).getControl("meanM").setProperty("value", this.nf.format(this.ising.M_acc * d));
        ((EjsSimulationControl)this.control).getControl("C").setProperty("value", this.nf.format(this.ising.specificHeat()));
        ((EjsSimulationControl)this.control).getControl("susceptibility").setProperty("value", this.nf.format(this.ising.susceptibility()));
    }

    public static void main(String[] stringArray) {
        Ising1DWRApp ising1DWRApp = new Ising1DWRApp();
        new Ising1DControl(ising1DWRApp, ising1DWRApp.eFrame, stringArray);
        ising1DWRApp.customize();
    }
}

