/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.ising2d.Ising2D;
import org.opensourcephysics.stp.ising.ising2d.Ising2DAnti;

public class Ising2DAntiApp
extends AbstractSimulation {
    Ising2DAnti ising;
    DisplayFrame displayFrame = new DisplayFrame("Spin Configuration");
    PlotFrame plotFrame = new PlotFrame("time", "E(Green),M(Red),M_S(Blue)", "Instantaneous Thermodynamic Quantities)");
    NumberFormat nf;

    public Ising2DAntiApp() {
        this.ising = new Ising2DAnti();
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.displayFrame.addDrawable(this.ising);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
    }

    public void initialize() {
        this.ising.J = -1.0;
        this.ising.initialize(this.control.getInt("Length"), this.control.getDouble("Temperature"), this.control.getDouble("External field"));
        this.displayFrame.setPreferredMinMax(-5.0, this.ising.L + 5, -5.0, this.ising.L + 5);
        this.control.clearMessages();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
        this.displayFrame.repaint();
    }

    public void doStep() {
        this.ising.setTemperature(this.control.getDouble("Temperature"));
        this.ising.setExternalField(this.control.getDouble("External field"));
        this.ising.doOneMCStep();
        this.plotFrame.append(0, this.ising.mcs, (double)this.ising.M / (double)this.ising.N);
        this.plotFrame.append(1, this.ising.mcs, this.ising.E / (double)this.ising.N);
        this.plotFrame.append(2, this.ising.mcs, this.ising.getStaggeredM() / (double)this.ising.N);
        this.plotFrame.repaint();
        this.displayFrame.repaint();
    }

    public void stopRunning() {
        double d = 1.0 / (double)(this.ising.mcs * this.ising.N);
        this.control.println("mcs = " + this.ising.mcs);
        this.control.println("<E> = " + this.nf.format(this.ising.E_acc * d));
        this.control.println("Specific heat = " + this.nf.format(this.ising.specificHeat()));
        this.control.println("<M> = " + this.nf.format(this.ising.M_acc * d));
        this.control.println("Susceptibility = " + this.nf.format(this.ising.susceptibility()));
        this.control.println("Staggered susceptibility = " + this.nf.format(this.ising.Staggeredsusceptibility()));
        this.control.println("Staggered magnetization = " + this.nf.format(this.ising.Sm_acc * d));
        this.control.println("Acceptance ratio = " + this.nf.format((double)this.ising.acceptedMoves * d));
    }

    public void reset() {
        this.control.setAdjustableValue("Length", 32);
        this.control.setAdjustableValue("Temperature", this.nf.format(Ising2D.criticalTemperature));
        this.control.setAdjustableValue("External field", 0);
        this.enableStepsPerDisplay(true);
    }

    public void cleardata() {
        this.control.clearMessages();
        this.ising.resetData();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new Ising2DAntiApp(), stringArray);
        simulationControl.addButton("cleardata", "Zero averages");
    }
}

