/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.ising2d.Ising2D;
import org.opensourcephysics.stp.ising.ising2d.Ising2DControl;
import org.opensourcephysics.stp.ising.ising2d.Ising2DWRApp;

public class Ising2DHysteresisApp
extends AbstractSimulation {
    Ising2D ising;
    DisplayFrame displayFrame = new DisplayFrame("Spin Configuration");
    DrawingPanel displayPanel;
    PlotFrame plotFrame = new PlotFrame("H", "M", "Hysteresis Loop");
    NumberFormat nf;
    double bondProbability;
    double H;
    double dH = 0.01;
    int dir = 1;
    int mcsPerH;
    boolean metropolis = true;

    public Ising2DHysteresisApp() {
        this.ising = new Ising2D();
        this.plotFrame.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0);
        this.plotFrame.setAutoscaleX(false);
        this.plotFrame.setAutoscaleY(false);
        this.plotFrame.setMarkerColor(0, Color.BLUE);
        this.plotFrame.setMarkerColor(1, Color.RED);
        this.displayFrame.addDrawable(this.ising);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
        this.displayPanel = this.displayFrame.getDrawingPanel();
    }

    public void initialize() {
        this.ising.initialize(this.control.getInt("Length"), this.control.getDouble("Temperature"), this.H);
        this.bondProbability = this.bondProbability(this.ising.J, this.ising.T);
        this.displayPanel.setPreferredMinMax(-5.0, this.ising.L + 5, -5.0, this.ising.L + 5);
        this.control.clearMessages();
        this.stopRunning();
        this.H = this.control.getDouble("Initial H");
        this.dH = Math.abs(this.control.getDouble("dH"));
        this.dir = this.H > 0.0 ? -1 : 1;
        this.mcsPerH = this.control.getInt("mcs per field value");
        this.ising.setTemperature(this.control.getDouble("Temperature"));
    }

    public double bondProbability(double d, double d2) {
        return 1.0 - Math.exp(-2.0 * d / d2);
    }

    public void doStep() {
        this.ising.setExternalField(this.H);
        this.ising.resetData();
        int n = 0;
        while (n < this.mcsPerH) {
            this.ising.doOneMCStep();
            ++n;
        }
        if (this.dir < 0) {
            this.plotFrame.append(0, this.H, (double)this.ising.M / (double)this.ising.N);
        } else {
            this.plotFrame.append(1, this.H, (double)this.ising.M / (double)this.ising.N);
        }
        if (Math.abs(this.H) > 1.0) {
            this.dir = -this.dir;
        }
        this.H += this.dH * (double)this.dir;
    }

    public void reset() {
        this.control.setValue("Length", 32);
        this.control.setValue("Initial H", 1);
        this.control.setValue("dH", 0.01);
        this.control.setValue("mcs per field value", 10);
        this.control.setValue("Temperature", this.nf.format(1.8));
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.control.clearMessages();
        this.ising.resetData();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = Ising2DHysteresisApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(Ising2DHysteresisApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                Ising2DWRApp ising2DWRApp = new Ising2DWRApp();
                Ising2DControl ising2DControl = new Ising2DControl(ising2DWRApp, ising2DWRApp.displayFrame, null);
                ising2DControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        ising2DControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                ising2DControl.loadXML(xMLControlElement, true);
                ising2DWRApp.customize();
                ising2DWRApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ising2DHysteresisApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        Ising2DHysteresisApp ising2DHysteresisApp = new Ising2DHysteresisApp();
        SimulationControl.createApp(ising2DHysteresisApp, stringArray);
        ising2DHysteresisApp.customize();
    }
}

