/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.CellLattice;

public class LatGas2D
implements Drawable {
    public static final double criticalTemperature = 0.5 / Math.log(1.0 + Math.sqrt(2.0));
    public int[][] site;
    public int L;
    public int N;
    public double v0 = 1.0;
    public double T;
    public double g;
    public double E;
    public double E_acc;
    public double E2_acc;
    public int NP;
    public int mcs;
    public int acceptedMoves;
    private CellLattice lattice;

    public void initialize(int n, double d, int n2) {
        int n3;
        this.L = n;
        this.N = this.L * this.L;
        this.T = d;
        this.NP = n2;
        this.lattice = new CellLattice(this.L, this.L);
        this.lattice.setIndexedColor(0, Color.YELLOW);
        this.lattice.setIndexedColor(1, Color.BLUE);
        this.site = new int[this.L][this.L];
        int n4 = 0;
        while (n4 < this.NP) {
            n3 = n4 % this.L;
            int n5 = n4 / this.L;
            this.site[n3][n5] = 1;
            ++n4;
        }
        this.E = 0.0;
        n4 = 0;
        while (n4 < this.L) {
            n3 = 0;
            while (n3 < this.L) {
                this.E += this.g * (double)n3 * (double)this.site[n4][n3] - (double)(this.site[n4][n3] * (this.site[(n4 + 1) % this.L][n3] + this.site[n4][(n3 + 1) % this.L]));
                ++n3;
            }
            ++n4;
        }
        this.resetData();
    }

    public void setTemperature(double d) {
        this.T = d;
    }

    public void setField(double d) {
        double d2 = d - this.g;
        this.g = d;
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                this.E += d2 * (double)n2 * (double)this.site[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public double specificHeat() {
        int n = this.mcs == 0 ? 1 : this.mcs;
        double d = this.E2_acc / (double)(this.N * n);
        double d2 = this.E_acc / (double)(this.N * n);
        return (d - d2 * d2) / (this.T * this.T * (double)this.N);
    }

    public void resetData() {
        this.mcs = 0;
        this.E_acc = 0.0;
        this.E2_acc = 0.0;
        this.acceptedMoves = 0;
    }

    public void doOneMCStep() {
        int n = 0;
        while (n < this.N) {
            int n2 = (int)(Math.random() * (double)this.L);
            int n3 = (int)(Math.random() * (double)this.L);
            int n4 = (n2 + 1) % this.L;
            int n5 = n3;
            if (Math.random() < 0.5 && (this.g == 0.0 || n3 < this.L - 1)) {
                n4 = n2;
                n5 = (n3 + 1) % this.L;
            }
            if (this.site[n2][n3] + this.site[n4][n5] == 1) {
                double d = 0.0;
                if (n3 != n5) {
                    d += this.g * (double)(this.site[n2][n3] - this.site[n4][n5]);
                }
                d = this.g == 0.0 || n3 > 0 && n5 < this.L - 1 ? (d += -this.v0 * (double)(this.site[n4][n5] - this.site[n2][n3]) * (double)(this.site[(n2 + 1) % this.L][n3] + this.site[(n2 - 1 + this.L) % this.L][n3] + this.site[n2][(n3 + 1) % this.L] + this.site[n2][(n3 - 1 + this.L) % this.L] - this.site[n4][n5] - this.site[(n4 + 1) % this.L][n5] - this.site[(n4 - 1 + this.L) % this.L][n5] - this.site[n4][(n5 + 1) % this.L] - this.site[n4][(n5 - 1 + this.L) % this.L] + this.site[n2][n3])) : (d += this.inFielddE(n2, n3, n4, n5));
                if (d <= 0.0 || Math.random() < Math.exp(-d / this.T)) {
                    int n6 = this.site[n2][n3];
                    this.site[n2][n3] = this.site[n4][n5];
                    this.site[n4][n5] = n6;
                    ++this.acceptedMoves;
                    this.E += d;
                }
            }
            this.E_acc += this.E;
            this.E2_acc += this.E * this.E;
            ++n;
        }
        ++this.mcs;
    }

    public double inFielddE(int n, int n2, int n3, int n4) {
        if (n2 == 0 && n4 == 0) {
            return -this.v0 * (double)(this.site[n3][n4] - this.site[n][n2]) * (double)(this.site[(n + 1) % this.L][n2] + this.site[(n - 1 + this.L) % this.L][n2] + this.site[n][(n2 + 1) % this.L] - this.site[n3][n4] - this.site[(n3 + 1) % this.L][n4] - this.site[(n3 - 1 + this.L) % this.L][n4] - this.site[n3][(n4 + 1) % this.L] + this.site[n][n2]);
        }
        if (n2 == 0) {
            return -this.v0 * (double)(this.site[n3][n4] - this.site[n][n2]) * (double)(this.site[(n + 1) % this.L][n2] + this.site[(n - 1 + this.L) % this.L][n2] + this.site[n][(n2 + 1) % this.L] - this.site[n3][n4] - this.site[(n3 + 1) % this.L][n4] - this.site[(n3 - 1 + this.L) % this.L][n4] - this.site[n3][(n4 + 1) % this.L] - this.site[n3][(n4 - 1 + this.L) % this.L] + this.site[n][n2]);
        }
        if (n2 == this.L - 1 && n4 == this.L - 1) {
            return -this.v0 * (double)(this.site[n3][n4] - this.site[n][n2]) * (double)(this.site[(n + 1) % this.L][n2] + this.site[(n - 1 + this.L) % this.L][n2] + this.site[n][(n2 - 1 + this.L) % this.L] - this.site[n3][n4] - this.site[(n3 + 1) % this.L][n4] - this.site[(n3 - 1 + this.L) % this.L][n4] - this.site[n3][(n4 - 1 + this.L) % this.L] + this.site[n][n2]);
        }
        return -this.v0 * (double)(this.site[n3][n4] - this.site[n][n2]) * (double)(this.site[(n + 1) % this.L][n2] + this.site[(n - 1 + this.L) % this.L][n2] + this.site[n][(n2 + 1) % this.L] + this.site[n][(n2 - 1 + this.L) % this.L] - this.site[n3][n4] - this.site[(n3 + 1) % this.L][n4] - this.site[(n3 - 1 + this.L) % this.L][n4] - this.site[n3][(n4 - 1 + this.L) % this.L] + this.site[n][n2]);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.lattice == null) {
            return;
        }
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                this.lattice.setValue(n, n2, (byte)this.site[n][n2]);
                ++n2;
            }
            ++n;
        }
        this.lattice.draw(drawingPanel, graphics);
    }
}

