/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.meanfieldequation;

import java.awt.Color;
import java.text.DecimalFormat;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Root;

public class MeanFieldApp
extends AbstractCalculation
implements Function {
    PlotFrame plotFrame = new PlotFrame("m", "tanh(m)", "");
    PlotFrame energyFrame = new PlotFrame("m", "f(m)", "Free energy");
    double beta = 1.0;
    double Jq = 4.0;
    double b = 1.0;
    double mxlimit;
    double pxlimit;
    double xtol = 0.5;
    double[] root;
    boolean negative = false;
    DecimalFormat numberFormat = (DecimalFormat)DecimalFormat.getInstance();

    MeanFieldApp() {
        this.root = new double[3];
        this.plotFrame.setConnected(true);
        this.plotFrame.setMarkerColor(1, Color.RED);
        this.plotFrame.setMarkerColor(0, Color.BLUE);
        this.energyFrame.setMarkerColor(0, Color.BLUE);
        this.energyFrame.setConnected(true);
        this.numberFormat.setMinimumFractionDigits(3);
    }

    public void reset() {
        this.control.setValue("T", 1.0);
        this.control.setValue("q", 4.0);
        this.control.setValue("H", 0.0);
    }

    public void calculate() {
        this.beta = 1.0 / this.control.getDouble("T");
        this.Jq = this.control.getDouble("q");
        this.b = this.control.getDouble("H");
        this.pxlimit = 5.0;
        this.mxlimit = -5.0 - this.xtol / 2.0;
        double d = 1.0E-4;
        this.root[2] = Double.NaN;
        this.root[1] = Double.NaN;
        this.root[0] = Double.NaN;
        double d2 = this.mxlimit;
        while (d2 < this.pxlimit) {
            this.findRoots(d2, d2 + this.xtol, d);
            d2 += this.xtol;
        }
        this.control.clearMessages();
        if (this.countRoots() == 1) {
            this.control.println("Root = " + this.numberFormat.format(this.root[0]));
        } else if (this.countRoots() > 1) {
            this.mxlimit = this.root[0] - 1.0;
            this.pxlimit = this.root[2] + 1.0;
            int n = 0;
            while (n < 3) {
                if (!Double.isNaN(this.root[n])) {
                    this.control.println("Root " + n + " = " + this.numberFormat.format(this.root[n]));
                }
                ++n;
            }
        } else {
            this.control.println("No roots found");
        }
        this.plot();
    }

    public boolean findRoots(double d, double d2, double d3) {
        double d4 = Root.bisection(this, d, d2, d3);
        if (Double.isNaN(d4)) {
            return false;
        }
        this.storeRoots(d4);
        return true;
    }

    public void storeRoots(double d) {
        int n = 0;
        while (n < 3 && !Double.isNaN(this.root[n])) {
            ++n;
        }
        if (n == 3) {
            System.out.println("More than three roots found!");
            return;
        }
        this.root[n] = d;
    }

    public int countRoots() {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (!Double.isNaN(this.root[n2])) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void plot() {
        double d = this.mxlimit;
        while (d < this.pxlimit) {
            this.plotFrame.append(0, d, this.mftanh(d));
            this.plotFrame.append(1, d, d);
            this.energyFrame.append(0, d, this.freeenergy(d));
            d += 0.02;
        }
        this.plotFrame.render();
    }

    public double freeenergy(double d) {
        return 0.5 * this.Jq * d * d - 1.0 / this.beta * Math.log(2.0 * this.cosh(this.beta * (this.Jq * d + this.b)));
    }

    public double evaluate(double d) {
        return this.mftanh(d) - d;
    }

    public double mftanh(double d) {
        return this.tanh(this.beta * (this.Jq * d + this.b));
    }

    public double tanh(double d) {
        double d2 = Math.exp(d);
        double d3 = 1.0 / d2;
        return (d2 - d3) / (d2 + d3);
    }

    public double cosh(double d) {
        double d2 = Math.exp(d);
        double d3 = 1.0 / d2;
        return (d2 + d3) / 2.0;
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new MeanFieldApp(), stringArray);
    }
}

