/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.lj;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.Verlet;

public class LJfluid
implements Drawable,
ODE {
    public double[] state;
    public double[] ax;
    public double[] ay;
    public int N;
    public int nx;
    public int ny;
    public double Lx;
    public double Ly;
    public double rho;
    public double initialKineticEnergy;
    public int steps;
    public double dt;
    public double t;
    public double totalPotentialEnergyAccumulator;
    public double totalKineticEnergyAccumulator;
    public double totalKineticEnergySquaredAccumulator;
    public double virialAccumulator;
    public String initialConfiguration;
    public double radius;
    Verlet odeSolver;

    public LJfluid() {
        this.rho = (double)this.N / (this.Lx * this.Ly);
        this.steps = 0;
        this.dt = 0.01;
        this.radius = 0.5;
        this.odeSolver = new Verlet(this);
    }

    public void initialize() {
        this.N = this.nx * this.ny;
        this.t = 0.0;
        this.rho = (double)this.N / (this.Lx * this.Ly);
        this.resetAverages();
        this.state = new double[1 + 4 * this.N];
        this.ax = new double[this.N];
        this.ay = new double[this.N];
        if (this.initialConfiguration.equals("triangular")) {
            this.setTriangularLattice();
        } else if (this.initialConfiguration.equals("rectangular")) {
            this.setRectangularLattice();
        } else {
            this.setRandomPositions();
        }
        this.setVelocities();
        this.computeAcceleration();
        this.odeSolver.setStepSize(this.dt);
    }

    public void setRandomPositions() {
        double d = Math.pow(2.0, 0.3333333333333333);
        int n = 0;
        while (n < this.N) {
            boolean bl;
            do {
                bl = false;
                this.state[4 * n] = this.Lx * Math.random();
                this.state[4 * n + 2] = this.Ly * Math.random();
                int n2 = 0;
                while (n2 < n && !bl) {
                    double d2;
                    double d3 = this.pbcSeparation(this.state[4 * n] - this.state[4 * n2], this.Lx);
                    if (d3 * d3 + (d2 = this.pbcSeparation(this.state[4 * n + 2] - this.state[4 * n2 + 2], this.Ly)) * d2 < d) {
                        bl = true;
                    }
                    ++n2;
                }
            } while (bl);
            ++n;
        }
    }

    public void setRectangularLattice() {
        double d = this.Lx / (double)this.nx;
        double d2 = this.Ly / (double)this.ny;
        int n = 0;
        while (n < this.nx) {
            int n2 = 0;
            while (n2 < this.ny) {
                int n3 = n + n2 * this.ny;
                this.state[4 * n3] = d * ((double)n + 0.5);
                this.state[4 * n3 + 2] = d2 * ((double)n2 + 0.5);
                ++n2;
            }
            ++n;
        }
    }

    public void setTriangularLattice() {
        double d = this.Lx / (double)this.nx;
        double d2 = this.Ly / (double)this.ny;
        int n = 0;
        while (n < this.nx) {
            int n2 = 0;
            while (n2 < this.ny) {
                int n3 = n + n2 * this.ny;
                this.state[4 * n3 + 2] = d2 * ((double)n2 + 0.5);
                this.state[4 * n3] = n2 % 2 == 0 ? d * ((double)n + 0.25) : d * ((double)n + 0.75);
                ++n2;
            }
            ++n;
        }
    }

    public void setVelocities() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.N) {
            this.state[4 * n + 1] = Math.random() - 0.5;
            this.state[4 * n + 3] = Math.random() - 0.5;
            d += this.state[4 * n + 1];
            d2 += this.state[4 * n + 3];
            ++n;
        }
        double d3 = d / (double)this.N;
        double d4 = d2 / (double)this.N;
        int n2 = 0;
        while (n2 < this.N) {
            int n3 = 4 * n2 + 1;
            this.state[n3] = this.state[n3] - d3;
            int n4 = 4 * n2 + 3;
            this.state[n4] = this.state[n4] - d4;
            ++n2;
        }
        double d5 = 0.0;
        int n5 = 0;
        while (n5 < this.N) {
            d5 += this.state[4 * n5 + 1] * this.state[4 * n5 + 1] + this.state[4 * n5 + 3] * this.state[4 * n5 + 3];
            ++n5;
        }
        double d6 = 0.5 * d5 / (double)this.N;
        double d7 = Math.sqrt(this.initialKineticEnergy / d6);
        int n6 = 0;
        while (n6 < this.N) {
            int n7 = 4 * n6 + 1;
            this.state[n7] = this.state[n7] * d7;
            int n8 = 4 * n6 + 3;
            this.state[n8] = this.state[n8] * d7;
            ++n6;
        }
    }

    public double getMeanTemperature() {
        return this.totalKineticEnergyAccumulator / (double)(this.N * this.steps);
    }

    public double getMeanEnergy() {
        return this.totalKineticEnergyAccumulator / (double)this.steps + this.totalPotentialEnergyAccumulator / (double)this.steps;
    }

    public double getMeanPressure() {
        double d = this.virialAccumulator / (double)this.steps;
        return 1.0 + 0.5 * d / ((double)this.N * this.getMeanTemperature());
    }

    public void quench(double d) {
        int n = 0;
        while (n < this.N) {
            int n2 = 4 * n + 1;
            this.state[n2] = this.state[n2] * d;
            int n3 = 4 * n + 3;
            this.state[n3] = this.state[n3] * d;
            ++n;
        }
    }

    public double getHeatCapacity() {
        double d = this.getMeanTemperature();
        double d2 = this.totalKineticEnergySquaredAccumulator / (double)this.steps;
        double d3 = this.totalKineticEnergyAccumulator / (double)this.steps;
        double d4 = d2 - d3 * d3;
        double d5 = 1.0 - d4 / ((double)this.N * d * d);
        return (double)this.N / d5;
    }

    public void resetAverages() {
        this.steps = 0;
        this.virialAccumulator = 0.0;
        this.totalPotentialEnergyAccumulator = 0.0;
        this.totalKineticEnergyAccumulator = 0.0;
        this.totalKineticEnergySquaredAccumulator = 0.0;
    }

    public void computeAcceleration() {
        int n = 0;
        while (n < this.N) {
            this.ax[n] = 0.0;
            this.ay[n] = 0.0;
            ++n;
        }
        n = 0;
        while (n < this.N - 1) {
            int n2 = n + 1;
            while (n2 < this.N) {
                double d = this.pbcSeparation(this.state[4 * n] - this.state[4 * n2], this.Lx);
                double d2 = this.pbcSeparation(this.state[4 * n + 2] - this.state[4 * n2 + 2], this.Ly);
                double d3 = d * d + d2 * d2;
                double d4 = 1.0 / d3;
                double d5 = d4 * d4 * d4;
                double d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                double d7 = d6 * d;
                double d8 = d6 * d2;
                int n3 = n;
                this.ax[n3] = this.ax[n3] + d7;
                int n4 = n;
                this.ay[n4] = this.ay[n4] + d8;
                int n5 = n2;
                this.ax[n5] = this.ax[n5] - d7;
                int n6 = n2++;
                this.ay[n6] = this.ay[n6] - d8;
                this.totalPotentialEnergyAccumulator += 4.0 * (d5 * d5 - d5);
                this.virialAccumulator += d * d7 + d2 * d8;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private double pbcSeparation(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > 0.5 * var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < -0.5 * var3_2)
            }
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private double pbcPosition(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < 0.0)
            }
        }
        return var1_1;
    }

    public void getRate(double[] dArray, double[] dArray2) {
        if (this.odeSolver.getRateCounter() == 1) {
            this.computeAcceleration();
        }
        int n = 0;
        while (n < this.N) {
            dArray2[4 * n] = dArray[4 * n + 1];
            dArray2[4 * n + 2] = dArray[4 * n + 3];
            dArray2[4 * n + 1] = this.ax[n];
            dArray2[4 * n + 3] = this.ay[n];
            ++n;
        }
        dArray2[4 * this.N] = 1.0;
    }

    public double[] getState() {
        return this.state;
    }

    public void step(HistogramFrame histogramFrame) {
        this.odeSolver.step();
        double d = 0.0;
        int n = 0;
        while (n < this.N) {
            d += this.state[4 * n + 1] * this.state[4 * n + 1] + this.state[4 * n + 3] * this.state[4 * n + 3];
            histogramFrame.append(this.state[4 * n + 1]);
            this.state[4 * n] = this.pbcPosition(this.state[4 * n], this.Lx);
            this.state[4 * n + 2] = this.pbcPosition(this.state[4 * n + 2], this.Ly);
            ++n;
        }
        ++this.steps;
        this.totalKineticEnergyAccumulator += (d *= 0.5);
        this.totalKineticEnergySquaredAccumulator += d * d;
        this.t += this.dt;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (this.state == null) {
            return;
        }
        int n3 = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n4 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.red);
        int n5 = 0;
        while (n5 < this.N) {
            n2 = drawingPanel.xToPix(this.state[4 * n5]) - n3;
            n = drawingPanel.yToPix(this.state[4 * n5 + 2]) - n4;
            graphics.fillOval(n2, n, 2 * n3, 2 * n4);
            ++n5;
        }
        graphics.setColor(Color.black);
        n5 = drawingPanel.xToPix(0.0);
        n2 = drawingPanel.yToPix(this.Ly);
        n = drawingPanel.xToPix(this.Lx) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.Ly);
        graphics.drawRect(n5, n2, n, n6);
    }
}

