/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ljmc;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class LJMC
implements Drawable {
    public double[] x;
    public double[] y;
    public double pe;
    public double virial;
    public int N;
    public double L;
    public double rho;
    public int steps;
    public double mcs;
    public String initialConfiguration;
    public double radius;
    public double T;
    public double beta;
    public double stepSize;
    public double totalPotentialEnergyAccumulator;
    public double virialAccumulator;
    public double totalPotentialEnergyAccumulator2;
    Random r;

    public LJMC() {
        this.rho = (double)this.N / (this.L * this.L);
        this.steps = 0;
        this.mcs = 0.0;
        this.radius = 0.5;
        this.totalPotentialEnergyAccumulator = 0.0;
        this.virialAccumulator = 0.0;
        this.totalPotentialEnergyAccumulator2 = 0.0;
        this.r = new Random();
    }

    public void initialize() {
        this.mcs = 0.0;
        this.rho = (double)this.N / (this.L * this.L);
        this.beta = 1.0 / this.T;
        this.x = new double[this.N];
        this.y = new double[this.N];
        if (this.initialConfiguration.equals("triangular")) {
            this.setTriangularLattice();
        } else if (this.initialConfiguration.equals("rectangular")) {
            this.setRectangularLattice();
        } else {
            this.setRandomPositions();
        }
        this.pe = 0.0;
        this.virial = 0.0;
        this.computePE();
        this.totalPotentialEnergyAccumulator = 0.0;
        this.totalPotentialEnergyAccumulator2 = 0.0;
        this.virialAccumulator = 0.0;
    }

    public void setRandomPositions() {
        double d = Math.pow(2.0, 0.3333333333333333);
        int n = 0;
        while (n < this.N) {
            boolean bl;
            do {
                bl = false;
                this.x[n] = this.L * Math.random();
                this.y[n] = this.L * Math.random();
                int n2 = 0;
                while (n2 < n && !bl) {
                    double d2;
                    double d3 = this.pbcSeparation(this.x[n] - this.x[n2], this.L);
                    if (d3 * d3 + (d2 = this.pbcSeparation(this.y[n] - this.y[n2], this.L)) * d2 < d) {
                        bl = true;
                    }
                    ++n2;
                }
            } while (bl);
            ++n;
        }
    }

    public void setRectangularLattice() {
        double d;
        int n;
        int n2 = n = (int)Math.sqrt(this.N);
        double d2 = d = this.L / (double)n;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3 + n4 * n2;
                this.x[n5] = d * ((double)n3 + 0.5);
                this.y[n5] = d2 * ((double)n4 + 0.5);
                ++n4;
            }
            ++n3;
        }
    }

    public void setTriangularLattice() {
        int n;
        double d = Math.sqrt(this.N);
        if (d - (double)(n = (int)d) > 0.001) {
            ++n;
        }
        double d2 = this.L / (double)n;
        double d3 = this.L / (double)n;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.N) {
            int n4 = 0;
            while (n4 < n) {
                if (n2 < this.N) {
                    this.y[n2] = d3 * ((double)n3 + 0.5);
                    this.x[n2] = n3 % 2 == 0 ? d2 * ((double)n4 + 0.25) : d2 * ((double)n4 + 0.75);
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void computePE() {
        int n = 0;
        while (n < this.N - 1) {
            int n2 = n + 1;
            while (n2 < this.N) {
                double d = this.pbcSeparation(this.x[n] - this.x[n2], this.L);
                double d2 = this.pbcSeparation(this.y[n] - this.y[n2], this.L);
                double d3 = d * d + d2 * d2;
                double d4 = 1.0 / d3;
                double d5 = d4 * d4 * d4;
                double d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                double d7 = d6 * d;
                double d8 = d6 * d2;
                this.pe += 4.0 * (d5 * d5 - d5);
                this.virial += d * d7 + d2 * d8;
                ++n2;
            }
            ++n;
        }
    }

    public void computeTrialPE(TrialMove trialMove) {
        trialMove.dvirial = 0.0;
        trialMove.dE = 0.0;
        int n = 0;
        while (n < this.N) {
            if (n != trialMove.n) {
                double d = this.pbcSeparation(this.x[n] - trialMove.x, this.L);
                double d2 = this.pbcSeparation(this.y[n] - trialMove.y, this.L);
                double d3 = d * d + d2 * d2;
                double d4 = 1.0 / d3;
                double d5 = d4 * d4 * d4;
                double d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                double d7 = d6 * d;
                double d8 = d6 * d2;
                trialMove.dE += 4.0 * (d5 * d5 - d5);
                trialMove.dvirial += d * d7 + d2 * d8;
                d = this.pbcSeparation(this.x[n] - this.x[trialMove.n], this.L);
                d2 = this.pbcSeparation(this.y[n] - this.y[trialMove.n], this.L);
                d3 = d * d + d2 * d2;
                d4 = 1.0 / d3;
                d5 = d4 * d4 * d4;
                d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                d7 = d6 * d;
                d8 = d6 * d2;
                trialMove.dE -= 4.0 * (d5 * d5 - d5);
                trialMove.dvirial -= d * d7 + d2 * d8;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private double pbcSeparation(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > 0.5 * var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < -0.5 * var3_2)
            }
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private double pbcPosition(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < 0.0)
            }
        }
        return var1_1;
    }

    public TrialMove makeTrialMove() {
        TrialMove trialMove = new TrialMove();
        trialMove.n = this.r.nextInt(this.N);
        double d = 2.0 * this.stepSize * (Math.random() - 0.5);
        double d2 = 2.0 * this.stepSize * (Math.random() - 0.5);
        trialMove.x = this.pbcPosition(this.x[trialMove.n] + d, this.L);
        trialMove.y = this.pbcPosition(this.y[trialMove.n] + d2, this.L);
        this.computeTrialPE(trialMove);
        return trialMove;
    }

    public void step() {
        boolean bl;
        TrialMove trialMove = this.makeTrialMove();
        boolean bl2 = trialMove.dE < 0.0;
        boolean bl3 = bl = Math.exp(-trialMove.dE / this.T) > Math.random();
        if (bl2 || bl) {
            this.x[trialMove.n] = trialMove.x;
            this.y[trialMove.n] = trialMove.y;
            this.pe += trialMove.dE;
            this.virial += trialMove.dvirial;
        }
        this.virialAccumulator += this.virial;
        ++this.steps;
        if (this.steps % this.N == 0) {
            this.totalPotentialEnergyAccumulator += this.pe;
            this.totalPotentialEnergyAccumulator2 += this.pe * this.pe;
            this.mcs += 1.0;
        }
    }

    public void oneMCstep() {
        int n = 0;
        while (n < this.N) {
            this.step();
            ++n;
        }
    }

    public double getMeanPressure() {
        double d = this.virialAccumulator / (double)this.steps;
        return 1.0 + 0.5 * d / ((double)this.N * this.T);
    }

    public double getSpecificHeat() {
        double d = this.totalPotentialEnergyAccumulator / this.mcs;
        double d2 = this.totalPotentialEnergyAccumulator2 / this.mcs;
        return (d2 - d * d) / (this.T * this.T * (double)this.N);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (this.x == null || this.y == null) {
            return;
        }
        int n3 = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n4 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.red);
        int n5 = 0;
        while (n5 < this.N) {
            n2 = drawingPanel.xToPix(this.x[n5]) - n3;
            n = drawingPanel.yToPix(this.y[n5]) - n4;
            graphics.fillOval(n2, n, 2 * n3, 2 * n4);
            ++n5;
        }
        graphics.setColor(Color.black);
        n5 = drawingPanel.xToPix(0.0);
        n2 = drawingPanel.yToPix(this.L);
        n = drawingPanel.xToPix(this.L) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.L);
        graphics.drawRect(n5, n2, n, n6);
    }

    public class TrialMove {
        int n;
        double x;
        double y;
        double dE;
        double dvirial;
    }
}

