/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ljmc;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ljmc.LJMC;
import org.opensourcephysics.stp.util.Rdf;

public class LJMCApp
extends AbstractSimulation {
    LJMC mc = new LJMC();
    DisplayFrame display = new DisplayFrame("Lennard-Jones system");
    PlotFrame grFrame = new PlotFrame("r", "g(r)", "Radial distribution function");
    PlotFrame pressure = new PlotFrame("t", "PA/NkT", "Pressure");
    Rdf gr = new Rdf();
    int timestep = 0;

    public void reset() {
        OSPCombo oSPCombo = new OSPCombo(new String[]{"64", "144", "256"}, 0);
        this.control.setValue("number of particles", oSPCombo);
        this.control.setAdjustableValue("L", 18);
        this.control.setAdjustableValue("T", 1);
        this.control.setAdjustableValue("step size", 0.5);
        OSPCombo oSPCombo2 = new OSPCombo(new String[]{"triangular", "rectangular", "random"}, 0);
        this.control.setValue("initial configuration", oSPCombo2);
        this.enableStepsPerDisplay(true);
        super.setStepsPerDisplay(10);
        this.display.setSquareAspect(true);
        this.resetData();
    }

    public void initialize() {
        String string = this.control.getString("number of particles");
        this.mc.N = string.equals("64") ? 64 : (string.equals("144") ? 144 : 256);
        this.mc.L = this.control.getDouble("L");
        this.mc.initialConfiguration = this.control.getString("initial configuration");
        this.mc.T = this.control.getDouble("T");
        this.mc.stepSize = this.control.getDouble("step size");
        this.mc.initialize();
        this.gr.initialize(this.mc.L, this.mc.L, 0.1);
        this.grFrame.setPreferredMinMax(0.0, 0.5 * this.mc.L, 0.0, 10.0);
        this.grFrame.setAutoscaleY(true);
        this.display.addDrawable(this.mc);
        this.display.setPreferredMinMax(0.0, this.mc.L, 0.0, this.mc.L);
        this.pressure.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.pressure.setAutoscaleX(true);
        this.pressure.setAutoscaleY(true);
        this.resetData();
    }

    public void startRunning() {
        double d = this.control.getDouble("L");
        if (d != this.mc.L) {
            this.mc.L = d;
            this.display.setPreferredMinMax(0.0, d, 0.0, d);
            this.resetData();
        }
        this.mc.T = this.control.getDouble("T");
        this.mc.stepSize = this.control.getDouble("step size");
    }

    public void doStep() {
        this.mc.oneMCstep();
        this.gr.append(this.mc.x, this.mc.y);
        this.gr.normalize();
        this.grFrame.clearData();
        this.grFrame.append(0, this.gr.rx, this.gr.ngr);
        this.grFrame.render();
        this.pressure.append(0, this.mc.mcs, this.mc.getMeanPressure());
        this.display.setMessage("mcs = " + this.mc.steps / this.mc.N);
    }

    public void stop() {
        this.control.println("mcs = " + this.mc.steps / this.mc.N);
        this.control.println("Mean potential energy per particle = " + this.decimalFormat.format(this.mc.totalPotentialEnergyAccumulator / (this.mc.mcs * (double)this.mc.N)));
        this.control.println("Specific heat = " + this.decimalFormat.format(this.mc.getSpecificHeat()));
        this.control.println("PA/NkT = " + this.decimalFormat.format(this.mc.getMeanPressure()));
    }

    public void resetData() {
        GUIUtils.clearDrawingFrameData(false);
        this.gr.reset();
        this.mc.steps = 0;
        this.mc.mcs = 0.0;
        this.mc.totalPotentialEnergyAccumulator = 0.0;
        this.mc.totalPotentialEnergyAccumulator2 = 0.0;
        this.mc.virialAccumulator = 0.0;
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new LJMCApp());
        simulationControl.addButton("resetData", "Reset Data");
    }
}

