/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.numOfStates;

import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;

public class NumOfStatesApp
extends AbstractCalculation {
    int dim = 2;
    double R = 10.0;
    PlotFrame plotFrame = new PlotFrame("R", "NumOfStates", "Number Of States");

    public void resetCalculation() {
        this.plotFrame.setConnected(1, true);
        this.plotFrame.setMarkerSize(1, 0);
        this.plotFrame.clearData();
        this.plotFrame.repaint();
        this.control.setValue("dimension", this.dim);
        this.control.setValue("R", this.R);
    }

    public void calculate() {
        this.dim = this.control.getInt("dimension");
        this.R = this.control.getDouble("R");
        int n = 0;
        while ((double)n <= this.R) {
            if (this.dim == 2) {
                this.plotFrame.append(0, n, this.countNumOfStates2(n));
                this.plotFrame.append(1, n, 0.7853981633974483 * (double)n * (double)n);
            } else if (this.dim == 3) {
                this.plotFrame.append(0, n, this.countNumOfStates3(n));
                this.plotFrame.append(1, n, 0.5235987755982988 * (double)n * (double)n * (double)n);
            } else if (this.dim == 1) {
                this.plotFrame.append(0, n, this.countNumOfStates1(n));
                this.plotFrame.append(1, n, n);
            }
            ++n;
        }
    }

    public int countNumOfStates3(int n) {
        int n2 = n * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n) {
            int n5 = 0;
            while (n5 <= n) {
                int n6 = 0;
                while (n6 <= n) {
                    int n7 = n4 * n4 + n5 * n5 + n6 * n6;
                    if (n7 < n2) {
                        ++n3;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return n3;
    }

    public int countNumOfStates2(int n) {
        int n2 = n * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n) {
            int n5 = 0;
            while (n5 <= n) {
                int n6 = n4 * n4 + n5 * n5;
                if (n6 < n2) {
                    ++n3;
                }
                ++n5;
            }
            ++n4;
        }
        return n3;
    }

    public int countNumOfStates1(int n) {
        int n2 = n * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n) {
            int n5 = n4 * n4;
            if (n5 < n2) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new NumOfStatesApp(), stringArray);
    }
}

