/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.oscillatornh;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Osci2
implements Drawable {
    double x = 1.0;
    double vx = 0.0;
    double accel = 0.0;
    double K = 1.0;
    double psi = 0.0;
    double T = 2.5;
    double Q = 0.05;
    double s = 0.0;
    double t = 0.0;
    double Et;

    public void step(double d) {
        double d2 = 1.0;
        double d3 = 1.0;
        this.t += d;
        this.x += this.vx * d + (this.accel - this.psi * this.vx) * 0.5 * d * d;
        this.vx += (this.accel - this.psi * this.vx) * 0.5 * d;
        this.s += this.psi * d + (this.vx * this.vx - this.T) * 0.5 * d * d / this.Q;
        this.psi += (this.vx * this.vx - this.T) * 0.5 * d / this.Q;
        this.getAccel();
        this.vx += this.accel * 0.5 * d;
        double d4 = this.vx;
        double d5 = this.psi;
        this.Et = 0.5 * this.K * this.x * this.x + 0.5 * this.vx * this.vx;
        while (d2 > 1.0E-10 || d3 > 1.0E-10) {
            double d6 = d4;
            double d7 = d5;
            double d8 = d4 * d4;
            d5 = this.psi + (d8 - this.T) * 0.5 * d / this.Q;
            d4 = this.vx - d5 * d4 * 0.5 * d;
            d2 = Math.abs(d4 - d6) / Math.abs(d6);
            d3 = Math.abs((d5 - d7) / d7);
        }
        this.vx = d4;
        this.psi = d5;
        this.Et = 0.5 * this.K * this.x * this.x + 0.5 * this.vx * this.vx + this.psi * this.psi * this.Q / 2.0;
    }

    public double getAccel() {
        this.accel = -this.K * this.x;
        return this.accel;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        double d = 0.25;
        int n = Math.abs(drawingPanel.xToPix(d) - drawingPanel.xToPix(0.0));
        int n2 = Math.abs(drawingPanel.yToPix(d) - drawingPanel.yToPix(0.0));
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n = 1;
        }
        graphics.setColor(Color.red);
        int n3 = drawingPanel.xToPix(this.x) - n;
        graphics.fillOval(n3, 10, 2 * n, 2 * n2);
    }
}

