/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.oscillatornh;

import java.awt.Color;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.oscillatornh.Oscillator;

public class OscillatorApp
extends AbstractSimulation {
    Oscillator osci = new Oscillator();
    PlotFrame phaseFrame = new PlotFrame("q", "p", "Nose-Hoover harmonic oscillator");
    PlotFrame energyFrame = new PlotFrame("time", "Energy", "Energy versus time");
    double mcsPerDisplay;

    public OscillatorApp() {
        this.phaseFrame.setMarkerColor(0, Color.BLUE);
        this.energyFrame.setMarkerColor(0, Color.RED);
    }

    public void doStep() {
        this.osci.step(0.05);
        this.phaseFrame.append(0, this.osci.x, this.osci.vx);
        this.energyFrame.append(0, this.osci.t, this.osci.Et);
    }

    public void initialize() {
        this.osci.x = this.control.getDouble("x");
        this.osci.vx = this.control.getDouble("vx");
        this.osci.Q = this.control.getDouble("Q");
        this.energyFrame.setAutoscaleX(true);
        this.delayTime = 0;
        this.energyFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.energyFrame.setAutoscaleX(true);
        this.energyFrame.setAutoscaleY(true);
    }

    public void reset() {
        this.control.setAdjustableValue("Q", 1.0);
        this.control.setAdjustableValue("x", 1.0);
        this.control.setAdjustableValue("vx", 1.0);
        this.energyFrame.clearData();
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new OscillatorApp());
    }
}

