/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.partfunccalc;

import java.awt.Color;
import org.opensourcephysics.frames.LatticeFrame;

public class PartFuncCalc {
    public int mcs;
    public int L = 4;
    public int N;
    public int[] H;
    public double[] lnZ;
    public double[] increment;
    public double[] T;
    public double f;
    double lnf = 1.0;
    public double acceptEnergy = 0.0;
    public double acceptTemperature = 0.0;
    public double tryEnergy = 0.0;
    public double tryTemperature = 0.0;
    public double fMin = Math.exp(0.001);
    public double flatnessFactor = 0.7;
    public double cutoffFraction = 0.1;
    public int nRunMax = 500;
    public int Et;
    public LatticeFrame lattice;
    public int Tsize;
    public double[] B;
    public int temperature;
    public int k = 1;
    public double prob = 0.001;
    public int currenttempindex;

    public void resetData() {
        this.acceptEnergy = 0.0;
        this.acceptTemperature = 0.0;
        this.tryEnergy = 0.0;
        this.tryTemperature = 0.0;
        int n = 0;
        while (n < this.Tsize) {
            this.H[n] = 0;
            ++n;
        }
    }

    public void settemps() {
        int n = 0;
        double d = 0.1;
        while (d < 1.04) {
            this.increment[n] = 0.1;
            this.T[n] = d;
            ++n;
            d += 0.1;
        }
        d = 1.04;
        while (d < 1.82) {
            this.increment[n] = 0.04;
            this.T[n] = d;
            ++n;
            d += 0.04;
        }
        d = 1.82;
        while (d < 2.005) {
            this.increment[n] = 0.02;
            this.T[n] = d;
            ++n;
            d += 0.02;
        }
        d = 2.005;
        while (d < 2.2025) {
            this.increment[n] = 0.005;
            this.T[n] = d;
            ++n;
            d += 0.005;
        }
        d = 2.2025;
        while (d < 2.252) {
            this.increment[n] = 0.0025;
            this.T[n] = d;
            ++n;
            d += 0.0025;
        }
        d = 2.252;
        while (d < 2.301) {
            this.increment[n] = 0.002;
            this.T[n] = d;
            ++n;
            d += 0.002;
        }
        d = 2.305;
        while (d < 2.352) {
            this.increment[n] = 0.005;
            this.T[n] = d;
            ++n;
            d += 0.005;
        }
        d = 2.36;
        while (d <= 2.505) {
            this.increment[n] = 0.01;
            this.T[n] = d;
            ++n;
            d += 0.01;
        }
        d = 2.52;
        while (d < 2.705) {
            this.increment[n] = 0.02;
            this.T[n] = d;
            ++n;
            d += 0.02;
        }
        d = 2.75;
        while (d < 3.62) {
            this.increment[n] = 0.05;
            this.T[n] = d;
            ++n;
            d += 0.05;
        }
        d = 3.67;
        while (d < 5.05) {
            this.increment[n] = 0.07;
            this.T[n] = d;
            ++n;
            d += 0.07;
        }
        d = 5.1;
        while (d < 6.05) {
            this.increment[n] = 0.1;
            this.T[n] = d;
            ++n;
            d += 0.1;
        }
        d = 6.2;
        while (d < 8.1) {
            this.increment[n] = 0.2;
            this.T[n] = d;
            ++n;
            d += 0.2;
        }
        int n2 = 0;
        while (n2 < this.Tsize) {
            this.B[n2] = 1.0 / this.T[n2];
            ++n2;
        }
    }

    public void initial(int n, double d, LatticeFrame latticeFrame) {
        int n2;
        this.lattice = latticeFrame;
        this.L = n;
        this.prob = d;
        this.N = n * n;
        this.Tsize = 218;
        this.B = new double[this.Tsize];
        this.lnZ = new double[this.Tsize];
        this.increment = new double[this.Tsize];
        this.H = new int[this.Tsize];
        this.T = new double[this.Tsize];
        this.currenttempindex = this.Tsize - 1;
        this.settemps();
        this.lattice.resizeLattice(n, n);
        this.lattice.setIndexedColor(1, Color.green);
        this.lattice.setIndexedColor(-1, Color.red);
        this.lnf = 1.0;
        this.resetData();
        this.Et = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                this.lattice.setValue(n2, n3, -1);
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                this.Et += -this.lattice.getValue(n2, n3) * (this.lattice.getValue((n2 + 1) % n, n3) + this.lattice.getValue(n2, (n3 + 1) % n));
                ++n2;
            }
            ++n3;
        }
        this.Et += 2 * this.N;
        n3 = 0;
        while (n3 < this.Tsize) {
            this.lnZ[n3] = 0.0;
            this.H[n3] = 0;
            ++n3;
        }
    }

    public void doMcStep() {
        if (Math.random() > this.prob) {
            int n;
            int n2 = (int)(Math.random() * (double)this.L);
            int n3 = 2 * this.lattice.getValue(n2, n = (int)(Math.random() * (double)this.L)) * (this.lattice.getValue((n2 + 1) % this.L, n) + this.lattice.getValue((n2 - 1 + this.L) % this.L, n) + this.lattice.getValue(n2, (n + 1) % this.L) + this.lattice.getValue(n2, (n - 1 + this.L) % this.L));
            if (n3 <= 0 || Math.exp((double)(-n3) * this.B[this.currenttempindex]) > Math.random()) {
                this.lattice.setValue(n2, n, -this.lattice.getValue(n2, n));
                this.Et += n3;
                this.acceptEnergy += 1.0;
            }
            this.tryEnergy += 1.0;
        } else {
            int n;
            int n4;
            do {
                n = (int)(Math.random() * 20.0 + 1.0);
                if (!(Math.random() > 0.5)) continue;
                n *= -1;
            } while ((n4 = this.currenttempindex + n) < 0 || n4 > 217);
            double d = (-this.B[n4] + this.B[this.currenttempindex]) * (double)this.Et + this.lnZ[this.currenttempindex] - this.lnZ[n4];
            if (d > 0.0 || Math.exp(d) > Math.random()) {
                this.currenttempindex = n4;
                this.acceptTemperature += 1.0;
            }
            this.tryTemperature += 1.0;
        }
        int n = this.currenttempindex;
        this.lnZ[n] = this.lnZ[n] + this.lnf;
        int n5 = this.currenttempindex;
        this.H[n5] = this.H[n5] + 1;
    }
}

