/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.partfunccalc;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.LatticeFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.partfunccalc.PartFuncCalc;

public class PartFuncCalcApp
extends AbstractSimulation {
    PartFuncCalc ising = new PartFuncCalc();
    private PlotFrame plotFrame = new PlotFrame("T", "[ln Z(T)-ln Z(0.1)]/N", "Partition Function");
    private PlotFrame plotFrame2 = new PlotFrame("T", "H[T]", "Temperature Histogram");
    private LatticeFrame lattice = new LatticeFrame("Ising Model");
    public int displayDelay = 100;
    public int n = 0;

    public PartFuncCalcApp() {
        this.plotFrame.setPreferredMinMaxX(0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.plotFrame2.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.plotFrame2.setAutoscaleX(true);
        this.plotFrame2.setAutoscaleY(true);
    }

    public void initialize() {
        this.ising.initial(this.control.getInt("L"), this.control.getDouble("prob"), this.lattice);
        this.displayDelay = this.control.getInt("display delay");
    }

    public void doStep() {
        int n = (int)((double)(100 * this.ising.N) / Math.sqrt(this.ising.lnf));
        this.displayDelay = this.control.getInt("display delay");
        int n2 = 0;
        while (n2 < n) {
            if (n2 % this.displayDelay == 0) {
                this.lattice.render();
            }
            this.ising.doMcStep();
            ++n2;
        }
        this.control.println("ln f = " + ControlUtils.f4(this.ising.lnf));
        this.control.println(" E accept = " + ControlUtils.f4(this.ising.acceptEnergy / this.ising.tryEnergy));
        this.control.println(" T accept = " + ControlUtils.f4(this.ising.acceptTemperature / this.ising.tryTemperature));
        this.plotFrame.clearData();
        this.plotFrame2.clearData();
        n2 = 0;
        while (n2 < this.ising.Tsize) {
            if (this.ising.lnZ[n2] > 0.0) {
                this.plotFrame.append(0, this.ising.T[n2], this.ising.lnZ[n2] / (double)this.ising.N - this.ising.lnZ[0] / (double)this.ising.N);
            }
            if (this.ising.H[n2] > 0) {
                this.plotFrame2.append(0, this.ising.T[n2], (double)this.ising.H[n2] * this.ising.increment[n2]);
            }
            ++n2;
        }
        this.ising.lnf /= Math.sqrt(10.0);
        this.ising.resetData();
        if (this.ising.lnf < 1.0E-9) {
            System.out.println("done");
            this.stopSimulation();
        }
    }

    public void reset() {
        this.control.setValue("L", 32);
        this.control.setValue("prob", 0.01);
        this.control.setAdjustableValue("display delay", 10000);
    }

    public void resetData() {
        this.ising.resetData();
        this.plotFrame.clearData();
        this.plotFrame2.clearData();
        this.plotFrame.repaint();
        this.plotFrame2.repaint();
        this.control.clearMessages();
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new PartFuncCalcApp());
    }
}

