/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

public class Clusters {
    private static final int EMPTY = Integer.MIN_VALUE;
    public int L;
    public int N;
    public int numSitesOccupied;
    public int[] numClusters;
    private int secondClusterMoment;
    private int spanningClusterSize;
    private int[] order;
    private int[] parent;
    private boolean[] touchesLeft;
    private boolean[] touchesRght;

    public Clusters(int n) {
        this.L = n;
        this.N = n * n;
        this.numClusters = new int[this.N + 1];
        this.order = new int[this.N];
        this.parent = new int[this.N];
        this.touchesLeft = new boolean[this.N];
        this.touchesRght = new boolean[this.N];
    }

    public void newLattice() {
        this.setOccupationOrder();
        this.spanningClusterSize = 0;
        this.secondClusterMoment = 0;
        this.numSitesOccupied = 0;
        int n = 0;
        while (n < this.N) {
            this.numClusters[n] = 0;
            this.parent[n] = Integer.MIN_VALUE;
            ++n;
        }
        n = 0;
        while (n < this.N) {
            this.touchesLeft[n] = n % this.L == 0;
            this.touchesRght[n] = n % this.L == this.L - 1;
            ++n;
        }
    }

    public void addRandomSite() {
        if (this.numSitesOccupied == this.N) {
            return;
        }
        int n = this.order[this.numSitesOccupied++];
        this.numClusters[1] = this.numClusters[1] + 1;
        ++this.secondClusterMoment;
        this.parent[n] = -1;
        int n2 = n;
        int n3 = 0;
        while (n3 < 4) {
            int n4 = this.getNeighbor(n, n3);
            if (n4 != Integer.MIN_VALUE && this.parent[n4] != Integer.MIN_VALUE) {
                n2 = this.mergeRoots(n2, this.findRoot(n4));
            }
            ++n3;
        }
    }

    public int getClusterSize(int n) {
        return this.parent[n] == Integer.MIN_VALUE ? 0 : -this.parent[this.findRoot(n)];
    }

    public int getSpanningClusterSize() {
        return this.spanningClusterSize;
    }

    public double getMeanClusterSize() {
        int n = this.getSpanningClusterSize();
        double d = this.secondClusterMoment - n * n;
        double d2 = this.numSitesOccupied - n;
        if (d2 > 0.0) {
            return d / d2;
        }
        return 0.0;
    }

    private int findRoot(int n) {
        if (this.parent[n] < 0) {
            return n;
        }
        this.parent[n] = this.findRoot(this.parent[n]);
        return this.parent[n];
    }

    private int getNeighbor(int n, int n2) {
        switch (n2) {
            case 0: {
                return n % this.L == 0 ? Integer.MIN_VALUE : n - 1;
            }
            case 1: {
                return n % this.L == this.L - 1 ? Integer.MIN_VALUE : n + 1;
            }
            case 2: {
                return n / this.L == 0 ? Integer.MIN_VALUE : n - this.L;
            }
            case 3: {
                return n / this.L == this.L - 1 ? Integer.MIN_VALUE : n + this.L;
            }
        }
        return Integer.MIN_VALUE;
    }

    private void setOccupationOrder() {
        int n = 0;
        while (n < this.N) {
            this.order[n] = n;
            ++n;
        }
        n = 0;
        while (n < this.N - 1) {
            int n2 = n + (int)(Math.random() * (double)(this.N - n));
            int n3 = this.order[n];
            this.order[n] = this.order[n2];
            this.order[n2] = n3;
            ++n;
        }
    }

    private int sqr(int n) {
        return n * n;
    }

    private int mergeRoots(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (-this.parent[n] < -this.parent[n2]) {
            return this.mergeRoots(n2, n);
        }
        int n3 = -this.parent[n];
        this.numClusters[n3] = this.numClusters[n3] - 1;
        int n4 = -this.parent[n2];
        this.numClusters[n4] = this.numClusters[n4] - 1;
        int n5 = -this.parent[n] - this.parent[n2];
        this.numClusters[n5] = this.numClusters[n5] + 1;
        this.secondClusterMoment += this.sqr(this.parent[n] + this.parent[n2]) - this.sqr(this.parent[n]) - this.sqr(this.parent[n2]);
        int n6 = n;
        this.parent[n6] = this.parent[n6] + this.parent[n2];
        this.parent[n2] = n;
        int n7 = n;
        this.touchesLeft[n7] = this.touchesLeft[n7] | this.touchesLeft[n2];
        int n8 = n;
        this.touchesRght[n8] = this.touchesRght[n8] | this.touchesRght[n2];
        if (this.touchesLeft[n] && this.touchesRght[n]) {
            this.spanningClusterSize = -this.parent[n];
        }
        return n;
    }
}

