/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.frames.Scalar2DFrame;
import org.opensourcephysics.stp.percolation.Clusters;

public class ClustersApp
extends AbstractSimulation {
    Scalar2DFrame grid = new Scalar2DFrame("Newman-Ziff cluster algorithm");
    PlotFrame plot1 = new PlotFrame("p", "Mean Cluster Size", "Mean cluster size");
    PlotFrame plot2 = new PlotFrame("p", "P_\u221e", "P\u221e");
    PlotFrame plot3 = new PlotFrame("p", "P_span", "P_span");
    PlotFrame plot4 = new PlotFrame("s", "      <n_{s}>", "Cluster size distribution");
    Clusters lattice;
    double pDisplay;
    double[] meanClusterSize;
    double[] P_infinity;
    double[] P_span;
    double[] numClustersAccum;
    int numberOfTrials;

    public void initialize() {
        int n = this.control.getInt("lattice size L");
        this.grid.resizeGrid(n, n);
        this.lattice = new Clusters(n);
        this.pDisplay = this.control.getDouble("display lattice at this value of p");
        this.grid.setMessage("p = " + this.pDisplay);
        this.plot1.setPreferredMinMaxX(0.0, 1.0);
        this.plot2.setPreferredMinMax(0.0, 1.0, 0.0, 1.0);
        this.plot3.setPreferredMinMax(0.0, 1.0, 0.0, 1.0);
        this.plot4.setPreferredMinMaxY(1.0, n);
        this.plot4.setMessage("p = " + this.pDisplay);
        this.plot4.setLogScale(true, true);
        this.meanClusterSize = new double[n * n];
        this.P_infinity = new double[n * n];
        this.P_span = new double[n * n];
        this.numClustersAccum = new double[n * n + 1];
        this.numberOfTrials = 0;
    }

    public void doStep() {
        this.control.clearMessages();
        this.control.println("Trial " + this.numberOfTrials);
        this.lattice.newLattice();
        int n = 0;
        while (n < this.lattice.N) {
            this.lattice.addRandomSite();
            int n2 = n;
            this.meanClusterSize[n2] = this.meanClusterSize[n2] + this.lattice.getMeanClusterSize();
            int n3 = n;
            this.P_infinity[n3] = this.P_infinity[n3] + (double)this.lattice.getSpanningClusterSize() / (double)this.lattice.numSitesOccupied;
            int n4 = n;
            this.P_span[n4] = this.P_span[n4] + (double)(this.lattice.getSpanningClusterSize() != 0 ? 1 : 0);
            if ((int)(this.pDisplay * (double)this.lattice.N) == n) {
                int n5 = 0;
                while (n5 < this.lattice.N) {
                    int n6 = n5;
                    this.numClustersAccum[n6] = this.numClustersAccum[n6] + (double)this.lattice.numClusters[n5];
                    ++n5;
                }
                this.displayLattice();
            }
            ++n;
        }
        ++this.numberOfTrials;
        this.plotAverages();
    }

    private void plotAverages() {
        this.plot1.clearData();
        this.plot2.clearData();
        this.plot3.clearData();
        this.plot4.clearData();
        int n = 1 + this.lattice.N / 10000;
        int n2 = 0;
        while (n2 < this.lattice.N) {
            double d = (double)n2 / (double)this.lattice.N;
            this.plot1.append(0, d, this.meanClusterSize[n2] / (double)this.numberOfTrials);
            this.plot2.append(0, d, this.P_infinity[n2] / (double)this.numberOfTrials);
            this.plot3.append(0, d, this.P_span[n2] / (double)this.numberOfTrials);
            n2 += n;
        }
        n2 = 0;
        while (n2 < this.lattice.N) {
            if (this.numClustersAccum[n2 + 1] > 0.0) {
                this.plot4.append(0, n2 + 1, this.numClustersAccum[n2 + 1] / (double)this.numberOfTrials);
            }
            ++n2;
        }
    }

    private void displayLattice() {
        double[] dArray = new double[this.lattice.N];
        int n = 0;
        while (n < this.lattice.N) {
            dArray[n] = this.lattice.getClusterSize(n);
            ++n;
        }
        this.grid.setAll(dArray);
    }

    public void reset() {
        this.control.setValue("lattice size L", 128);
        this.control.setValue("display lattice at this value of p", 0.5927);
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new ClustersApp());
    }
}

